/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.control.plane.rev150314.eidrecords;

import com.google.common.collect.Range;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.control.plane.rev150314.LispAddress;
import org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.control.plane.rev150314.eidrecords.EidRecord;
import org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.control.plane.rev150314.lispaddress.LispAddressContainer;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class EidRecordBuilder
implements Builder<EidRecord> {
    private LispAddressContainer _lispAddressContainer;
    private Short _mask;
    Map<Class<? extends Augmentation<EidRecord>>, Augmentation<EidRecord>> augmentation = Collections.emptyMap();

    public EidRecordBuilder() {
    }

    public EidRecordBuilder(LispAddress arg) {
        this._lispAddressContainer = arg.getLispAddressContainer();
    }

    public EidRecordBuilder(EidRecord base) {
        AugmentationHolder casted;
        this._lispAddressContainer = base.getLispAddressContainer();
        this._mask = base.getMask();
        if (base instanceof EidRecordImpl) {
            EidRecordImpl impl = (EidRecordImpl)base;
            if (!impl.augmentation.isEmpty()) {
                this.augmentation = new HashMap<Class<? extends Augmentation<EidRecord>>, Augmentation<EidRecord>>(impl.augmentation);
            }
        } else if (base instanceof AugmentationHolder && !(casted = (AugmentationHolder)base).augmentations().isEmpty()) {
            this.augmentation = new HashMap<Class<? extends Augmentation<EidRecord>>, Augmentation<EidRecord>>(casted.augmentations());
        }
    }

    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof LispAddress) {
            this._lispAddressContainer = ((LispAddress)arg).getLispAddressContainer();
            isValidArg = true;
        }
        if (!isValidArg) {
            throw new IllegalArgumentException("expected one of: [org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.control.plane.rev150314.LispAddress] \nbut was: " + arg);
        }
    }

    public LispAddressContainer getLispAddressContainer() {
        return this._lispAddressContainer;
    }

    public Short getMask() {
        return this._mask;
    }

    public <E extends Augmentation<EidRecord>> E getAugmentation(Class<E> augmentationType) {
        if (augmentationType == null) {
            throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
        }
        return (E)this.augmentation.get(augmentationType);
    }

    public EidRecordBuilder setLispAddressContainer(LispAddressContainer value) {
        this._lispAddressContainer = value;
        return this;
    }

    private static void checkMaskRange(short value) {
        if (value >= 0 && value <= 255) {
            return;
        }
        throw new IllegalArgumentException(String.format("Invalid range: %s, expected: [[0\u2025255]].", value));
    }

    public EidRecordBuilder setMask(Short value) {
        if (value != null) {
            EidRecordBuilder.checkMaskRange(value);
        }
        this._mask = value;
        return this;
    }

    @Deprecated
    public static List<Range<BigInteger>> _mask_range() {
        ArrayList<Range<BigInteger>> ret = new ArrayList<Range<BigInteger>>(1);
        ret.add(Range.closed((Comparable)BigInteger.ZERO, (Comparable)BigInteger.valueOf(255L)));
        return ret;
    }

    public EidRecordBuilder addAugmentation(Class<? extends Augmentation<EidRecord>> augmentationType, Augmentation<EidRecord> augmentation) {
        if (augmentation == null) {
            return this.removeAugmentation(augmentationType);
        }
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<EidRecord>>, Augmentation<EidRecord>>();
        }
        this.augmentation.put(augmentationType, augmentation);
        return this;
    }

    public EidRecordBuilder removeAugmentation(Class<? extends Augmentation<EidRecord>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    public EidRecord build() {
        return new EidRecordImpl(this);
    }

    private static final class EidRecordImpl
    implements EidRecord {
        private final LispAddressContainer _lispAddressContainer;
        private final Short _mask;
        private Map<Class<? extends Augmentation<EidRecord>>, Augmentation<EidRecord>> augmentation = Collections.emptyMap();
        private int hash = 0;
        private volatile boolean hashValid = false;

        public Class<EidRecord> getImplementedInterface() {
            return EidRecord.class;
        }

        private EidRecordImpl(EidRecordBuilder base) {
            this._lispAddressContainer = base.getLispAddressContainer();
            this._mask = base.getMask();
            switch (base.augmentation.size()) {
                case 0: {
                    this.augmentation = Collections.emptyMap();
                    break;
                }
                case 1: {
                    Map.Entry<Class<? extends Augmentation<EidRecord>>, Augmentation<EidRecord>> e = base.augmentation.entrySet().iterator().next();
                    this.augmentation = Collections.singletonMap(e.getKey(), e.getValue());
                    break;
                }
                default: {
                    this.augmentation = new HashMap<Class<? extends Augmentation<EidRecord>>, Augmentation<EidRecord>>(base.augmentation);
                }
            }
        }

        @Override
        public LispAddressContainer getLispAddressContainer() {
            return this._lispAddressContainer;
        }

        @Override
        public Short getMask() {
            return this._mask;
        }

        public <E extends Augmentation<EidRecord>> E getAugmentation(Class<E> augmentationType) {
            if (augmentationType == null) {
                throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
            }
            return (E)this.augmentation.get(augmentationType);
        }

        public int hashCode() {
            if (this.hashValid) {
                return this.hash;
            }
            int prime = 31;
            int result = 1;
            result = 31 * result + (this._lispAddressContainer == null ? 0 : this._lispAddressContainer.hashCode());
            result = 31 * result + (this._mask == null ? 0 : this._mask.hashCode());
            this.hash = result = 31 * result + (this.augmentation == null ? 0 : this.augmentation.hashCode());
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!EidRecord.class.equals((Object)((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            EidRecord other = (EidRecord)obj;
            if (this._lispAddressContainer == null ? other.getLispAddressContainer() != null : !this._lispAddressContainer.equals(other.getLispAddressContainer())) {
                return false;
            }
            if (this._mask == null ? other.getMask() != null : !this._mask.equals(other.getMask())) {
                return false;
            }
            if (this.getClass() == obj.getClass()) {
                EidRecordImpl otherImpl = (EidRecordImpl)obj;
                if (this.augmentation == null ? otherImpl.augmentation != null : !this.augmentation.equals(otherImpl.augmentation)) {
                    return false;
                }
            } else {
                for (Map.Entry<Class<? extends Augmentation<EidRecord>>, Augmentation<EidRecord>> e : this.augmentation.entrySet()) {
                    if (e.getValue().equals((Object)other.getAugmentation(e.getKey()))) continue;
                    return false;
                }
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }

        public String toString() {
            StringBuilder builder = new StringBuilder("EidRecord [");
            boolean first = true;
            if (this._lispAddressContainer != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_lispAddressContainer=");
                builder.append(this._lispAddressContainer);
            }
            if (this._mask != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_mask=");
                builder.append(this._mask);
            }
            if (first) {
                first = false;
            } else {
                builder.append(", ");
            }
            builder.append("augmentation=");
            builder.append(this.augmentation.values());
            return builder.append(']').toString();
        }
    }
}

