/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.control.plane.rev150314.eidtolocatorrecords;

import com.google.common.collect.Range;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.control.plane.rev150314.EidToLocatorRecord;
import org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.control.plane.rev150314.LispAddress;
import org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.control.plane.rev150314.LocatorRecords;
import org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.control.plane.rev150314.lispaddress.LispAddressContainer;
import org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.control.plane.rev150314.locatorrecords.LocatorRecord;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class EidToLocatorRecordBuilder
implements Builder<org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.control.plane.rev150314.eidtolocatorrecords.EidToLocatorRecord> {
    private EidToLocatorRecord.Action _action;
    private LispAddressContainer _lispAddressContainer;
    private List<LocatorRecord> _locatorRecord;
    private Short _mapVersion;
    private Short _maskLength;
    private Integer _recordTtl;
    private Boolean _authoritative;
    Map<Class<? extends Augmentation<org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.control.plane.rev150314.eidtolocatorrecords.EidToLocatorRecord>>, Augmentation<org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.control.plane.rev150314.eidtolocatorrecords.EidToLocatorRecord>> augmentation = Collections.emptyMap();

    public EidToLocatorRecordBuilder() {
    }

    public EidToLocatorRecordBuilder(EidToLocatorRecord arg) {
        this._recordTtl = arg.getRecordTtl();
        this._maskLength = arg.getMaskLength();
        this._mapVersion = arg.getMapVersion();
        this._action = arg.getAction();
        this._authoritative = arg.isAuthoritative();
        this._lispAddressContainer = arg.getLispAddressContainer();
        this._locatorRecord = arg.getLocatorRecord();
    }

    public EidToLocatorRecordBuilder(LispAddress arg) {
        this._lispAddressContainer = arg.getLispAddressContainer();
    }

    public EidToLocatorRecordBuilder(LocatorRecords arg) {
        this._locatorRecord = arg.getLocatorRecord();
    }

    public EidToLocatorRecordBuilder(org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.control.plane.rev150314.eidtolocatorrecords.EidToLocatorRecord base) {
        AugmentationHolder casted;
        this._action = base.getAction();
        this._lispAddressContainer = base.getLispAddressContainer();
        this._locatorRecord = base.getLocatorRecord();
        this._mapVersion = base.getMapVersion();
        this._maskLength = base.getMaskLength();
        this._recordTtl = base.getRecordTtl();
        this._authoritative = base.isAuthoritative();
        if (base instanceof EidToLocatorRecordImpl) {
            EidToLocatorRecordImpl impl = (EidToLocatorRecordImpl)base;
            if (!impl.augmentation.isEmpty()) {
                this.augmentation = new HashMap<Class<? extends Augmentation<org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.control.plane.rev150314.eidtolocatorrecords.EidToLocatorRecord>>, Augmentation<org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.control.plane.rev150314.eidtolocatorrecords.EidToLocatorRecord>>(impl.augmentation);
            }
        } else if (base instanceof AugmentationHolder && !(casted = (AugmentationHolder)base).augmentations().isEmpty()) {
            this.augmentation = new HashMap<Class<? extends Augmentation<org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.control.plane.rev150314.eidtolocatorrecords.EidToLocatorRecord>>, Augmentation<org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.control.plane.rev150314.eidtolocatorrecords.EidToLocatorRecord>>(casted.augmentations());
        }
    }

    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof LocatorRecords) {
            this._locatorRecord = ((LocatorRecords)arg).getLocatorRecord();
            isValidArg = true;
        }
        if (arg instanceof LispAddress) {
            this._lispAddressContainer = ((LispAddress)arg).getLispAddressContainer();
            isValidArg = true;
        }
        if (arg instanceof EidToLocatorRecord) {
            this._recordTtl = ((EidToLocatorRecord)arg).getRecordTtl();
            this._maskLength = ((EidToLocatorRecord)arg).getMaskLength();
            this._mapVersion = ((EidToLocatorRecord)arg).getMapVersion();
            this._action = ((EidToLocatorRecord)arg).getAction();
            this._authoritative = ((EidToLocatorRecord)arg).isAuthoritative();
            isValidArg = true;
        }
        if (!isValidArg) {
            throw new IllegalArgumentException("expected one of: [org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.control.plane.rev150314.LocatorRecords, org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.control.plane.rev150314.LispAddress, org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.control.plane.rev150314.EidToLocatorRecord] \nbut was: " + arg);
        }
    }

    public EidToLocatorRecord.Action getAction() {
        return this._action;
    }

    public LispAddressContainer getLispAddressContainer() {
        return this._lispAddressContainer;
    }

    public List<LocatorRecord> getLocatorRecord() {
        return this._locatorRecord;
    }

    public Short getMapVersion() {
        return this._mapVersion;
    }

    public Short getMaskLength() {
        return this._maskLength;
    }

    public Integer getRecordTtl() {
        return this._recordTtl;
    }

    public Boolean isAuthoritative() {
        return this._authoritative;
    }

    public <E extends Augmentation<org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.control.plane.rev150314.eidtolocatorrecords.EidToLocatorRecord>> E getAugmentation(Class<E> augmentationType) {
        if (augmentationType == null) {
            throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
        }
        return (E)this.augmentation.get(augmentationType);
    }

    public EidToLocatorRecordBuilder setAction(EidToLocatorRecord.Action value) {
        this._action = value;
        return this;
    }

    public EidToLocatorRecordBuilder setLispAddressContainer(LispAddressContainer value) {
        this._lispAddressContainer = value;
        return this;
    }

    public EidToLocatorRecordBuilder setLocatorRecord(List<LocatorRecord> value) {
        this._locatorRecord = value;
        return this;
    }

    public EidToLocatorRecordBuilder setMapVersion(Short value) {
        this._mapVersion = value;
        return this;
    }

    private static void checkMaskLengthRange(short value) {
        if (value >= 0 && value <= 255) {
            return;
        }
        throw new IllegalArgumentException(String.format("Invalid range: %s, expected: [[0\u2025255]].", value));
    }

    public EidToLocatorRecordBuilder setMaskLength(Short value) {
        if (value != null) {
            EidToLocatorRecordBuilder.checkMaskLengthRange(value);
        }
        this._maskLength = value;
        return this;
    }

    @Deprecated
    public static List<Range<BigInteger>> _maskLength_range() {
        ArrayList<Range<BigInteger>> ret = new ArrayList<Range<BigInteger>>(1);
        ret.add(Range.closed((Comparable)BigInteger.ZERO, (Comparable)BigInteger.valueOf(255L)));
        return ret;
    }

    public EidToLocatorRecordBuilder setRecordTtl(Integer value) {
        this._recordTtl = value;
        return this;
    }

    public EidToLocatorRecordBuilder setAuthoritative(Boolean value) {
        this._authoritative = value;
        return this;
    }

    public EidToLocatorRecordBuilder addAugmentation(Class<? extends Augmentation<org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.control.plane.rev150314.eidtolocatorrecords.EidToLocatorRecord>> augmentationType, Augmentation<org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.control.plane.rev150314.eidtolocatorrecords.EidToLocatorRecord> augmentation) {
        if (augmentation == null) {
            return this.removeAugmentation(augmentationType);
        }
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.control.plane.rev150314.eidtolocatorrecords.EidToLocatorRecord>>, Augmentation<org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.control.plane.rev150314.eidtolocatorrecords.EidToLocatorRecord>>();
        }
        this.augmentation.put(augmentationType, augmentation);
        return this;
    }

    public EidToLocatorRecordBuilder removeAugmentation(Class<? extends Augmentation<org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.control.plane.rev150314.eidtolocatorrecords.EidToLocatorRecord>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    public org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.control.plane.rev150314.eidtolocatorrecords.EidToLocatorRecord build() {
        return new EidToLocatorRecordImpl(this);
    }

    private static final class EidToLocatorRecordImpl
    implements org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.control.plane.rev150314.eidtolocatorrecords.EidToLocatorRecord {
        private final EidToLocatorRecord.Action _action;
        private final LispAddressContainer _lispAddressContainer;
        private final List<LocatorRecord> _locatorRecord;
        private final Short _mapVersion;
        private final Short _maskLength;
        private final Integer _recordTtl;
        private final Boolean _authoritative;
        private Map<Class<? extends Augmentation<org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.control.plane.rev150314.eidtolocatorrecords.EidToLocatorRecord>>, Augmentation<org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.control.plane.rev150314.eidtolocatorrecords.EidToLocatorRecord>> augmentation = Collections.emptyMap();
        private int hash = 0;
        private volatile boolean hashValid = false;

        public Class<org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.control.plane.rev150314.eidtolocatorrecords.EidToLocatorRecord> getImplementedInterface() {
            return org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.control.plane.rev150314.eidtolocatorrecords.EidToLocatorRecord.class;
        }

        private EidToLocatorRecordImpl(EidToLocatorRecordBuilder base) {
            this._action = base.getAction();
            this._lispAddressContainer = base.getLispAddressContainer();
            this._locatorRecord = base.getLocatorRecord();
            this._mapVersion = base.getMapVersion();
            this._maskLength = base.getMaskLength();
            this._recordTtl = base.getRecordTtl();
            this._authoritative = base.isAuthoritative();
            switch (base.augmentation.size()) {
                case 0: {
                    this.augmentation = Collections.emptyMap();
                    break;
                }
                case 1: {
                    Map.Entry<Class<? extends Augmentation<org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.control.plane.rev150314.eidtolocatorrecords.EidToLocatorRecord>>, Augmentation<org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.control.plane.rev150314.eidtolocatorrecords.EidToLocatorRecord>> e = base.augmentation.entrySet().iterator().next();
                    this.augmentation = Collections.singletonMap(e.getKey(), e.getValue());
                    break;
                }
                default: {
                    this.augmentation = new HashMap<Class<? extends Augmentation<org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.control.plane.rev150314.eidtolocatorrecords.EidToLocatorRecord>>, Augmentation<org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.control.plane.rev150314.eidtolocatorrecords.EidToLocatorRecord>>(base.augmentation);
                }
            }
        }

        @Override
        public EidToLocatorRecord.Action getAction() {
            return this._action;
        }

        @Override
        public LispAddressContainer getLispAddressContainer() {
            return this._lispAddressContainer;
        }

        @Override
        public List<LocatorRecord> getLocatorRecord() {
            return this._locatorRecord;
        }

        @Override
        public Short getMapVersion() {
            return this._mapVersion;
        }

        @Override
        public Short getMaskLength() {
            return this._maskLength;
        }

        @Override
        public Integer getRecordTtl() {
            return this._recordTtl;
        }

        @Override
        public Boolean isAuthoritative() {
            return this._authoritative;
        }

        public <E extends Augmentation<org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.control.plane.rev150314.eidtolocatorrecords.EidToLocatorRecord>> E getAugmentation(Class<E> augmentationType) {
            if (augmentationType == null) {
                throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
            }
            return (E)this.augmentation.get(augmentationType);
        }

        public int hashCode() {
            if (this.hashValid) {
                return this.hash;
            }
            int prime = 31;
            int result = 1;
            result = 31 * result + (this._action == null ? 0 : this._action.hashCode());
            result = 31 * result + (this._lispAddressContainer == null ? 0 : this._lispAddressContainer.hashCode());
            result = 31 * result + (this._locatorRecord == null ? 0 : this._locatorRecord.hashCode());
            result = 31 * result + (this._mapVersion == null ? 0 : this._mapVersion.hashCode());
            result = 31 * result + (this._maskLength == null ? 0 : this._maskLength.hashCode());
            result = 31 * result + (this._recordTtl == null ? 0 : this._recordTtl.hashCode());
            result = 31 * result + (this._authoritative == null ? 0 : this._authoritative.hashCode());
            this.hash = result = 31 * result + (this.augmentation == null ? 0 : this.augmentation.hashCode());
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.control.plane.rev150314.eidtolocatorrecords.EidToLocatorRecord.class.equals((Object)((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.control.plane.rev150314.eidtolocatorrecords.EidToLocatorRecord other = (org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.control.plane.rev150314.eidtolocatorrecords.EidToLocatorRecord)obj;
            if (this._action == null ? other.getAction() != null : !this._action.equals((Object)other.getAction())) {
                return false;
            }
            if (this._lispAddressContainer == null ? other.getLispAddressContainer() != null : !this._lispAddressContainer.equals(other.getLispAddressContainer())) {
                return false;
            }
            if (this._locatorRecord == null ? other.getLocatorRecord() != null : !this._locatorRecord.equals(other.getLocatorRecord())) {
                return false;
            }
            if (this._mapVersion == null ? other.getMapVersion() != null : !this._mapVersion.equals(other.getMapVersion())) {
                return false;
            }
            if (this._maskLength == null ? other.getMaskLength() != null : !this._maskLength.equals(other.getMaskLength())) {
                return false;
            }
            if (this._recordTtl == null ? other.getRecordTtl() != null : !this._recordTtl.equals(other.getRecordTtl())) {
                return false;
            }
            if (this._authoritative == null ? other.isAuthoritative() != null : !this._authoritative.equals(other.isAuthoritative())) {
                return false;
            }
            if (this.getClass() == obj.getClass()) {
                EidToLocatorRecordImpl otherImpl = (EidToLocatorRecordImpl)obj;
                if (this.augmentation == null ? otherImpl.augmentation != null : !this.augmentation.equals(otherImpl.augmentation)) {
                    return false;
                }
            } else {
                for (Map.Entry<Class<? extends Augmentation<org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.control.plane.rev150314.eidtolocatorrecords.EidToLocatorRecord>>, Augmentation<org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.control.plane.rev150314.eidtolocatorrecords.EidToLocatorRecord>> e : this.augmentation.entrySet()) {
                    if (e.getValue().equals((Object)other.getAugmentation(e.getKey()))) continue;
                    return false;
                }
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }

        public String toString() {
            StringBuilder builder = new StringBuilder("EidToLocatorRecord [");
            boolean first = true;
            if (this._action != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_action=");
                builder.append((Object)this._action);
            }
            if (this._lispAddressContainer != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_lispAddressContainer=");
                builder.append(this._lispAddressContainer);
            }
            if (this._locatorRecord != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_locatorRecord=");
                builder.append(this._locatorRecord);
            }
            if (this._mapVersion != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_mapVersion=");
                builder.append(this._mapVersion);
            }
            if (this._maskLength != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_maskLength=");
                builder.append(this._maskLength);
            }
            if (this._recordTtl != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_recordTtl=");
                builder.append(this._recordTtl);
            }
            if (this._authoritative != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_authoritative=");
                builder.append(this._authoritative);
            }
            if (first) {
                first = false;
            } else {
                builder.append(", ");
            }
            builder.append("augmentation=");
            builder.append(this.augmentation.values());
            return builder.append(']').toString();
        }
    }
}

