/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.control.plane.rev150314.lispaddress;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.control.plane.rev150314.lispaddress.LispAddressContainer;
import org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.control.plane.rev150314.lispaddress.lispaddresscontainer.Address;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class LispAddressContainerBuilder
implements Builder<LispAddressContainer> {
    private Address _address;
    Map<Class<? extends Augmentation<LispAddressContainer>>, Augmentation<LispAddressContainer>> augmentation = Collections.emptyMap();

    public LispAddressContainerBuilder() {
    }

    public LispAddressContainerBuilder(LispAddressContainer base) {
        AugmentationHolder casted;
        this._address = base.getAddress();
        if (base instanceof LispAddressContainerImpl) {
            LispAddressContainerImpl impl = (LispAddressContainerImpl)base;
            if (!impl.augmentation.isEmpty()) {
                this.augmentation = new HashMap<Class<? extends Augmentation<LispAddressContainer>>, Augmentation<LispAddressContainer>>(impl.augmentation);
            }
        } else if (base instanceof AugmentationHolder && !(casted = (AugmentationHolder)base).augmentations().isEmpty()) {
            this.augmentation = new HashMap<Class<? extends Augmentation<LispAddressContainer>>, Augmentation<LispAddressContainer>>(casted.augmentations());
        }
    }

    public Address getAddress() {
        return this._address;
    }

    public <E extends Augmentation<LispAddressContainer>> E getAugmentation(Class<E> augmentationType) {
        if (augmentationType == null) {
            throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
        }
        return (E)this.augmentation.get(augmentationType);
    }

    public LispAddressContainerBuilder setAddress(Address value) {
        this._address = value;
        return this;
    }

    public LispAddressContainerBuilder addAugmentation(Class<? extends Augmentation<LispAddressContainer>> augmentationType, Augmentation<LispAddressContainer> augmentation) {
        if (augmentation == null) {
            return this.removeAugmentation(augmentationType);
        }
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<LispAddressContainer>>, Augmentation<LispAddressContainer>>();
        }
        this.augmentation.put(augmentationType, augmentation);
        return this;
    }

    public LispAddressContainerBuilder removeAugmentation(Class<? extends Augmentation<LispAddressContainer>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    public LispAddressContainer build() {
        return new LispAddressContainerImpl(this);
    }

    private static final class LispAddressContainerImpl
    implements LispAddressContainer {
        private final Address _address;
        private Map<Class<? extends Augmentation<LispAddressContainer>>, Augmentation<LispAddressContainer>> augmentation = Collections.emptyMap();
        private int hash = 0;
        private volatile boolean hashValid = false;

        public Class<LispAddressContainer> getImplementedInterface() {
            return LispAddressContainer.class;
        }

        private LispAddressContainerImpl(LispAddressContainerBuilder base) {
            this._address = base.getAddress();
            switch (base.augmentation.size()) {
                case 0: {
                    this.augmentation = Collections.emptyMap();
                    break;
                }
                case 1: {
                    Map.Entry<Class<? extends Augmentation<LispAddressContainer>>, Augmentation<LispAddressContainer>> e = base.augmentation.entrySet().iterator().next();
                    this.augmentation = Collections.singletonMap(e.getKey(), e.getValue());
                    break;
                }
                default: {
                    this.augmentation = new HashMap<Class<? extends Augmentation<LispAddressContainer>>, Augmentation<LispAddressContainer>>(base.augmentation);
                }
            }
        }

        @Override
        public Address getAddress() {
            return this._address;
        }

        public <E extends Augmentation<LispAddressContainer>> E getAugmentation(Class<E> augmentationType) {
            if (augmentationType == null) {
                throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
            }
            return (E)this.augmentation.get(augmentationType);
        }

        public int hashCode() {
            if (this.hashValid) {
                return this.hash;
            }
            int prime = 31;
            int result = 1;
            result = 31 * result + (this._address == null ? 0 : this._address.hashCode());
            this.hash = result = 31 * result + (this.augmentation == null ? 0 : this.augmentation.hashCode());
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!LispAddressContainer.class.equals((Object)((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            LispAddressContainer other = (LispAddressContainer)obj;
            if (this._address == null ? other.getAddress() != null : !this._address.equals(other.getAddress())) {
                return false;
            }
            if (this.getClass() == obj.getClass()) {
                LispAddressContainerImpl otherImpl = (LispAddressContainerImpl)obj;
                if (this.augmentation == null ? otherImpl.augmentation != null : !this.augmentation.equals(otherImpl.augmentation)) {
                    return false;
                }
            } else {
                for (Map.Entry<Class<? extends Augmentation<LispAddressContainer>>, Augmentation<LispAddressContainer>> e : this.augmentation.entrySet()) {
                    if (e.getValue().equals((Object)other.getAugmentation(e.getKey()))) continue;
                    return false;
                }
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }

        public String toString() {
            StringBuilder builder = new StringBuilder("LispAddressContainer [");
            boolean first = true;
            if (this._address != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_address=");
                builder.append(this._address);
            }
            if (first) {
                first = false;
            } else {
                builder.append(", ");
            }
            builder.append("augmentation=");
            builder.append(this.augmentation.values());
            return builder.append(']').toString();
        }
    }
}

