/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.control.plane.rev150314.lispaddress.lispaddresscontainer.address;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.control.plane.rev150314.lispaddress.lispaddresscontainer.address.Mac;
import org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.control.plane.rev150314.lispaddress.lispaddresscontainer.address.mac.MacAddress;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class MacBuilder
implements Builder<Mac> {
    private MacAddress _macAddress;
    Map<Class<? extends Augmentation<Mac>>, Augmentation<Mac>> augmentation = Collections.emptyMap();

    public MacBuilder() {
    }

    public MacBuilder(Mac base) {
        AugmentationHolder casted;
        this._macAddress = base.getMacAddress();
        if (base instanceof MacImpl) {
            MacImpl impl = (MacImpl)base;
            if (!impl.augmentation.isEmpty()) {
                this.augmentation = new HashMap<Class<? extends Augmentation<Mac>>, Augmentation<Mac>>(impl.augmentation);
            }
        } else if (base instanceof AugmentationHolder && !(casted = (AugmentationHolder)base).augmentations().isEmpty()) {
            this.augmentation = new HashMap<Class<? extends Augmentation<Mac>>, Augmentation<Mac>>(casted.augmentations());
        }
    }

    public MacAddress getMacAddress() {
        return this._macAddress;
    }

    public <E extends Augmentation<Mac>> E getAugmentation(Class<E> augmentationType) {
        if (augmentationType == null) {
            throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
        }
        return (E)this.augmentation.get(augmentationType);
    }

    public MacBuilder setMacAddress(MacAddress value) {
        this._macAddress = value;
        return this;
    }

    public MacBuilder addAugmentation(Class<? extends Augmentation<Mac>> augmentationType, Augmentation<Mac> augmentation) {
        if (augmentation == null) {
            return this.removeAugmentation(augmentationType);
        }
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<Mac>>, Augmentation<Mac>>();
        }
        this.augmentation.put(augmentationType, augmentation);
        return this;
    }

    public MacBuilder removeAugmentation(Class<? extends Augmentation<Mac>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    public Mac build() {
        return new MacImpl(this);
    }

    private static final class MacImpl
    implements Mac {
        private final MacAddress _macAddress;
        private Map<Class<? extends Augmentation<Mac>>, Augmentation<Mac>> augmentation = Collections.emptyMap();
        private int hash = 0;
        private volatile boolean hashValid = false;

        public Class<Mac> getImplementedInterface() {
            return Mac.class;
        }

        private MacImpl(MacBuilder base) {
            this._macAddress = base.getMacAddress();
            switch (base.augmentation.size()) {
                case 0: {
                    this.augmentation = Collections.emptyMap();
                    break;
                }
                case 1: {
                    Map.Entry<Class<? extends Augmentation<Mac>>, Augmentation<Mac>> e = base.augmentation.entrySet().iterator().next();
                    this.augmentation = Collections.singletonMap(e.getKey(), e.getValue());
                    break;
                }
                default: {
                    this.augmentation = new HashMap<Class<? extends Augmentation<Mac>>, Augmentation<Mac>>(base.augmentation);
                }
            }
        }

        @Override
        public MacAddress getMacAddress() {
            return this._macAddress;
        }

        public <E extends Augmentation<Mac>> E getAugmentation(Class<E> augmentationType) {
            if (augmentationType == null) {
                throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
            }
            return (E)this.augmentation.get(augmentationType);
        }

        public int hashCode() {
            if (this.hashValid) {
                return this.hash;
            }
            int prime = 31;
            int result = 1;
            result = 31 * result + (this._macAddress == null ? 0 : this._macAddress.hashCode());
            this.hash = result = 31 * result + (this.augmentation == null ? 0 : this.augmentation.hashCode());
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!Mac.class.equals((Object)((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            Mac other = (Mac)obj;
            if (this._macAddress == null ? other.getMacAddress() != null : !this._macAddress.equals(other.getMacAddress())) {
                return false;
            }
            if (this.getClass() == obj.getClass()) {
                MacImpl otherImpl = (MacImpl)obj;
                if (this.augmentation == null ? otherImpl.augmentation != null : !this.augmentation.equals(otherImpl.augmentation)) {
                    return false;
                }
            } else {
                for (Map.Entry<Class<? extends Augmentation<Mac>>, Augmentation<Mac>> e : this.augmentation.entrySet()) {
                    if (e.getValue().equals((Object)other.getAugmentation(e.getKey()))) continue;
                    return false;
                }
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }

        public String toString() {
            StringBuilder builder = new StringBuilder("Mac [");
            boolean first = true;
            if (this._macAddress != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_macAddress=");
                builder.append(this._macAddress);
            }
            if (first) {
                first = false;
            } else {
                builder.append(", ");
            }
            builder.append("augmentation=");
            builder.append(this.augmentation.values());
            return builder.append(']').toString();
        }
    }
}

