/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.control.plane.rev150314.lispaddress.lispaddresscontainer.address.lcafapplicationdata;

import com.google.common.collect.Range;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.inet.types.rev100924.PortNumber;
import org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.control.plane.rev150314.LcafApplicationDataAddress;
import org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.control.plane.rev150314.LispAFIAddress;
import org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.control.plane.rev150314.LispLcafAddress;
import org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.control.plane.rev150314.lcafapplicationdataaddress.Address;
import org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.control.plane.rev150314.lispaddress.lispaddresscontainer.address.lcafapplicationdata.LcafApplicationDataAddr;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class LcafApplicationDataAddrBuilder
implements Builder<LcafApplicationDataAddr> {
    private Address _address;
    private Short _afi;
    private Integer _ipTos;
    private Short _lcafType;
    private PortNumber _localPortHigh;
    private PortNumber _localPortLow;
    private Short _protocol;
    private PortNumber _remotePortHigh;
    private PortNumber _remotePortLow;
    Map<Class<? extends Augmentation<LcafApplicationDataAddr>>, Augmentation<LcafApplicationDataAddr>> augmentation = Collections.emptyMap();

    public LcafApplicationDataAddrBuilder() {
    }

    public LcafApplicationDataAddrBuilder(LcafApplicationDataAddress arg) {
        this._address = arg.getAddress();
        this._protocol = arg.getProtocol();
        this._ipTos = arg.getIpTos();
        this._localPortLow = arg.getLocalPortLow();
        this._localPortHigh = arg.getLocalPortHigh();
        this._remotePortLow = arg.getRemotePortLow();
        this._remotePortHigh = arg.getRemotePortHigh();
        this._lcafType = arg.getLcafType();
        this._afi = arg.getAfi();
    }

    public LcafApplicationDataAddrBuilder(LispLcafAddress arg) {
        this._lcafType = arg.getLcafType();
        this._afi = arg.getAfi();
    }

    public LcafApplicationDataAddrBuilder(LispAFIAddress arg) {
        this._afi = arg.getAfi();
    }

    public LcafApplicationDataAddrBuilder(LcafApplicationDataAddr base) {
        AugmentationHolder casted;
        this._address = base.getAddress();
        this._afi = base.getAfi();
        this._ipTos = base.getIpTos();
        this._lcafType = base.getLcafType();
        this._localPortHigh = base.getLocalPortHigh();
        this._localPortLow = base.getLocalPortLow();
        this._protocol = base.getProtocol();
        this._remotePortHigh = base.getRemotePortHigh();
        this._remotePortLow = base.getRemotePortLow();
        if (base instanceof LcafApplicationDataAddrImpl) {
            LcafApplicationDataAddrImpl impl = (LcafApplicationDataAddrImpl)base;
            if (!impl.augmentation.isEmpty()) {
                this.augmentation = new HashMap<Class<? extends Augmentation<LcafApplicationDataAddr>>, Augmentation<LcafApplicationDataAddr>>(impl.augmentation);
            }
        } else if (base instanceof AugmentationHolder && !(casted = (AugmentationHolder)base).augmentations().isEmpty()) {
            this.augmentation = new HashMap<Class<? extends Augmentation<LcafApplicationDataAddr>>, Augmentation<LcafApplicationDataAddr>>(casted.augmentations());
        }
    }

    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof LcafApplicationDataAddress) {
            this._address = ((LcafApplicationDataAddress)arg).getAddress();
            this._protocol = ((LcafApplicationDataAddress)arg).getProtocol();
            this._ipTos = ((LcafApplicationDataAddress)arg).getIpTos();
            this._localPortLow = ((LcafApplicationDataAddress)arg).getLocalPortLow();
            this._localPortHigh = ((LcafApplicationDataAddress)arg).getLocalPortHigh();
            this._remotePortLow = ((LcafApplicationDataAddress)arg).getRemotePortLow();
            this._remotePortHigh = ((LcafApplicationDataAddress)arg).getRemotePortHigh();
            isValidArg = true;
        }
        if (arg instanceof LispAFIAddress) {
            this._afi = ((LispAFIAddress)arg).getAfi();
            isValidArg = true;
        }
        if (arg instanceof LispLcafAddress) {
            this._lcafType = ((LispLcafAddress)arg).getLcafType();
            isValidArg = true;
        }
        if (!isValidArg) {
            throw new IllegalArgumentException("expected one of: [org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.control.plane.rev150314.LcafApplicationDataAddress, org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.control.plane.rev150314.LispAFIAddress, org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.control.plane.rev150314.LispLcafAddress] \nbut was: " + arg);
        }
    }

    public Address getAddress() {
        return this._address;
    }

    public Short getAfi() {
        return this._afi;
    }

    public Integer getIpTos() {
        return this._ipTos;
    }

    public Short getLcafType() {
        return this._lcafType;
    }

    public PortNumber getLocalPortHigh() {
        return this._localPortHigh;
    }

    public PortNumber getLocalPortLow() {
        return this._localPortLow;
    }

    public Short getProtocol() {
        return this._protocol;
    }

    public PortNumber getRemotePortHigh() {
        return this._remotePortHigh;
    }

    public PortNumber getRemotePortLow() {
        return this._remotePortLow;
    }

    public <E extends Augmentation<LcafApplicationDataAddr>> E getAugmentation(Class<E> augmentationType) {
        if (augmentationType == null) {
            throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
        }
        return (E)this.augmentation.get(augmentationType);
    }

    public LcafApplicationDataAddrBuilder setAddress(Address value) {
        this._address = value;
        return this;
    }

    public LcafApplicationDataAddrBuilder setAfi(Short value) {
        this._afi = value;
        return this;
    }

    public LcafApplicationDataAddrBuilder setIpTos(Integer value) {
        this._ipTos = value;
        return this;
    }

    private static void checkLcafTypeRange(short value) {
        if (value >= 0 && value <= 255) {
            return;
        }
        throw new IllegalArgumentException(String.format("Invalid range: %s, expected: [[0\u2025255]].", value));
    }

    public LcafApplicationDataAddrBuilder setLcafType(Short value) {
        if (value != null) {
            LcafApplicationDataAddrBuilder.checkLcafTypeRange(value);
        }
        this._lcafType = value;
        return this;
    }

    @Deprecated
    public static List<Range<BigInteger>> _lcafType_range() {
        ArrayList<Range<BigInteger>> ret = new ArrayList<Range<BigInteger>>(1);
        ret.add(Range.closed((Comparable)BigInteger.ZERO, (Comparable)BigInteger.valueOf(255L)));
        return ret;
    }

    private static void checkLocalPortHighRange(int value) {
        if (value >= 0 && value <= 65535) {
            return;
        }
        throw new IllegalArgumentException(String.format("Invalid range: %s, expected: [[0\u202565535]].", value));
    }

    public LcafApplicationDataAddrBuilder setLocalPortHigh(PortNumber value) {
        if (value != null) {
            LcafApplicationDataAddrBuilder.checkLocalPortHighRange(value.getValue());
        }
        this._localPortHigh = value;
        return this;
    }

    @Deprecated
    public static List<Range<BigInteger>> _localPortHigh_range() {
        ArrayList<Range<BigInteger>> ret = new ArrayList<Range<BigInteger>>(1);
        ret.add(Range.closed((Comparable)BigInteger.ZERO, (Comparable)BigInteger.valueOf(65535L)));
        return ret;
    }

    private static void checkLocalPortLowRange(int value) {
        if (value >= 0 && value <= 65535) {
            return;
        }
        throw new IllegalArgumentException(String.format("Invalid range: %s, expected: [[0\u202565535]].", value));
    }

    public LcafApplicationDataAddrBuilder setLocalPortLow(PortNumber value) {
        if (value != null) {
            LcafApplicationDataAddrBuilder.checkLocalPortLowRange(value.getValue());
        }
        this._localPortLow = value;
        return this;
    }

    @Deprecated
    public static List<Range<BigInteger>> _localPortLow_range() {
        ArrayList<Range<BigInteger>> ret = new ArrayList<Range<BigInteger>>(1);
        ret.add(Range.closed((Comparable)BigInteger.ZERO, (Comparable)BigInteger.valueOf(65535L)));
        return ret;
    }

    private static void checkProtocolRange(short value) {
        if (value >= 0 && value <= 255) {
            return;
        }
        throw new IllegalArgumentException(String.format("Invalid range: %s, expected: [[0\u2025255]].", value));
    }

    public LcafApplicationDataAddrBuilder setProtocol(Short value) {
        if (value != null) {
            LcafApplicationDataAddrBuilder.checkProtocolRange(value);
        }
        this._protocol = value;
        return this;
    }

    @Deprecated
    public static List<Range<BigInteger>> _protocol_range() {
        ArrayList<Range<BigInteger>> ret = new ArrayList<Range<BigInteger>>(1);
        ret.add(Range.closed((Comparable)BigInteger.ZERO, (Comparable)BigInteger.valueOf(255L)));
        return ret;
    }

    private static void checkRemotePortHighRange(int value) {
        if (value >= 0 && value <= 65535) {
            return;
        }
        throw new IllegalArgumentException(String.format("Invalid range: %s, expected: [[0\u202565535]].", value));
    }

    public LcafApplicationDataAddrBuilder setRemotePortHigh(PortNumber value) {
        if (value != null) {
            LcafApplicationDataAddrBuilder.checkRemotePortHighRange(value.getValue());
        }
        this._remotePortHigh = value;
        return this;
    }

    @Deprecated
    public static List<Range<BigInteger>> _remotePortHigh_range() {
        ArrayList<Range<BigInteger>> ret = new ArrayList<Range<BigInteger>>(1);
        ret.add(Range.closed((Comparable)BigInteger.ZERO, (Comparable)BigInteger.valueOf(65535L)));
        return ret;
    }

    private static void checkRemotePortLowRange(int value) {
        if (value >= 0 && value <= 65535) {
            return;
        }
        throw new IllegalArgumentException(String.format("Invalid range: %s, expected: [[0\u202565535]].", value));
    }

    public LcafApplicationDataAddrBuilder setRemotePortLow(PortNumber value) {
        if (value != null) {
            LcafApplicationDataAddrBuilder.checkRemotePortLowRange(value.getValue());
        }
        this._remotePortLow = value;
        return this;
    }

    @Deprecated
    public static List<Range<BigInteger>> _remotePortLow_range() {
        ArrayList<Range<BigInteger>> ret = new ArrayList<Range<BigInteger>>(1);
        ret.add(Range.closed((Comparable)BigInteger.ZERO, (Comparable)BigInteger.valueOf(65535L)));
        return ret;
    }

    public LcafApplicationDataAddrBuilder addAugmentation(Class<? extends Augmentation<LcafApplicationDataAddr>> augmentationType, Augmentation<LcafApplicationDataAddr> augmentation) {
        if (augmentation == null) {
            return this.removeAugmentation(augmentationType);
        }
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<LcafApplicationDataAddr>>, Augmentation<LcafApplicationDataAddr>>();
        }
        this.augmentation.put(augmentationType, augmentation);
        return this;
    }

    public LcafApplicationDataAddrBuilder removeAugmentation(Class<? extends Augmentation<LcafApplicationDataAddr>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    public LcafApplicationDataAddr build() {
        return new LcafApplicationDataAddrImpl(this);
    }

    private static final class LcafApplicationDataAddrImpl
    implements LcafApplicationDataAddr {
        private final Address _address;
        private final Short _afi;
        private final Integer _ipTos;
        private final Short _lcafType;
        private final PortNumber _localPortHigh;
        private final PortNumber _localPortLow;
        private final Short _protocol;
        private final PortNumber _remotePortHigh;
        private final PortNumber _remotePortLow;
        private Map<Class<? extends Augmentation<LcafApplicationDataAddr>>, Augmentation<LcafApplicationDataAddr>> augmentation = Collections.emptyMap();
        private int hash = 0;
        private volatile boolean hashValid = false;

        public Class<LcafApplicationDataAddr> getImplementedInterface() {
            return LcafApplicationDataAddr.class;
        }

        private LcafApplicationDataAddrImpl(LcafApplicationDataAddrBuilder base) {
            this._address = base.getAddress();
            this._afi = base.getAfi();
            this._ipTos = base.getIpTos();
            this._lcafType = base.getLcafType();
            this._localPortHigh = base.getLocalPortHigh();
            this._localPortLow = base.getLocalPortLow();
            this._protocol = base.getProtocol();
            this._remotePortHigh = base.getRemotePortHigh();
            this._remotePortLow = base.getRemotePortLow();
            switch (base.augmentation.size()) {
                case 0: {
                    this.augmentation = Collections.emptyMap();
                    break;
                }
                case 1: {
                    Map.Entry<Class<? extends Augmentation<LcafApplicationDataAddr>>, Augmentation<LcafApplicationDataAddr>> e = base.augmentation.entrySet().iterator().next();
                    this.augmentation = Collections.singletonMap(e.getKey(), e.getValue());
                    break;
                }
                default: {
                    this.augmentation = new HashMap<Class<? extends Augmentation<LcafApplicationDataAddr>>, Augmentation<LcafApplicationDataAddr>>(base.augmentation);
                }
            }
        }

        @Override
        public Address getAddress() {
            return this._address;
        }

        @Override
        public Short getAfi() {
            return this._afi;
        }

        @Override
        public Integer getIpTos() {
            return this._ipTos;
        }

        @Override
        public Short getLcafType() {
            return this._lcafType;
        }

        @Override
        public PortNumber getLocalPortHigh() {
            return this._localPortHigh;
        }

        @Override
        public PortNumber getLocalPortLow() {
            return this._localPortLow;
        }

        @Override
        public Short getProtocol() {
            return this._protocol;
        }

        @Override
        public PortNumber getRemotePortHigh() {
            return this._remotePortHigh;
        }

        @Override
        public PortNumber getRemotePortLow() {
            return this._remotePortLow;
        }

        public <E extends Augmentation<LcafApplicationDataAddr>> E getAugmentation(Class<E> augmentationType) {
            if (augmentationType == null) {
                throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
            }
            return (E)this.augmentation.get(augmentationType);
        }

        public int hashCode() {
            if (this.hashValid) {
                return this.hash;
            }
            int prime = 31;
            int result = 1;
            result = 31 * result + (this._address == null ? 0 : this._address.hashCode());
            result = 31 * result + (this._afi == null ? 0 : this._afi.hashCode());
            result = 31 * result + (this._ipTos == null ? 0 : this._ipTos.hashCode());
            result = 31 * result + (this._lcafType == null ? 0 : this._lcafType.hashCode());
            result = 31 * result + (this._localPortHigh == null ? 0 : this._localPortHigh.hashCode());
            result = 31 * result + (this._localPortLow == null ? 0 : this._localPortLow.hashCode());
            result = 31 * result + (this._protocol == null ? 0 : this._protocol.hashCode());
            result = 31 * result + (this._remotePortHigh == null ? 0 : this._remotePortHigh.hashCode());
            result = 31 * result + (this._remotePortLow == null ? 0 : this._remotePortLow.hashCode());
            this.hash = result = 31 * result + (this.augmentation == null ? 0 : this.augmentation.hashCode());
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!LcafApplicationDataAddr.class.equals((Object)((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            LcafApplicationDataAddr other = (LcafApplicationDataAddr)obj;
            if (this._address == null ? other.getAddress() != null : !this._address.equals(other.getAddress())) {
                return false;
            }
            if (this._afi == null ? other.getAfi() != null : !this._afi.equals(other.getAfi())) {
                return false;
            }
            if (this._ipTos == null ? other.getIpTos() != null : !this._ipTos.equals(other.getIpTos())) {
                return false;
            }
            if (this._lcafType == null ? other.getLcafType() != null : !this._lcafType.equals(other.getLcafType())) {
                return false;
            }
            if (this._localPortHigh == null ? other.getLocalPortHigh() != null : !this._localPortHigh.equals((Object)other.getLocalPortHigh())) {
                return false;
            }
            if (this._localPortLow == null ? other.getLocalPortLow() != null : !this._localPortLow.equals((Object)other.getLocalPortLow())) {
                return false;
            }
            if (this._protocol == null ? other.getProtocol() != null : !this._protocol.equals(other.getProtocol())) {
                return false;
            }
            if (this._remotePortHigh == null ? other.getRemotePortHigh() != null : !this._remotePortHigh.equals((Object)other.getRemotePortHigh())) {
                return false;
            }
            if (this._remotePortLow == null ? other.getRemotePortLow() != null : !this._remotePortLow.equals((Object)other.getRemotePortLow())) {
                return false;
            }
            if (this.getClass() == obj.getClass()) {
                LcafApplicationDataAddrImpl otherImpl = (LcafApplicationDataAddrImpl)obj;
                if (this.augmentation == null ? otherImpl.augmentation != null : !this.augmentation.equals(otherImpl.augmentation)) {
                    return false;
                }
            } else {
                for (Map.Entry<Class<? extends Augmentation<LcafApplicationDataAddr>>, Augmentation<LcafApplicationDataAddr>> e : this.augmentation.entrySet()) {
                    if (e.getValue().equals((Object)other.getAugmentation(e.getKey()))) continue;
                    return false;
                }
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }

        public String toString() {
            StringBuilder builder = new StringBuilder("LcafApplicationDataAddr [");
            boolean first = true;
            if (this._address != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_address=");
                builder.append(this._address);
            }
            if (this._afi != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_afi=");
                builder.append(this._afi);
            }
            if (this._ipTos != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_ipTos=");
                builder.append(this._ipTos);
            }
            if (this._lcafType != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_lcafType=");
                builder.append(this._lcafType);
            }
            if (this._localPortHigh != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_localPortHigh=");
                builder.append(this._localPortHigh);
            }
            if (this._localPortLow != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_localPortLow=");
                builder.append(this._localPortLow);
            }
            if (this._protocol != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_protocol=");
                builder.append(this._protocol);
            }
            if (this._remotePortHigh != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_remotePortHigh=");
                builder.append(this._remotePortHigh);
            }
            if (this._remotePortLow != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_remotePortLow=");
                builder.append(this._remotePortLow);
            }
            if (first) {
                first = false;
            } else {
                builder.append(", ");
            }
            builder.append("augmentation=");
            builder.append(this.augmentation.values());
            return builder.append(']').toString();
        }
    }
}

