/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.control.plane.rev150314.lispaddress.lispaddresscontainer.address.lcafkeyvalue;

import com.google.common.collect.Range;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.control.plane.rev150314.LcafKeyValueAddress;
import org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.control.plane.rev150314.LispAFIAddress;
import org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.control.plane.rev150314.LispLcafAddress;
import org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.control.plane.rev150314.lcafkeyvalueaddress.Key;
import org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.control.plane.rev150314.lcafkeyvalueaddress.Value;
import org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.control.plane.rev150314.lispaddress.lispaddresscontainer.address.lcafkeyvalue.LcafKeyValueAddressAddr;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class LcafKeyValueAddressAddrBuilder
implements Builder<LcafKeyValueAddressAddr> {
    private Short _afi;
    private Key _key;
    private Short _lcafType;
    private Value _value;
    Map<Class<? extends Augmentation<LcafKeyValueAddressAddr>>, Augmentation<LcafKeyValueAddressAddr>> augmentation = Collections.emptyMap();

    public LcafKeyValueAddressAddrBuilder() {
    }

    public LcafKeyValueAddressAddrBuilder(LcafKeyValueAddress arg) {
        this._key = arg.getKey();
        this._value = arg.getValue();
        this._lcafType = arg.getLcafType();
        this._afi = arg.getAfi();
    }

    public LcafKeyValueAddressAddrBuilder(LispLcafAddress arg) {
        this._lcafType = arg.getLcafType();
        this._afi = arg.getAfi();
    }

    public LcafKeyValueAddressAddrBuilder(LispAFIAddress arg) {
        this._afi = arg.getAfi();
    }

    public LcafKeyValueAddressAddrBuilder(LcafKeyValueAddressAddr base) {
        AugmentationHolder casted;
        this._afi = base.getAfi();
        this._key = base.getKey();
        this._lcafType = base.getLcafType();
        this._value = base.getValue();
        if (base instanceof LcafKeyValueAddressAddrImpl) {
            LcafKeyValueAddressAddrImpl impl = (LcafKeyValueAddressAddrImpl)base;
            if (!impl.augmentation.isEmpty()) {
                this.augmentation = new HashMap<Class<? extends Augmentation<LcafKeyValueAddressAddr>>, Augmentation<LcafKeyValueAddressAddr>>(impl.augmentation);
            }
        } else if (base instanceof AugmentationHolder && !(casted = (AugmentationHolder)base).augmentations().isEmpty()) {
            this.augmentation = new HashMap<Class<? extends Augmentation<LcafKeyValueAddressAddr>>, Augmentation<LcafKeyValueAddressAddr>>(casted.augmentations());
        }
    }

    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof LispAFIAddress) {
            this._afi = ((LispAFIAddress)arg).getAfi();
            isValidArg = true;
        }
        if (arg instanceof LcafKeyValueAddress) {
            this._key = ((LcafKeyValueAddress)arg).getKey();
            this._value = ((LcafKeyValueAddress)arg).getValue();
            isValidArg = true;
        }
        if (arg instanceof LispLcafAddress) {
            this._lcafType = ((LispLcafAddress)arg).getLcafType();
            isValidArg = true;
        }
        if (!isValidArg) {
            throw new IllegalArgumentException("expected one of: [org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.control.plane.rev150314.LispAFIAddress, org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.control.plane.rev150314.LcafKeyValueAddress, org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.control.plane.rev150314.LispLcafAddress] \nbut was: " + arg);
        }
    }

    public Short getAfi() {
        return this._afi;
    }

    public Key getKey() {
        return this._key;
    }

    public Short getLcafType() {
        return this._lcafType;
    }

    public Value getValue() {
        return this._value;
    }

    public <E extends Augmentation<LcafKeyValueAddressAddr>> E getAugmentation(Class<E> augmentationType) {
        if (augmentationType == null) {
            throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
        }
        return (E)this.augmentation.get(augmentationType);
    }

    public LcafKeyValueAddressAddrBuilder setAfi(Short value) {
        this._afi = value;
        return this;
    }

    public LcafKeyValueAddressAddrBuilder setKey(Key value) {
        this._key = value;
        return this;
    }

    private static void checkLcafTypeRange(short value) {
        if (value >= 0 && value <= 255) {
            return;
        }
        throw new IllegalArgumentException(String.format("Invalid range: %s, expected: [[0\u2025255]].", value));
    }

    public LcafKeyValueAddressAddrBuilder setLcafType(Short value) {
        if (value != null) {
            LcafKeyValueAddressAddrBuilder.checkLcafTypeRange(value);
        }
        this._lcafType = value;
        return this;
    }

    @Deprecated
    public static List<Range<BigInteger>> _lcafType_range() {
        ArrayList<Range<BigInteger>> ret = new ArrayList<Range<BigInteger>>(1);
        ret.add(Range.closed((Comparable)BigInteger.ZERO, (Comparable)BigInteger.valueOf(255L)));
        return ret;
    }

    public LcafKeyValueAddressAddrBuilder setValue(Value value) {
        this._value = value;
        return this;
    }

    public LcafKeyValueAddressAddrBuilder addAugmentation(Class<? extends Augmentation<LcafKeyValueAddressAddr>> augmentationType, Augmentation<LcafKeyValueAddressAddr> augmentation) {
        if (augmentation == null) {
            return this.removeAugmentation(augmentationType);
        }
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<LcafKeyValueAddressAddr>>, Augmentation<LcafKeyValueAddressAddr>>();
        }
        this.augmentation.put(augmentationType, augmentation);
        return this;
    }

    public LcafKeyValueAddressAddrBuilder removeAugmentation(Class<? extends Augmentation<LcafKeyValueAddressAddr>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    public LcafKeyValueAddressAddr build() {
        return new LcafKeyValueAddressAddrImpl(this);
    }

    private static final class LcafKeyValueAddressAddrImpl
    implements LcafKeyValueAddressAddr {
        private final Short _afi;
        private final Key _key;
        private final Short _lcafType;
        private final Value _value;
        private Map<Class<? extends Augmentation<LcafKeyValueAddressAddr>>, Augmentation<LcafKeyValueAddressAddr>> augmentation = Collections.emptyMap();
        private int hash = 0;
        private volatile boolean hashValid = false;

        public Class<LcafKeyValueAddressAddr> getImplementedInterface() {
            return LcafKeyValueAddressAddr.class;
        }

        private LcafKeyValueAddressAddrImpl(LcafKeyValueAddressAddrBuilder base) {
            this._afi = base.getAfi();
            this._key = base.getKey();
            this._lcafType = base.getLcafType();
            this._value = base.getValue();
            switch (base.augmentation.size()) {
                case 0: {
                    this.augmentation = Collections.emptyMap();
                    break;
                }
                case 1: {
                    Map.Entry<Class<? extends Augmentation<LcafKeyValueAddressAddr>>, Augmentation<LcafKeyValueAddressAddr>> e = base.augmentation.entrySet().iterator().next();
                    this.augmentation = Collections.singletonMap(e.getKey(), e.getValue());
                    break;
                }
                default: {
                    this.augmentation = new HashMap<Class<? extends Augmentation<LcafKeyValueAddressAddr>>, Augmentation<LcafKeyValueAddressAddr>>(base.augmentation);
                }
            }
        }

        @Override
        public Short getAfi() {
            return this._afi;
        }

        @Override
        public Key getKey() {
            return this._key;
        }

        @Override
        public Short getLcafType() {
            return this._lcafType;
        }

        @Override
        public Value getValue() {
            return this._value;
        }

        public <E extends Augmentation<LcafKeyValueAddressAddr>> E getAugmentation(Class<E> augmentationType) {
            if (augmentationType == null) {
                throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
            }
            return (E)this.augmentation.get(augmentationType);
        }

        public int hashCode() {
            if (this.hashValid) {
                return this.hash;
            }
            int prime = 31;
            int result = 1;
            result = 31 * result + (this._afi == null ? 0 : this._afi.hashCode());
            result = 31 * result + (this._key == null ? 0 : this._key.hashCode());
            result = 31 * result + (this._lcafType == null ? 0 : this._lcafType.hashCode());
            result = 31 * result + (this._value == null ? 0 : this._value.hashCode());
            this.hash = result = 31 * result + (this.augmentation == null ? 0 : this.augmentation.hashCode());
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!LcafKeyValueAddressAddr.class.equals((Object)((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            LcafKeyValueAddressAddr other = (LcafKeyValueAddressAddr)obj;
            if (this._afi == null ? other.getAfi() != null : !this._afi.equals(other.getAfi())) {
                return false;
            }
            if (this._key == null ? other.getKey() != null : !this._key.equals(other.getKey())) {
                return false;
            }
            if (this._lcafType == null ? other.getLcafType() != null : !this._lcafType.equals(other.getLcafType())) {
                return false;
            }
            if (this._value == null ? other.getValue() != null : !this._value.equals(other.getValue())) {
                return false;
            }
            if (this.getClass() == obj.getClass()) {
                LcafKeyValueAddressAddrImpl otherImpl = (LcafKeyValueAddressAddrImpl)obj;
                if (this.augmentation == null ? otherImpl.augmentation != null : !this.augmentation.equals(otherImpl.augmentation)) {
                    return false;
                }
            } else {
                for (Map.Entry<Class<? extends Augmentation<LcafKeyValueAddressAddr>>, Augmentation<LcafKeyValueAddressAddr>> e : this.augmentation.entrySet()) {
                    if (e.getValue().equals((Object)other.getAugmentation(e.getKey()))) continue;
                    return false;
                }
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }

        public String toString() {
            StringBuilder builder = new StringBuilder("LcafKeyValueAddressAddr [");
            boolean first = true;
            if (this._afi != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_afi=");
                builder.append(this._afi);
            }
            if (this._key != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_key=");
                builder.append(this._key);
            }
            if (this._lcafType != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_lcafType=");
                builder.append(this._lcafType);
            }
            if (this._value != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_value=");
                builder.append(this._value);
            }
            if (first) {
                first = false;
            } else {
                builder.append(", ");
            }
            builder.append("augmentation=");
            builder.append(this.augmentation.values());
            return builder.append(']').toString();
        }
    }
}

