/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.control.plane.rev150314.lispaddress.lispaddresscontainer.address.lcaflist;

import com.google.common.collect.Range;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.control.plane.rev150314.LcafListAddress;
import org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.control.plane.rev150314.LispAFIAddress;
import org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.control.plane.rev150314.LispLcafAddress;
import org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.control.plane.rev150314.lcaflistaddress.Addresses;
import org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.control.plane.rev150314.lispaddress.lispaddresscontainer.address.lcaflist.LcafListAddr;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class LcafListAddrBuilder
implements Builder<LcafListAddr> {
    private List<Addresses> _addresses;
    private Short _afi;
    private Short _lcafType;
    Map<Class<? extends Augmentation<LcafListAddr>>, Augmentation<LcafListAddr>> augmentation = Collections.emptyMap();

    public LcafListAddrBuilder() {
    }

    public LcafListAddrBuilder(LcafListAddress arg) {
        this._addresses = arg.getAddresses();
        this._lcafType = arg.getLcafType();
        this._afi = arg.getAfi();
    }

    public LcafListAddrBuilder(LispLcafAddress arg) {
        this._lcafType = arg.getLcafType();
        this._afi = arg.getAfi();
    }

    public LcafListAddrBuilder(LispAFIAddress arg) {
        this._afi = arg.getAfi();
    }

    public LcafListAddrBuilder(LcafListAddr base) {
        AugmentationHolder casted;
        this._addresses = base.getAddresses();
        this._afi = base.getAfi();
        this._lcafType = base.getLcafType();
        if (base instanceof LcafListAddrImpl) {
            LcafListAddrImpl impl = (LcafListAddrImpl)base;
            if (!impl.augmentation.isEmpty()) {
                this.augmentation = new HashMap<Class<? extends Augmentation<LcafListAddr>>, Augmentation<LcafListAddr>>(impl.augmentation);
            }
        } else if (base instanceof AugmentationHolder && !(casted = (AugmentationHolder)base).augmentations().isEmpty()) {
            this.augmentation = new HashMap<Class<? extends Augmentation<LcafListAddr>>, Augmentation<LcafListAddr>>(casted.augmentations());
        }
    }

    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof LispAFIAddress) {
            this._afi = ((LispAFIAddress)arg).getAfi();
            isValidArg = true;
        }
        if (arg instanceof LcafListAddress) {
            this._addresses = ((LcafListAddress)arg).getAddresses();
            isValidArg = true;
        }
        if (arg instanceof LispLcafAddress) {
            this._lcafType = ((LispLcafAddress)arg).getLcafType();
            isValidArg = true;
        }
        if (!isValidArg) {
            throw new IllegalArgumentException("expected one of: [org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.control.plane.rev150314.LispAFIAddress, org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.control.plane.rev150314.LcafListAddress, org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.control.plane.rev150314.LispLcafAddress] \nbut was: " + arg);
        }
    }

    public List<Addresses> getAddresses() {
        return this._addresses;
    }

    public Short getAfi() {
        return this._afi;
    }

    public Short getLcafType() {
        return this._lcafType;
    }

    public <E extends Augmentation<LcafListAddr>> E getAugmentation(Class<E> augmentationType) {
        if (augmentationType == null) {
            throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
        }
        return (E)this.augmentation.get(augmentationType);
    }

    public LcafListAddrBuilder setAddresses(List<Addresses> value) {
        this._addresses = value;
        return this;
    }

    public LcafListAddrBuilder setAfi(Short value) {
        this._afi = value;
        return this;
    }

    private static void checkLcafTypeRange(short value) {
        if (value >= 0 && value <= 255) {
            return;
        }
        throw new IllegalArgumentException(String.format("Invalid range: %s, expected: [[0\u2025255]].", value));
    }

    public LcafListAddrBuilder setLcafType(Short value) {
        if (value != null) {
            LcafListAddrBuilder.checkLcafTypeRange(value);
        }
        this._lcafType = value;
        return this;
    }

    @Deprecated
    public static List<Range<BigInteger>> _lcafType_range() {
        ArrayList<Range<BigInteger>> ret = new ArrayList<Range<BigInteger>>(1);
        ret.add(Range.closed((Comparable)BigInteger.ZERO, (Comparable)BigInteger.valueOf(255L)));
        return ret;
    }

    public LcafListAddrBuilder addAugmentation(Class<? extends Augmentation<LcafListAddr>> augmentationType, Augmentation<LcafListAddr> augmentation) {
        if (augmentation == null) {
            return this.removeAugmentation(augmentationType);
        }
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<LcafListAddr>>, Augmentation<LcafListAddr>>();
        }
        this.augmentation.put(augmentationType, augmentation);
        return this;
    }

    public LcafListAddrBuilder removeAugmentation(Class<? extends Augmentation<LcafListAddr>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    public LcafListAddr build() {
        return new LcafListAddrImpl(this);
    }

    private static final class LcafListAddrImpl
    implements LcafListAddr {
        private final List<Addresses> _addresses;
        private final Short _afi;
        private final Short _lcafType;
        private Map<Class<? extends Augmentation<LcafListAddr>>, Augmentation<LcafListAddr>> augmentation = Collections.emptyMap();
        private int hash = 0;
        private volatile boolean hashValid = false;

        public Class<LcafListAddr> getImplementedInterface() {
            return LcafListAddr.class;
        }

        private LcafListAddrImpl(LcafListAddrBuilder base) {
            this._addresses = base.getAddresses();
            this._afi = base.getAfi();
            this._lcafType = base.getLcafType();
            switch (base.augmentation.size()) {
                case 0: {
                    this.augmentation = Collections.emptyMap();
                    break;
                }
                case 1: {
                    Map.Entry<Class<? extends Augmentation<LcafListAddr>>, Augmentation<LcafListAddr>> e = base.augmentation.entrySet().iterator().next();
                    this.augmentation = Collections.singletonMap(e.getKey(), e.getValue());
                    break;
                }
                default: {
                    this.augmentation = new HashMap<Class<? extends Augmentation<LcafListAddr>>, Augmentation<LcafListAddr>>(base.augmentation);
                }
            }
        }

        @Override
        public List<Addresses> getAddresses() {
            return this._addresses;
        }

        @Override
        public Short getAfi() {
            return this._afi;
        }

        @Override
        public Short getLcafType() {
            return this._lcafType;
        }

        public <E extends Augmentation<LcafListAddr>> E getAugmentation(Class<E> augmentationType) {
            if (augmentationType == null) {
                throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
            }
            return (E)this.augmentation.get(augmentationType);
        }

        public int hashCode() {
            if (this.hashValid) {
                return this.hash;
            }
            int prime = 31;
            int result = 1;
            result = 31 * result + (this._addresses == null ? 0 : this._addresses.hashCode());
            result = 31 * result + (this._afi == null ? 0 : this._afi.hashCode());
            result = 31 * result + (this._lcafType == null ? 0 : this._lcafType.hashCode());
            this.hash = result = 31 * result + (this.augmentation == null ? 0 : this.augmentation.hashCode());
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!LcafListAddr.class.equals((Object)((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            LcafListAddr other = (LcafListAddr)obj;
            if (this._addresses == null ? other.getAddresses() != null : !this._addresses.equals(other.getAddresses())) {
                return false;
            }
            if (this._afi == null ? other.getAfi() != null : !this._afi.equals(other.getAfi())) {
                return false;
            }
            if (this._lcafType == null ? other.getLcafType() != null : !this._lcafType.equals(other.getLcafType())) {
                return false;
            }
            if (this.getClass() == obj.getClass()) {
                LcafListAddrImpl otherImpl = (LcafListAddrImpl)obj;
                if (this.augmentation == null ? otherImpl.augmentation != null : !this.augmentation.equals(otherImpl.augmentation)) {
                    return false;
                }
            } else {
                for (Map.Entry<Class<? extends Augmentation<LcafListAddr>>, Augmentation<LcafListAddr>> e : this.augmentation.entrySet()) {
                    if (e.getValue().equals((Object)other.getAugmentation(e.getKey()))) continue;
                    return false;
                }
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }

        public String toString() {
            StringBuilder builder = new StringBuilder("LcafListAddr [");
            boolean first = true;
            if (this._addresses != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_addresses=");
                builder.append(this._addresses);
            }
            if (this._afi != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_afi=");
                builder.append(this._afi);
            }
            if (this._lcafType != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_lcafType=");
                builder.append(this._lcafType);
            }
            if (first) {
                first = false;
            } else {
                builder.append(", ");
            }
            builder.append("augmentation=");
            builder.append(this.augmentation.values());
            return builder.append(']').toString();
        }
    }
}

