/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.control.plane.rev150314.lispaddress.lispaddresscontainer.address.lcafsegment;

import com.google.common.collect.Range;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.control.plane.rev150314.LcafSegmentAddress;
import org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.control.plane.rev150314.LispAFIAddress;
import org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.control.plane.rev150314.LispLcafAddress;
import org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.control.plane.rev150314.lcafsegmentaddress.Address;
import org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.control.plane.rev150314.lispaddress.lispaddresscontainer.address.lcafsegment.LcafSegmentAddr;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class LcafSegmentAddrBuilder
implements Builder<LcafSegmentAddr> {
    private Address _address;
    private Short _afi;
    private Short _iidMaskLength;
    private Long _instanceId;
    private Short _lcafType;
    Map<Class<? extends Augmentation<LcafSegmentAddr>>, Augmentation<LcafSegmentAddr>> augmentation = Collections.emptyMap();

    public LcafSegmentAddrBuilder() {
    }

    public LcafSegmentAddrBuilder(LcafSegmentAddress arg) {
        this._instanceId = arg.getInstanceId();
        this._iidMaskLength = arg.getIidMaskLength();
        this._address = arg.getAddress();
        this._lcafType = arg.getLcafType();
        this._afi = arg.getAfi();
    }

    public LcafSegmentAddrBuilder(LispLcafAddress arg) {
        this._lcafType = arg.getLcafType();
        this._afi = arg.getAfi();
    }

    public LcafSegmentAddrBuilder(LispAFIAddress arg) {
        this._afi = arg.getAfi();
    }

    public LcafSegmentAddrBuilder(LcafSegmentAddr base) {
        AugmentationHolder casted;
        this._address = base.getAddress();
        this._afi = base.getAfi();
        this._iidMaskLength = base.getIidMaskLength();
        this._instanceId = base.getInstanceId();
        this._lcafType = base.getLcafType();
        if (base instanceof LcafSegmentAddrImpl) {
            LcafSegmentAddrImpl impl = (LcafSegmentAddrImpl)base;
            if (!impl.augmentation.isEmpty()) {
                this.augmentation = new HashMap<Class<? extends Augmentation<LcafSegmentAddr>>, Augmentation<LcafSegmentAddr>>(impl.augmentation);
            }
        } else if (base instanceof AugmentationHolder && !(casted = (AugmentationHolder)base).augmentations().isEmpty()) {
            this.augmentation = new HashMap<Class<? extends Augmentation<LcafSegmentAddr>>, Augmentation<LcafSegmentAddr>>(casted.augmentations());
        }
    }

    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof LispAFIAddress) {
            this._afi = ((LispAFIAddress)arg).getAfi();
            isValidArg = true;
        }
        if (arg instanceof LispLcafAddress) {
            this._lcafType = ((LispLcafAddress)arg).getLcafType();
            isValidArg = true;
        }
        if (arg instanceof LcafSegmentAddress) {
            this._instanceId = ((LcafSegmentAddress)arg).getInstanceId();
            this._iidMaskLength = ((LcafSegmentAddress)arg).getIidMaskLength();
            this._address = ((LcafSegmentAddress)arg).getAddress();
            isValidArg = true;
        }
        if (!isValidArg) {
            throw new IllegalArgumentException("expected one of: [org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.control.plane.rev150314.LispAFIAddress, org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.control.plane.rev150314.LispLcafAddress, org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.control.plane.rev150314.LcafSegmentAddress] \nbut was: " + arg);
        }
    }

    public Address getAddress() {
        return this._address;
    }

    public Short getAfi() {
        return this._afi;
    }

    public Short getIidMaskLength() {
        return this._iidMaskLength;
    }

    public Long getInstanceId() {
        return this._instanceId;
    }

    public Short getLcafType() {
        return this._lcafType;
    }

    public <E extends Augmentation<LcafSegmentAddr>> E getAugmentation(Class<E> augmentationType) {
        if (augmentationType == null) {
            throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
        }
        return (E)this.augmentation.get(augmentationType);
    }

    public LcafSegmentAddrBuilder setAddress(Address value) {
        this._address = value;
        return this;
    }

    public LcafSegmentAddrBuilder setAfi(Short value) {
        this._afi = value;
        return this;
    }

    private static void checkIidMaskLengthRange(short value) {
        if (value >= 0 && value <= 255) {
            return;
        }
        throw new IllegalArgumentException(String.format("Invalid range: %s, expected: [[0\u2025255]].", value));
    }

    public LcafSegmentAddrBuilder setIidMaskLength(Short value) {
        if (value != null) {
            LcafSegmentAddrBuilder.checkIidMaskLengthRange(value);
        }
        this._iidMaskLength = value;
        return this;
    }

    @Deprecated
    public static List<Range<BigInteger>> _iidMaskLength_range() {
        ArrayList<Range<BigInteger>> ret = new ArrayList<Range<BigInteger>>(1);
        ret.add(Range.closed((Comparable)BigInteger.ZERO, (Comparable)BigInteger.valueOf(255L)));
        return ret;
    }

    private static void checkInstanceIdRange(long value) {
        if (value >= 0L && value <= 0xFFFFFFL) {
            return;
        }
        throw new IllegalArgumentException(String.format("Invalid range: %s, expected: [[0\u202516777215]].", value));
    }

    public LcafSegmentAddrBuilder setInstanceId(Long value) {
        if (value != null) {
            LcafSegmentAddrBuilder.checkInstanceIdRange(value);
        }
        this._instanceId = value;
        return this;
    }

    @Deprecated
    public static List<Range<BigInteger>> _instanceId_range() {
        ArrayList<Range<BigInteger>> ret = new ArrayList<Range<BigInteger>>(1);
        ret.add(Range.closed((Comparable)BigInteger.ZERO, (Comparable)BigInteger.valueOf(0xFFFFFFL)));
        return ret;
    }

    private static void checkLcafTypeRange(short value) {
        if (value >= 0 && value <= 255) {
            return;
        }
        throw new IllegalArgumentException(String.format("Invalid range: %s, expected: [[0\u2025255]].", value));
    }

    public LcafSegmentAddrBuilder setLcafType(Short value) {
        if (value != null) {
            LcafSegmentAddrBuilder.checkLcafTypeRange(value);
        }
        this._lcafType = value;
        return this;
    }

    @Deprecated
    public static List<Range<BigInteger>> _lcafType_range() {
        ArrayList<Range<BigInteger>> ret = new ArrayList<Range<BigInteger>>(1);
        ret.add(Range.closed((Comparable)BigInteger.ZERO, (Comparable)BigInteger.valueOf(255L)));
        return ret;
    }

    public LcafSegmentAddrBuilder addAugmentation(Class<? extends Augmentation<LcafSegmentAddr>> augmentationType, Augmentation<LcafSegmentAddr> augmentation) {
        if (augmentation == null) {
            return this.removeAugmentation(augmentationType);
        }
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<LcafSegmentAddr>>, Augmentation<LcafSegmentAddr>>();
        }
        this.augmentation.put(augmentationType, augmentation);
        return this;
    }

    public LcafSegmentAddrBuilder removeAugmentation(Class<? extends Augmentation<LcafSegmentAddr>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    public LcafSegmentAddr build() {
        return new LcafSegmentAddrImpl(this);
    }

    private static final class LcafSegmentAddrImpl
    implements LcafSegmentAddr {
        private final Address _address;
        private final Short _afi;
        private final Short _iidMaskLength;
        private final Long _instanceId;
        private final Short _lcafType;
        private Map<Class<? extends Augmentation<LcafSegmentAddr>>, Augmentation<LcafSegmentAddr>> augmentation = Collections.emptyMap();
        private int hash = 0;
        private volatile boolean hashValid = false;

        public Class<LcafSegmentAddr> getImplementedInterface() {
            return LcafSegmentAddr.class;
        }

        private LcafSegmentAddrImpl(LcafSegmentAddrBuilder base) {
            this._address = base.getAddress();
            this._afi = base.getAfi();
            this._iidMaskLength = base.getIidMaskLength();
            this._instanceId = base.getInstanceId();
            this._lcafType = base.getLcafType();
            switch (base.augmentation.size()) {
                case 0: {
                    this.augmentation = Collections.emptyMap();
                    break;
                }
                case 1: {
                    Map.Entry<Class<? extends Augmentation<LcafSegmentAddr>>, Augmentation<LcafSegmentAddr>> e = base.augmentation.entrySet().iterator().next();
                    this.augmentation = Collections.singletonMap(e.getKey(), e.getValue());
                    break;
                }
                default: {
                    this.augmentation = new HashMap<Class<? extends Augmentation<LcafSegmentAddr>>, Augmentation<LcafSegmentAddr>>(base.augmentation);
                }
            }
        }

        @Override
        public Address getAddress() {
            return this._address;
        }

        @Override
        public Short getAfi() {
            return this._afi;
        }

        @Override
        public Short getIidMaskLength() {
            return this._iidMaskLength;
        }

        @Override
        public Long getInstanceId() {
            return this._instanceId;
        }

        @Override
        public Short getLcafType() {
            return this._lcafType;
        }

        public <E extends Augmentation<LcafSegmentAddr>> E getAugmentation(Class<E> augmentationType) {
            if (augmentationType == null) {
                throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
            }
            return (E)this.augmentation.get(augmentationType);
        }

        public int hashCode() {
            if (this.hashValid) {
                return this.hash;
            }
            int prime = 31;
            int result = 1;
            result = 31 * result + (this._address == null ? 0 : this._address.hashCode());
            result = 31 * result + (this._afi == null ? 0 : this._afi.hashCode());
            result = 31 * result + (this._iidMaskLength == null ? 0 : this._iidMaskLength.hashCode());
            result = 31 * result + (this._instanceId == null ? 0 : this._instanceId.hashCode());
            result = 31 * result + (this._lcafType == null ? 0 : this._lcafType.hashCode());
            this.hash = result = 31 * result + (this.augmentation == null ? 0 : this.augmentation.hashCode());
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!LcafSegmentAddr.class.equals((Object)((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            LcafSegmentAddr other = (LcafSegmentAddr)obj;
            if (this._address == null ? other.getAddress() != null : !this._address.equals(other.getAddress())) {
                return false;
            }
            if (this._afi == null ? other.getAfi() != null : !this._afi.equals(other.getAfi())) {
                return false;
            }
            if (this._iidMaskLength == null ? other.getIidMaskLength() != null : !this._iidMaskLength.equals(other.getIidMaskLength())) {
                return false;
            }
            if (this._instanceId == null ? other.getInstanceId() != null : !this._instanceId.equals(other.getInstanceId())) {
                return false;
            }
            if (this._lcafType == null ? other.getLcafType() != null : !this._lcafType.equals(other.getLcafType())) {
                return false;
            }
            if (this.getClass() == obj.getClass()) {
                LcafSegmentAddrImpl otherImpl = (LcafSegmentAddrImpl)obj;
                if (this.augmentation == null ? otherImpl.augmentation != null : !this.augmentation.equals(otherImpl.augmentation)) {
                    return false;
                }
            } else {
                for (Map.Entry<Class<? extends Augmentation<LcafSegmentAddr>>, Augmentation<LcafSegmentAddr>> e : this.augmentation.entrySet()) {
                    if (e.getValue().equals((Object)other.getAugmentation(e.getKey()))) continue;
                    return false;
                }
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }

        public String toString() {
            StringBuilder builder = new StringBuilder("LcafSegmentAddr [");
            boolean first = true;
            if (this._address != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_address=");
                builder.append(this._address);
            }
            if (this._afi != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_afi=");
                builder.append(this._afi);
            }
            if (this._iidMaskLength != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_iidMaskLength=");
                builder.append(this._iidMaskLength);
            }
            if (this._instanceId != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_instanceId=");
                builder.append(this._instanceId);
            }
            if (this._lcafType != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_lcafType=");
                builder.append(this._lcafType);
            }
            if (first) {
                first = false;
            } else {
                builder.append(", ");
            }
            builder.append("augmentation=");
            builder.append(this.augmentation.values());
            return builder.append(']').toString();
        }
    }
}

