/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.control.plane.rev150314.lispaddress.lispaddresscontainer.address.lcafsourcedest;

import com.google.common.collect.Range;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.control.plane.rev150314.LcafSourceDestAddress;
import org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.control.plane.rev150314.LispAFIAddress;
import org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.control.plane.rev150314.LispLcafAddress;
import org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.control.plane.rev150314.lcafsourcedestaddress.DstAddress;
import org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.control.plane.rev150314.lcafsourcedestaddress.SrcAddress;
import org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.control.plane.rev150314.lispaddress.lispaddresscontainer.address.lcafsourcedest.LcafSourceDestAddr;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class LcafSourceDestAddrBuilder
implements Builder<LcafSourceDestAddr> {
    private Short _afi;
    private DstAddress _dstAddress;
    private Short _dstMaskLength;
    private Short _lcafType;
    private SrcAddress _srcAddress;
    private Short _srcMaskLength;
    Map<Class<? extends Augmentation<LcafSourceDestAddr>>, Augmentation<LcafSourceDestAddr>> augmentation = Collections.emptyMap();

    public LcafSourceDestAddrBuilder() {
    }

    public LcafSourceDestAddrBuilder(LcafSourceDestAddress arg) {
        this._srcAddress = arg.getSrcAddress();
        this._dstAddress = arg.getDstAddress();
        this._srcMaskLength = arg.getSrcMaskLength();
        this._dstMaskLength = arg.getDstMaskLength();
        this._lcafType = arg.getLcafType();
        this._afi = arg.getAfi();
    }

    public LcafSourceDestAddrBuilder(LispLcafAddress arg) {
        this._lcafType = arg.getLcafType();
        this._afi = arg.getAfi();
    }

    public LcafSourceDestAddrBuilder(LispAFIAddress arg) {
        this._afi = arg.getAfi();
    }

    public LcafSourceDestAddrBuilder(LcafSourceDestAddr base) {
        AugmentationHolder casted;
        this._afi = base.getAfi();
        this._dstAddress = base.getDstAddress();
        this._dstMaskLength = base.getDstMaskLength();
        this._lcafType = base.getLcafType();
        this._srcAddress = base.getSrcAddress();
        this._srcMaskLength = base.getSrcMaskLength();
        if (base instanceof LcafSourceDestAddrImpl) {
            LcafSourceDestAddrImpl impl = (LcafSourceDestAddrImpl)base;
            if (!impl.augmentation.isEmpty()) {
                this.augmentation = new HashMap<Class<? extends Augmentation<LcafSourceDestAddr>>, Augmentation<LcafSourceDestAddr>>(impl.augmentation);
            }
        } else if (base instanceof AugmentationHolder && !(casted = (AugmentationHolder)base).augmentations().isEmpty()) {
            this.augmentation = new HashMap<Class<? extends Augmentation<LcafSourceDestAddr>>, Augmentation<LcafSourceDestAddr>>(casted.augmentations());
        }
    }

    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof LispAFIAddress) {
            this._afi = ((LispAFIAddress)arg).getAfi();
            isValidArg = true;
        }
        if (arg instanceof LcafSourceDestAddress) {
            this._srcAddress = ((LcafSourceDestAddress)arg).getSrcAddress();
            this._dstAddress = ((LcafSourceDestAddress)arg).getDstAddress();
            this._srcMaskLength = ((LcafSourceDestAddress)arg).getSrcMaskLength();
            this._dstMaskLength = ((LcafSourceDestAddress)arg).getDstMaskLength();
            isValidArg = true;
        }
        if (arg instanceof LispLcafAddress) {
            this._lcafType = ((LispLcafAddress)arg).getLcafType();
            isValidArg = true;
        }
        if (!isValidArg) {
            throw new IllegalArgumentException("expected one of: [org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.control.plane.rev150314.LispAFIAddress, org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.control.plane.rev150314.LcafSourceDestAddress, org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.control.plane.rev150314.LispLcafAddress] \nbut was: " + arg);
        }
    }

    public Short getAfi() {
        return this._afi;
    }

    public DstAddress getDstAddress() {
        return this._dstAddress;
    }

    public Short getDstMaskLength() {
        return this._dstMaskLength;
    }

    public Short getLcafType() {
        return this._lcafType;
    }

    public SrcAddress getSrcAddress() {
        return this._srcAddress;
    }

    public Short getSrcMaskLength() {
        return this._srcMaskLength;
    }

    public <E extends Augmentation<LcafSourceDestAddr>> E getAugmentation(Class<E> augmentationType) {
        if (augmentationType == null) {
            throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
        }
        return (E)this.augmentation.get(augmentationType);
    }

    public LcafSourceDestAddrBuilder setAfi(Short value) {
        this._afi = value;
        return this;
    }

    public LcafSourceDestAddrBuilder setDstAddress(DstAddress value) {
        this._dstAddress = value;
        return this;
    }

    private static void checkDstMaskLengthRange(short value) {
        if (value >= 0 && value <= 255) {
            return;
        }
        throw new IllegalArgumentException(String.format("Invalid range: %s, expected: [[0\u2025255]].", value));
    }

    public LcafSourceDestAddrBuilder setDstMaskLength(Short value) {
        if (value != null) {
            LcafSourceDestAddrBuilder.checkDstMaskLengthRange(value);
        }
        this._dstMaskLength = value;
        return this;
    }

    @Deprecated
    public static List<Range<BigInteger>> _dstMaskLength_range() {
        ArrayList<Range<BigInteger>> ret = new ArrayList<Range<BigInteger>>(1);
        ret.add(Range.closed((Comparable)BigInteger.ZERO, (Comparable)BigInteger.valueOf(255L)));
        return ret;
    }

    private static void checkLcafTypeRange(short value) {
        if (value >= 0 && value <= 255) {
            return;
        }
        throw new IllegalArgumentException(String.format("Invalid range: %s, expected: [[0\u2025255]].", value));
    }

    public LcafSourceDestAddrBuilder setLcafType(Short value) {
        if (value != null) {
            LcafSourceDestAddrBuilder.checkLcafTypeRange(value);
        }
        this._lcafType = value;
        return this;
    }

    @Deprecated
    public static List<Range<BigInteger>> _lcafType_range() {
        ArrayList<Range<BigInteger>> ret = new ArrayList<Range<BigInteger>>(1);
        ret.add(Range.closed((Comparable)BigInteger.ZERO, (Comparable)BigInteger.valueOf(255L)));
        return ret;
    }

    public LcafSourceDestAddrBuilder setSrcAddress(SrcAddress value) {
        this._srcAddress = value;
        return this;
    }

    private static void checkSrcMaskLengthRange(short value) {
        if (value >= 0 && value <= 255) {
            return;
        }
        throw new IllegalArgumentException(String.format("Invalid range: %s, expected: [[0\u2025255]].", value));
    }

    public LcafSourceDestAddrBuilder setSrcMaskLength(Short value) {
        if (value != null) {
            LcafSourceDestAddrBuilder.checkSrcMaskLengthRange(value);
        }
        this._srcMaskLength = value;
        return this;
    }

    @Deprecated
    public static List<Range<BigInteger>> _srcMaskLength_range() {
        ArrayList<Range<BigInteger>> ret = new ArrayList<Range<BigInteger>>(1);
        ret.add(Range.closed((Comparable)BigInteger.ZERO, (Comparable)BigInteger.valueOf(255L)));
        return ret;
    }

    public LcafSourceDestAddrBuilder addAugmentation(Class<? extends Augmentation<LcafSourceDestAddr>> augmentationType, Augmentation<LcafSourceDestAddr> augmentation) {
        if (augmentation == null) {
            return this.removeAugmentation(augmentationType);
        }
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<LcafSourceDestAddr>>, Augmentation<LcafSourceDestAddr>>();
        }
        this.augmentation.put(augmentationType, augmentation);
        return this;
    }

    public LcafSourceDestAddrBuilder removeAugmentation(Class<? extends Augmentation<LcafSourceDestAddr>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    public LcafSourceDestAddr build() {
        return new LcafSourceDestAddrImpl(this);
    }

    private static final class LcafSourceDestAddrImpl
    implements LcafSourceDestAddr {
        private final Short _afi;
        private final DstAddress _dstAddress;
        private final Short _dstMaskLength;
        private final Short _lcafType;
        private final SrcAddress _srcAddress;
        private final Short _srcMaskLength;
        private Map<Class<? extends Augmentation<LcafSourceDestAddr>>, Augmentation<LcafSourceDestAddr>> augmentation = Collections.emptyMap();
        private int hash = 0;
        private volatile boolean hashValid = false;

        public Class<LcafSourceDestAddr> getImplementedInterface() {
            return LcafSourceDestAddr.class;
        }

        private LcafSourceDestAddrImpl(LcafSourceDestAddrBuilder base) {
            this._afi = base.getAfi();
            this._dstAddress = base.getDstAddress();
            this._dstMaskLength = base.getDstMaskLength();
            this._lcafType = base.getLcafType();
            this._srcAddress = base.getSrcAddress();
            this._srcMaskLength = base.getSrcMaskLength();
            switch (base.augmentation.size()) {
                case 0: {
                    this.augmentation = Collections.emptyMap();
                    break;
                }
                case 1: {
                    Map.Entry<Class<? extends Augmentation<LcafSourceDestAddr>>, Augmentation<LcafSourceDestAddr>> e = base.augmentation.entrySet().iterator().next();
                    this.augmentation = Collections.singletonMap(e.getKey(), e.getValue());
                    break;
                }
                default: {
                    this.augmentation = new HashMap<Class<? extends Augmentation<LcafSourceDestAddr>>, Augmentation<LcafSourceDestAddr>>(base.augmentation);
                }
            }
        }

        @Override
        public Short getAfi() {
            return this._afi;
        }

        @Override
        public DstAddress getDstAddress() {
            return this._dstAddress;
        }

        @Override
        public Short getDstMaskLength() {
            return this._dstMaskLength;
        }

        @Override
        public Short getLcafType() {
            return this._lcafType;
        }

        @Override
        public SrcAddress getSrcAddress() {
            return this._srcAddress;
        }

        @Override
        public Short getSrcMaskLength() {
            return this._srcMaskLength;
        }

        public <E extends Augmentation<LcafSourceDestAddr>> E getAugmentation(Class<E> augmentationType) {
            if (augmentationType == null) {
                throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
            }
            return (E)this.augmentation.get(augmentationType);
        }

        public int hashCode() {
            if (this.hashValid) {
                return this.hash;
            }
            int prime = 31;
            int result = 1;
            result = 31 * result + (this._afi == null ? 0 : this._afi.hashCode());
            result = 31 * result + (this._dstAddress == null ? 0 : this._dstAddress.hashCode());
            result = 31 * result + (this._dstMaskLength == null ? 0 : this._dstMaskLength.hashCode());
            result = 31 * result + (this._lcafType == null ? 0 : this._lcafType.hashCode());
            result = 31 * result + (this._srcAddress == null ? 0 : this._srcAddress.hashCode());
            result = 31 * result + (this._srcMaskLength == null ? 0 : this._srcMaskLength.hashCode());
            this.hash = result = 31 * result + (this.augmentation == null ? 0 : this.augmentation.hashCode());
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!LcafSourceDestAddr.class.equals((Object)((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            LcafSourceDestAddr other = (LcafSourceDestAddr)obj;
            if (this._afi == null ? other.getAfi() != null : !this._afi.equals(other.getAfi())) {
                return false;
            }
            if (this._dstAddress == null ? other.getDstAddress() != null : !this._dstAddress.equals(other.getDstAddress())) {
                return false;
            }
            if (this._dstMaskLength == null ? other.getDstMaskLength() != null : !this._dstMaskLength.equals(other.getDstMaskLength())) {
                return false;
            }
            if (this._lcafType == null ? other.getLcafType() != null : !this._lcafType.equals(other.getLcafType())) {
                return false;
            }
            if (this._srcAddress == null ? other.getSrcAddress() != null : !this._srcAddress.equals(other.getSrcAddress())) {
                return false;
            }
            if (this._srcMaskLength == null ? other.getSrcMaskLength() != null : !this._srcMaskLength.equals(other.getSrcMaskLength())) {
                return false;
            }
            if (this.getClass() == obj.getClass()) {
                LcafSourceDestAddrImpl otherImpl = (LcafSourceDestAddrImpl)obj;
                if (this.augmentation == null ? otherImpl.augmentation != null : !this.augmentation.equals(otherImpl.augmentation)) {
                    return false;
                }
            } else {
                for (Map.Entry<Class<? extends Augmentation<LcafSourceDestAddr>>, Augmentation<LcafSourceDestAddr>> e : this.augmentation.entrySet()) {
                    if (e.getValue().equals((Object)other.getAugmentation(e.getKey()))) continue;
                    return false;
                }
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }

        public String toString() {
            StringBuilder builder = new StringBuilder("LcafSourceDestAddr [");
            boolean first = true;
            if (this._afi != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_afi=");
                builder.append(this._afi);
            }
            if (this._dstAddress != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_dstAddress=");
                builder.append(this._dstAddress);
            }
            if (this._dstMaskLength != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_dstMaskLength=");
                builder.append(this._dstMaskLength);
            }
            if (this._lcafType != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_lcafType=");
                builder.append(this._lcafType);
            }
            if (this._srcAddress != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_srcAddress=");
                builder.append(this._srcAddress);
            }
            if (this._srcMaskLength != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_srcMaskLength=");
                builder.append(this._srcMaskLength);
            }
            if (first) {
                first = false;
            } else {
                builder.append(", ");
            }
            builder.append("augmentation=");
            builder.append(this.augmentation.values());
            return builder.append(']').toString();
        }
    }
}

