/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.control.plane.rev150314.lispaddress.lispaddresscontainer.address.lcaftrafficengineering;

import com.google.common.collect.Range;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.control.plane.rev150314.LcafTrafficEngineeringAddress;
import org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.control.plane.rev150314.LispAFIAddress;
import org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.control.plane.rev150314.LispLcafAddress;
import org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.control.plane.rev150314.lcaftrafficengineeringaddress.Hops;
import org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.control.plane.rev150314.lispaddress.lispaddresscontainer.address.lcaftrafficengineering.LcafTrafficEngineeringAddr;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class LcafTrafficEngineeringAddrBuilder
implements Builder<LcafTrafficEngineeringAddr> {
    private Short _afi;
    private List<Hops> _hops;
    private Short _lcafType;
    Map<Class<? extends Augmentation<LcafTrafficEngineeringAddr>>, Augmentation<LcafTrafficEngineeringAddr>> augmentation = Collections.emptyMap();

    public LcafTrafficEngineeringAddrBuilder() {
    }

    public LcafTrafficEngineeringAddrBuilder(LcafTrafficEngineeringAddress arg) {
        this._hops = arg.getHops();
        this._lcafType = arg.getLcafType();
        this._afi = arg.getAfi();
    }

    public LcafTrafficEngineeringAddrBuilder(LispLcafAddress arg) {
        this._lcafType = arg.getLcafType();
        this._afi = arg.getAfi();
    }

    public LcafTrafficEngineeringAddrBuilder(LispAFIAddress arg) {
        this._afi = arg.getAfi();
    }

    public LcafTrafficEngineeringAddrBuilder(LcafTrafficEngineeringAddr base) {
        AugmentationHolder casted;
        this._afi = base.getAfi();
        this._hops = base.getHops();
        this._lcafType = base.getLcafType();
        if (base instanceof LcafTrafficEngineeringAddrImpl) {
            LcafTrafficEngineeringAddrImpl impl = (LcafTrafficEngineeringAddrImpl)base;
            if (!impl.augmentation.isEmpty()) {
                this.augmentation = new HashMap<Class<? extends Augmentation<LcafTrafficEngineeringAddr>>, Augmentation<LcafTrafficEngineeringAddr>>(impl.augmentation);
            }
        } else if (base instanceof AugmentationHolder && !(casted = (AugmentationHolder)base).augmentations().isEmpty()) {
            this.augmentation = new HashMap<Class<? extends Augmentation<LcafTrafficEngineeringAddr>>, Augmentation<LcafTrafficEngineeringAddr>>(casted.augmentations());
        }
    }

    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof LcafTrafficEngineeringAddress) {
            this._hops = ((LcafTrafficEngineeringAddress)arg).getHops();
            isValidArg = true;
        }
        if (arg instanceof LispAFIAddress) {
            this._afi = ((LispAFIAddress)arg).getAfi();
            isValidArg = true;
        }
        if (arg instanceof LispLcafAddress) {
            this._lcafType = ((LispLcafAddress)arg).getLcafType();
            isValidArg = true;
        }
        if (!isValidArg) {
            throw new IllegalArgumentException("expected one of: [org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.control.plane.rev150314.LcafTrafficEngineeringAddress, org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.control.plane.rev150314.LispAFIAddress, org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.control.plane.rev150314.LispLcafAddress] \nbut was: " + arg);
        }
    }

    public Short getAfi() {
        return this._afi;
    }

    public List<Hops> getHops() {
        return this._hops;
    }

    public Short getLcafType() {
        return this._lcafType;
    }

    public <E extends Augmentation<LcafTrafficEngineeringAddr>> E getAugmentation(Class<E> augmentationType) {
        if (augmentationType == null) {
            throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
        }
        return (E)this.augmentation.get(augmentationType);
    }

    public LcafTrafficEngineeringAddrBuilder setAfi(Short value) {
        this._afi = value;
        return this;
    }

    public LcafTrafficEngineeringAddrBuilder setHops(List<Hops> value) {
        this._hops = value;
        return this;
    }

    private static void checkLcafTypeRange(short value) {
        if (value >= 0 && value <= 255) {
            return;
        }
        throw new IllegalArgumentException(String.format("Invalid range: %s, expected: [[0\u2025255]].", value));
    }

    public LcafTrafficEngineeringAddrBuilder setLcafType(Short value) {
        if (value != null) {
            LcafTrafficEngineeringAddrBuilder.checkLcafTypeRange(value);
        }
        this._lcafType = value;
        return this;
    }

    @Deprecated
    public static List<Range<BigInteger>> _lcafType_range() {
        ArrayList<Range<BigInteger>> ret = new ArrayList<Range<BigInteger>>(1);
        ret.add(Range.closed((Comparable)BigInteger.ZERO, (Comparable)BigInteger.valueOf(255L)));
        return ret;
    }

    public LcafTrafficEngineeringAddrBuilder addAugmentation(Class<? extends Augmentation<LcafTrafficEngineeringAddr>> augmentationType, Augmentation<LcafTrafficEngineeringAddr> augmentation) {
        if (augmentation == null) {
            return this.removeAugmentation(augmentationType);
        }
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<LcafTrafficEngineeringAddr>>, Augmentation<LcafTrafficEngineeringAddr>>();
        }
        this.augmentation.put(augmentationType, augmentation);
        return this;
    }

    public LcafTrafficEngineeringAddrBuilder removeAugmentation(Class<? extends Augmentation<LcafTrafficEngineeringAddr>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    public LcafTrafficEngineeringAddr build() {
        return new LcafTrafficEngineeringAddrImpl(this);
    }

    private static final class LcafTrafficEngineeringAddrImpl
    implements LcafTrafficEngineeringAddr {
        private final Short _afi;
        private final List<Hops> _hops;
        private final Short _lcafType;
        private Map<Class<? extends Augmentation<LcafTrafficEngineeringAddr>>, Augmentation<LcafTrafficEngineeringAddr>> augmentation = Collections.emptyMap();
        private int hash = 0;
        private volatile boolean hashValid = false;

        public Class<LcafTrafficEngineeringAddr> getImplementedInterface() {
            return LcafTrafficEngineeringAddr.class;
        }

        private LcafTrafficEngineeringAddrImpl(LcafTrafficEngineeringAddrBuilder base) {
            this._afi = base.getAfi();
            this._hops = base.getHops();
            this._lcafType = base.getLcafType();
            switch (base.augmentation.size()) {
                case 0: {
                    this.augmentation = Collections.emptyMap();
                    break;
                }
                case 1: {
                    Map.Entry<Class<? extends Augmentation<LcafTrafficEngineeringAddr>>, Augmentation<LcafTrafficEngineeringAddr>> e = base.augmentation.entrySet().iterator().next();
                    this.augmentation = Collections.singletonMap(e.getKey(), e.getValue());
                    break;
                }
                default: {
                    this.augmentation = new HashMap<Class<? extends Augmentation<LcafTrafficEngineeringAddr>>, Augmentation<LcafTrafficEngineeringAddr>>(base.augmentation);
                }
            }
        }

        @Override
        public Short getAfi() {
            return this._afi;
        }

        @Override
        public List<Hops> getHops() {
            return this._hops;
        }

        @Override
        public Short getLcafType() {
            return this._lcafType;
        }

        public <E extends Augmentation<LcafTrafficEngineeringAddr>> E getAugmentation(Class<E> augmentationType) {
            if (augmentationType == null) {
                throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
            }
            return (E)this.augmentation.get(augmentationType);
        }

        public int hashCode() {
            if (this.hashValid) {
                return this.hash;
            }
            int prime = 31;
            int result = 1;
            result = 31 * result + (this._afi == null ? 0 : this._afi.hashCode());
            result = 31 * result + (this._hops == null ? 0 : this._hops.hashCode());
            result = 31 * result + (this._lcafType == null ? 0 : this._lcafType.hashCode());
            this.hash = result = 31 * result + (this.augmentation == null ? 0 : this.augmentation.hashCode());
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!LcafTrafficEngineeringAddr.class.equals((Object)((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            LcafTrafficEngineeringAddr other = (LcafTrafficEngineeringAddr)obj;
            if (this._afi == null ? other.getAfi() != null : !this._afi.equals(other.getAfi())) {
                return false;
            }
            if (this._hops == null ? other.getHops() != null : !this._hops.equals(other.getHops())) {
                return false;
            }
            if (this._lcafType == null ? other.getLcafType() != null : !this._lcafType.equals(other.getLcafType())) {
                return false;
            }
            if (this.getClass() == obj.getClass()) {
                LcafTrafficEngineeringAddrImpl otherImpl = (LcafTrafficEngineeringAddrImpl)obj;
                if (this.augmentation == null ? otherImpl.augmentation != null : !this.augmentation.equals(otherImpl.augmentation)) {
                    return false;
                }
            } else {
                for (Map.Entry<Class<? extends Augmentation<LcafTrafficEngineeringAddr>>, Augmentation<LcafTrafficEngineeringAddr>> e : this.augmentation.entrySet()) {
                    if (e.getValue().equals((Object)other.getAugmentation(e.getKey()))) continue;
                    return false;
                }
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }

        public String toString() {
            StringBuilder builder = new StringBuilder("LcafTrafficEngineeringAddr [");
            boolean first = true;
            if (this._afi != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_afi=");
                builder.append(this._afi);
            }
            if (this._hops != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_hops=");
                builder.append(this._hops);
            }
            if (this._lcafType != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_lcafType=");
                builder.append(this._lcafType);
            }
            if (first) {
                first = false;
            } else {
                builder.append(", ");
            }
            builder.append("augmentation=");
            builder.append(this.augmentation.values());
            return builder.append(']').toString();
        }
    }
}

