/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.control.plane.rev150314.lispaddress.lispaddresscontainer.address.mac;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.control.plane.rev150314.LispAFIAddress;
import org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.control.plane.rev150314.LispMacAddress;
import org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.control.plane.rev150314.lispaddress.lispaddresscontainer.address.mac.MacAddress;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class MacAddressBuilder
implements Builder<MacAddress> {
    private Short _afi;
    private org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.yang.types.rev100924.MacAddress _macAddress;
    Map<Class<? extends Augmentation<MacAddress>>, Augmentation<MacAddress>> augmentation = Collections.emptyMap();

    public MacAddressBuilder() {
    }

    public MacAddressBuilder(LispMacAddress arg) {
        this._macAddress = arg.getMacAddress();
        this._afi = arg.getAfi();
    }

    public MacAddressBuilder(LispAFIAddress arg) {
        this._afi = arg.getAfi();
    }

    public MacAddressBuilder(MacAddress base) {
        AugmentationHolder casted;
        this._afi = base.getAfi();
        this._macAddress = base.getMacAddress();
        if (base instanceof MacAddressImpl) {
            MacAddressImpl impl = (MacAddressImpl)base;
            if (!impl.augmentation.isEmpty()) {
                this.augmentation = new HashMap<Class<? extends Augmentation<MacAddress>>, Augmentation<MacAddress>>(impl.augmentation);
            }
        } else if (base instanceof AugmentationHolder && !(casted = (AugmentationHolder)base).augmentations().isEmpty()) {
            this.augmentation = new HashMap<Class<? extends Augmentation<MacAddress>>, Augmentation<MacAddress>>(casted.augmentations());
        }
    }

    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof LispAFIAddress) {
            this._afi = ((LispAFIAddress)arg).getAfi();
            isValidArg = true;
        }
        if (arg instanceof LispMacAddress) {
            this._macAddress = ((LispMacAddress)arg).getMacAddress();
            isValidArg = true;
        }
        if (!isValidArg) {
            throw new IllegalArgumentException("expected one of: [org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.control.plane.rev150314.LispAFIAddress, org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.control.plane.rev150314.LispMacAddress] \nbut was: " + arg);
        }
    }

    public Short getAfi() {
        return this._afi;
    }

    public org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.yang.types.rev100924.MacAddress getMacAddress() {
        return this._macAddress;
    }

    public <E extends Augmentation<MacAddress>> E getAugmentation(Class<E> augmentationType) {
        if (augmentationType == null) {
            throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
        }
        return (E)this.augmentation.get(augmentationType);
    }

    public MacAddressBuilder setAfi(Short value) {
        this._afi = value;
        return this;
    }

    public MacAddressBuilder setMacAddress(org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.yang.types.rev100924.MacAddress value) {
        if (value != null) {
            // empty if block
        }
        this._macAddress = value;
        return this;
    }

    public MacAddressBuilder addAugmentation(Class<? extends Augmentation<MacAddress>> augmentationType, Augmentation<MacAddress> augmentation) {
        if (augmentation == null) {
            return this.removeAugmentation(augmentationType);
        }
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<MacAddress>>, Augmentation<MacAddress>>();
        }
        this.augmentation.put(augmentationType, augmentation);
        return this;
    }

    public MacAddressBuilder removeAugmentation(Class<? extends Augmentation<MacAddress>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    public MacAddress build() {
        return new MacAddressImpl(this);
    }

    private static final class MacAddressImpl
    implements MacAddress {
        private final Short _afi;
        private final org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.yang.types.rev100924.MacAddress _macAddress;
        private Map<Class<? extends Augmentation<MacAddress>>, Augmentation<MacAddress>> augmentation = Collections.emptyMap();
        private int hash = 0;
        private volatile boolean hashValid = false;

        public Class<MacAddress> getImplementedInterface() {
            return MacAddress.class;
        }

        private MacAddressImpl(MacAddressBuilder base) {
            this._afi = base.getAfi();
            this._macAddress = base.getMacAddress();
            switch (base.augmentation.size()) {
                case 0: {
                    this.augmentation = Collections.emptyMap();
                    break;
                }
                case 1: {
                    Map.Entry<Class<? extends Augmentation<MacAddress>>, Augmentation<MacAddress>> e = base.augmentation.entrySet().iterator().next();
                    this.augmentation = Collections.singletonMap(e.getKey(), e.getValue());
                    break;
                }
                default: {
                    this.augmentation = new HashMap<Class<? extends Augmentation<MacAddress>>, Augmentation<MacAddress>>(base.augmentation);
                }
            }
        }

        @Override
        public Short getAfi() {
            return this._afi;
        }

        @Override
        public org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.yang.types.rev100924.MacAddress getMacAddress() {
            return this._macAddress;
        }

        public <E extends Augmentation<MacAddress>> E getAugmentation(Class<E> augmentationType) {
            if (augmentationType == null) {
                throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
            }
            return (E)this.augmentation.get(augmentationType);
        }

        public int hashCode() {
            if (this.hashValid) {
                return this.hash;
            }
            int prime = 31;
            int result = 1;
            result = 31 * result + (this._afi == null ? 0 : this._afi.hashCode());
            result = 31 * result + (this._macAddress == null ? 0 : this._macAddress.hashCode());
            this.hash = result = 31 * result + (this.augmentation == null ? 0 : this.augmentation.hashCode());
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!MacAddress.class.equals((Object)((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            MacAddress other = (MacAddress)obj;
            if (this._afi == null ? other.getAfi() != null : !this._afi.equals(other.getAfi())) {
                return false;
            }
            if (this._macAddress == null ? other.getMacAddress() != null : !this._macAddress.equals((Object)other.getMacAddress())) {
                return false;
            }
            if (this.getClass() == obj.getClass()) {
                MacAddressImpl otherImpl = (MacAddressImpl)obj;
                if (this.augmentation == null ? otherImpl.augmentation != null : !this.augmentation.equals(otherImpl.augmentation)) {
                    return false;
                }
            } else {
                for (Map.Entry<Class<? extends Augmentation<MacAddress>>, Augmentation<MacAddress>> e : this.augmentation.entrySet()) {
                    if (e.getValue().equals((Object)other.getAugmentation(e.getKey()))) continue;
                    return false;
                }
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }

        public String toString() {
            StringBuilder builder = new StringBuilder("MacAddress [");
            boolean first = true;
            if (this._afi != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_afi=");
                builder.append(this._afi);
            }
            if (this._macAddress != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_macAddress=");
                builder.append(this._macAddress);
            }
            if (first) {
                first = false;
            } else {
                builder.append(", ");
            }
            builder.append("augmentation=");
            builder.append(this.augmentation.values());
            return builder.append(']').toString();
        }
    }
}

