/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.control.plane.rev150314.lispsimpleaddress.primitiveaddress.as;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.control.plane.rev150314.LispAFIAddress;
import org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.control.plane.rev150314.LispASAddress;
import org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.control.plane.rev150314.lispsimpleaddress.primitiveaddress.as.ASAddress;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class ASAddressBuilder
implements Builder<ASAddress> {
    private Integer _aS;
    private Short _afi;
    Map<Class<? extends Augmentation<ASAddress>>, Augmentation<ASAddress>> augmentation = Collections.emptyMap();

    public ASAddressBuilder() {
    }

    public ASAddressBuilder(LispASAddress arg) {
        this._aS = arg.getAS();
        this._afi = arg.getAfi();
    }

    public ASAddressBuilder(LispAFIAddress arg) {
        this._afi = arg.getAfi();
    }

    public ASAddressBuilder(ASAddress base) {
        AugmentationHolder casted;
        this._aS = base.getAS();
        this._afi = base.getAfi();
        if (base instanceof ASAddressImpl) {
            ASAddressImpl impl = (ASAddressImpl)base;
            if (!impl.augmentation.isEmpty()) {
                this.augmentation = new HashMap<Class<? extends Augmentation<ASAddress>>, Augmentation<ASAddress>>(impl.augmentation);
            }
        } else if (base instanceof AugmentationHolder && !(casted = (AugmentationHolder)base).augmentations().isEmpty()) {
            this.augmentation = new HashMap<Class<? extends Augmentation<ASAddress>>, Augmentation<ASAddress>>(casted.augmentations());
        }
    }

    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof LispAFIAddress) {
            this._afi = ((LispAFIAddress)arg).getAfi();
            isValidArg = true;
        }
        if (arg instanceof LispASAddress) {
            this._aS = ((LispASAddress)arg).getAS();
            isValidArg = true;
        }
        if (!isValidArg) {
            throw new IllegalArgumentException("expected one of: [org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.control.plane.rev150314.LispAFIAddress, org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.control.plane.rev150314.LispASAddress] \nbut was: " + arg);
        }
    }

    public Integer getAS() {
        return this._aS;
    }

    public Short getAfi() {
        return this._afi;
    }

    public <E extends Augmentation<ASAddress>> E getAugmentation(Class<E> augmentationType) {
        if (augmentationType == null) {
            throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
        }
        return (E)this.augmentation.get(augmentationType);
    }

    public ASAddressBuilder setAS(Integer value) {
        this._aS = value;
        return this;
    }

    public ASAddressBuilder setAfi(Short value) {
        this._afi = value;
        return this;
    }

    public ASAddressBuilder addAugmentation(Class<? extends Augmentation<ASAddress>> augmentationType, Augmentation<ASAddress> augmentation) {
        if (augmentation == null) {
            return this.removeAugmentation(augmentationType);
        }
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<ASAddress>>, Augmentation<ASAddress>>();
        }
        this.augmentation.put(augmentationType, augmentation);
        return this;
    }

    public ASAddressBuilder removeAugmentation(Class<? extends Augmentation<ASAddress>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    public ASAddress build() {
        return new ASAddressImpl(this);
    }

    private static final class ASAddressImpl
    implements ASAddress {
        private final Integer _aS;
        private final Short _afi;
        private Map<Class<? extends Augmentation<ASAddress>>, Augmentation<ASAddress>> augmentation = Collections.emptyMap();
        private int hash = 0;
        private volatile boolean hashValid = false;

        public Class<ASAddress> getImplementedInterface() {
            return ASAddress.class;
        }

        private ASAddressImpl(ASAddressBuilder base) {
            this._aS = base.getAS();
            this._afi = base.getAfi();
            switch (base.augmentation.size()) {
                case 0: {
                    this.augmentation = Collections.emptyMap();
                    break;
                }
                case 1: {
                    Map.Entry<Class<? extends Augmentation<ASAddress>>, Augmentation<ASAddress>> e = base.augmentation.entrySet().iterator().next();
                    this.augmentation = Collections.singletonMap(e.getKey(), e.getValue());
                    break;
                }
                default: {
                    this.augmentation = new HashMap<Class<? extends Augmentation<ASAddress>>, Augmentation<ASAddress>>(base.augmentation);
                }
            }
        }

        @Override
        public Integer getAS() {
            return this._aS;
        }

        @Override
        public Short getAfi() {
            return this._afi;
        }

        public <E extends Augmentation<ASAddress>> E getAugmentation(Class<E> augmentationType) {
            if (augmentationType == null) {
                throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
            }
            return (E)this.augmentation.get(augmentationType);
        }

        public int hashCode() {
            if (this.hashValid) {
                return this.hash;
            }
            int prime = 31;
            int result = 1;
            result = 31 * result + (this._aS == null ? 0 : this._aS.hashCode());
            result = 31 * result + (this._afi == null ? 0 : this._afi.hashCode());
            this.hash = result = 31 * result + (this.augmentation == null ? 0 : this.augmentation.hashCode());
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!ASAddress.class.equals((Object)((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            ASAddress other = (ASAddress)obj;
            if (this._aS == null ? other.getAS() != null : !this._aS.equals(other.getAS())) {
                return false;
            }
            if (this._afi == null ? other.getAfi() != null : !this._afi.equals(other.getAfi())) {
                return false;
            }
            if (this.getClass() == obj.getClass()) {
                ASAddressImpl otherImpl = (ASAddressImpl)obj;
                if (this.augmentation == null ? otherImpl.augmentation != null : !this.augmentation.equals(otherImpl.augmentation)) {
                    return false;
                }
            } else {
                for (Map.Entry<Class<? extends Augmentation<ASAddress>>, Augmentation<ASAddress>> e : this.augmentation.entrySet()) {
                    if (e.getValue().equals((Object)other.getAugmentation(e.getKey()))) continue;
                    return false;
                }
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }

        public String toString() {
            StringBuilder builder = new StringBuilder("ASAddress [");
            boolean first = true;
            if (this._aS != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_aS=");
                builder.append(this._aS);
            }
            if (this._afi != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_afi=");
                builder.append(this._afi);
            }
            if (first) {
                first = false;
            } else {
                builder.append(", ");
            }
            builder.append("augmentation=");
            builder.append(this.augmentation.values());
            return builder.append(']').toString();
        }
    }
}

