/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.control.plane.rev150314.locatorrecords;

import com.google.common.collect.Range;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.control.plane.rev150314.LispAddress;
import org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.control.plane.rev150314.lispaddress.LispAddressContainer;
import org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.control.plane.rev150314.locatorrecords.LocatorRecord;
import org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.control.plane.rev150314.locatorrecords.LocatorRecordKey;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class LocatorRecordBuilder
implements Builder<LocatorRecord> {
    private LocatorRecordKey _key;
    private LispAddressContainer _lispAddressContainer;
    private Short _multicastPriority;
    private Short _multicastWeight;
    private String _name;
    private Short _priority;
    private Short _weight;
    private Boolean _localLocator;
    private Boolean _rlocProbed;
    private Boolean _routed;
    Map<Class<? extends Augmentation<LocatorRecord>>, Augmentation<LocatorRecord>> augmentation = Collections.emptyMap();

    public LocatorRecordBuilder() {
    }

    public LocatorRecordBuilder(LispAddress arg) {
        this._lispAddressContainer = arg.getLispAddressContainer();
    }

    public LocatorRecordBuilder(LocatorRecord base) {
        AugmentationHolder casted;
        if (base.getKey() == null) {
            this._key = new LocatorRecordKey(base.getName());
            this._name = base.getName();
        } else {
            this._key = base.getKey();
            this._name = this._key.getName();
        }
        this._lispAddressContainer = base.getLispAddressContainer();
        this._multicastPriority = base.getMulticastPriority();
        this._multicastWeight = base.getMulticastWeight();
        this._priority = base.getPriority();
        this._weight = base.getWeight();
        this._localLocator = base.isLocalLocator();
        this._rlocProbed = base.isRlocProbed();
        this._routed = base.isRouted();
        if (base instanceof LocatorRecordImpl) {
            LocatorRecordImpl impl = (LocatorRecordImpl)base;
            if (!impl.augmentation.isEmpty()) {
                this.augmentation = new HashMap<Class<? extends Augmentation<LocatorRecord>>, Augmentation<LocatorRecord>>(impl.augmentation);
            }
        } else if (base instanceof AugmentationHolder && !(casted = (AugmentationHolder)base).augmentations().isEmpty()) {
            this.augmentation = new HashMap<Class<? extends Augmentation<LocatorRecord>>, Augmentation<LocatorRecord>>(casted.augmentations());
        }
    }

    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof LispAddress) {
            this._lispAddressContainer = ((LispAddress)arg).getLispAddressContainer();
            isValidArg = true;
        }
        if (!isValidArg) {
            throw new IllegalArgumentException("expected one of: [org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.control.plane.rev150314.LispAddress] \nbut was: " + arg);
        }
    }

    public LocatorRecordKey getKey() {
        return this._key;
    }

    public LispAddressContainer getLispAddressContainer() {
        return this._lispAddressContainer;
    }

    public Short getMulticastPriority() {
        return this._multicastPriority;
    }

    public Short getMulticastWeight() {
        return this._multicastWeight;
    }

    public String getName() {
        return this._name;
    }

    public Short getPriority() {
        return this._priority;
    }

    public Short getWeight() {
        return this._weight;
    }

    public Boolean isLocalLocator() {
        return this._localLocator;
    }

    public Boolean isRlocProbed() {
        return this._rlocProbed;
    }

    public Boolean isRouted() {
        return this._routed;
    }

    public <E extends Augmentation<LocatorRecord>> E getAugmentation(Class<E> augmentationType) {
        if (augmentationType == null) {
            throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
        }
        return (E)this.augmentation.get(augmentationType);
    }

    public LocatorRecordBuilder setKey(LocatorRecordKey value) {
        this._key = value;
        return this;
    }

    public LocatorRecordBuilder setLispAddressContainer(LispAddressContainer value) {
        this._lispAddressContainer = value;
        return this;
    }

    private static void checkMulticastPriorityRange(short value) {
        if (value >= 0 && value <= 255) {
            return;
        }
        throw new IllegalArgumentException(String.format("Invalid range: %s, expected: [[0\u2025255]].", value));
    }

    public LocatorRecordBuilder setMulticastPriority(Short value) {
        if (value != null) {
            LocatorRecordBuilder.checkMulticastPriorityRange(value);
        }
        this._multicastPriority = value;
        return this;
    }

    @Deprecated
    public static List<Range<BigInteger>> _multicastPriority_range() {
        ArrayList<Range<BigInteger>> ret = new ArrayList<Range<BigInteger>>(1);
        ret.add(Range.closed((Comparable)BigInteger.ZERO, (Comparable)BigInteger.valueOf(255L)));
        return ret;
    }

    private static void checkMulticastWeightRange(short value) {
        if (value >= 0 && value <= 255) {
            return;
        }
        throw new IllegalArgumentException(String.format("Invalid range: %s, expected: [[0\u2025255]].", value));
    }

    public LocatorRecordBuilder setMulticastWeight(Short value) {
        if (value != null) {
            LocatorRecordBuilder.checkMulticastWeightRange(value);
        }
        this._multicastWeight = value;
        return this;
    }

    @Deprecated
    public static List<Range<BigInteger>> _multicastWeight_range() {
        ArrayList<Range<BigInteger>> ret = new ArrayList<Range<BigInteger>>(1);
        ret.add(Range.closed((Comparable)BigInteger.ZERO, (Comparable)BigInteger.valueOf(255L)));
        return ret;
    }

    public LocatorRecordBuilder setName(String value) {
        this._name = value;
        return this;
    }

    private static void checkPriorityRange(short value) {
        if (value >= 0 && value <= 255) {
            return;
        }
        throw new IllegalArgumentException(String.format("Invalid range: %s, expected: [[0\u2025255]].", value));
    }

    public LocatorRecordBuilder setPriority(Short value) {
        if (value != null) {
            LocatorRecordBuilder.checkPriorityRange(value);
        }
        this._priority = value;
        return this;
    }

    @Deprecated
    public static List<Range<BigInteger>> _priority_range() {
        ArrayList<Range<BigInteger>> ret = new ArrayList<Range<BigInteger>>(1);
        ret.add(Range.closed((Comparable)BigInteger.ZERO, (Comparable)BigInteger.valueOf(255L)));
        return ret;
    }

    private static void checkWeightRange(short value) {
        if (value >= 0 && value <= 255) {
            return;
        }
        throw new IllegalArgumentException(String.format("Invalid range: %s, expected: [[0\u2025255]].", value));
    }

    public LocatorRecordBuilder setWeight(Short value) {
        if (value != null) {
            LocatorRecordBuilder.checkWeightRange(value);
        }
        this._weight = value;
        return this;
    }

    @Deprecated
    public static List<Range<BigInteger>> _weight_range() {
        ArrayList<Range<BigInteger>> ret = new ArrayList<Range<BigInteger>>(1);
        ret.add(Range.closed((Comparable)BigInteger.ZERO, (Comparable)BigInteger.valueOf(255L)));
        return ret;
    }

    public LocatorRecordBuilder setLocalLocator(Boolean value) {
        this._localLocator = value;
        return this;
    }

    public LocatorRecordBuilder setRlocProbed(Boolean value) {
        this._rlocProbed = value;
        return this;
    }

    public LocatorRecordBuilder setRouted(Boolean value) {
        this._routed = value;
        return this;
    }

    public LocatorRecordBuilder addAugmentation(Class<? extends Augmentation<LocatorRecord>> augmentationType, Augmentation<LocatorRecord> augmentation) {
        if (augmentation == null) {
            return this.removeAugmentation(augmentationType);
        }
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<LocatorRecord>>, Augmentation<LocatorRecord>>();
        }
        this.augmentation.put(augmentationType, augmentation);
        return this;
    }

    public LocatorRecordBuilder removeAugmentation(Class<? extends Augmentation<LocatorRecord>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    public LocatorRecord build() {
        return new LocatorRecordImpl(this);
    }

    private static final class LocatorRecordImpl
    implements LocatorRecord {
        private final LocatorRecordKey _key;
        private final LispAddressContainer _lispAddressContainer;
        private final Short _multicastPriority;
        private final Short _multicastWeight;
        private final String _name;
        private final Short _priority;
        private final Short _weight;
        private final Boolean _localLocator;
        private final Boolean _rlocProbed;
        private final Boolean _routed;
        private Map<Class<? extends Augmentation<LocatorRecord>>, Augmentation<LocatorRecord>> augmentation = Collections.emptyMap();
        private int hash = 0;
        private volatile boolean hashValid = false;

        public Class<LocatorRecord> getImplementedInterface() {
            return LocatorRecord.class;
        }

        private LocatorRecordImpl(LocatorRecordBuilder base) {
            if (base.getKey() == null) {
                this._key = new LocatorRecordKey(base.getName());
                this._name = base.getName();
            } else {
                this._key = base.getKey();
                this._name = this._key.getName();
            }
            this._lispAddressContainer = base.getLispAddressContainer();
            this._multicastPriority = base.getMulticastPriority();
            this._multicastWeight = base.getMulticastWeight();
            this._priority = base.getPriority();
            this._weight = base.getWeight();
            this._localLocator = base.isLocalLocator();
            this._rlocProbed = base.isRlocProbed();
            this._routed = base.isRouted();
            switch (base.augmentation.size()) {
                case 0: {
                    this.augmentation = Collections.emptyMap();
                    break;
                }
                case 1: {
                    Map.Entry<Class<? extends Augmentation<LocatorRecord>>, Augmentation<LocatorRecord>> e = base.augmentation.entrySet().iterator().next();
                    this.augmentation = Collections.singletonMap(e.getKey(), e.getValue());
                    break;
                }
                default: {
                    this.augmentation = new HashMap<Class<? extends Augmentation<LocatorRecord>>, Augmentation<LocatorRecord>>(base.augmentation);
                }
            }
        }

        @Override
        public LocatorRecordKey getKey() {
            return this._key;
        }

        @Override
        public LispAddressContainer getLispAddressContainer() {
            return this._lispAddressContainer;
        }

        @Override
        public Short getMulticastPriority() {
            return this._multicastPriority;
        }

        @Override
        public Short getMulticastWeight() {
            return this._multicastWeight;
        }

        @Override
        public String getName() {
            return this._name;
        }

        @Override
        public Short getPriority() {
            return this._priority;
        }

        @Override
        public Short getWeight() {
            return this._weight;
        }

        @Override
        public Boolean isLocalLocator() {
            return this._localLocator;
        }

        @Override
        public Boolean isRlocProbed() {
            return this._rlocProbed;
        }

        @Override
        public Boolean isRouted() {
            return this._routed;
        }

        public <E extends Augmentation<LocatorRecord>> E getAugmentation(Class<E> augmentationType) {
            if (augmentationType == null) {
                throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
            }
            return (E)this.augmentation.get(augmentationType);
        }

        public int hashCode() {
            if (this.hashValid) {
                return this.hash;
            }
            int prime = 31;
            int result = 1;
            result = 31 * result + (this._key == null ? 0 : this._key.hashCode());
            result = 31 * result + (this._lispAddressContainer == null ? 0 : this._lispAddressContainer.hashCode());
            result = 31 * result + (this._multicastPriority == null ? 0 : this._multicastPriority.hashCode());
            result = 31 * result + (this._multicastWeight == null ? 0 : this._multicastWeight.hashCode());
            result = 31 * result + (this._name == null ? 0 : this._name.hashCode());
            result = 31 * result + (this._priority == null ? 0 : this._priority.hashCode());
            result = 31 * result + (this._weight == null ? 0 : this._weight.hashCode());
            result = 31 * result + (this._localLocator == null ? 0 : this._localLocator.hashCode());
            result = 31 * result + (this._rlocProbed == null ? 0 : this._rlocProbed.hashCode());
            result = 31 * result + (this._routed == null ? 0 : this._routed.hashCode());
            this.hash = result = 31 * result + (this.augmentation == null ? 0 : this.augmentation.hashCode());
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!LocatorRecord.class.equals((Object)((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            LocatorRecord other = (LocatorRecord)obj;
            if (this._key == null ? other.getKey() != null : !this._key.equals(other.getKey())) {
                return false;
            }
            if (this._lispAddressContainer == null ? other.getLispAddressContainer() != null : !this._lispAddressContainer.equals(other.getLispAddressContainer())) {
                return false;
            }
            if (this._multicastPriority == null ? other.getMulticastPriority() != null : !this._multicastPriority.equals(other.getMulticastPriority())) {
                return false;
            }
            if (this._multicastWeight == null ? other.getMulticastWeight() != null : !this._multicastWeight.equals(other.getMulticastWeight())) {
                return false;
            }
            if (this._name == null ? other.getName() != null : !this._name.equals(other.getName())) {
                return false;
            }
            if (this._priority == null ? other.getPriority() != null : !this._priority.equals(other.getPriority())) {
                return false;
            }
            if (this._weight == null ? other.getWeight() != null : !this._weight.equals(other.getWeight())) {
                return false;
            }
            if (this._localLocator == null ? other.isLocalLocator() != null : !this._localLocator.equals(other.isLocalLocator())) {
                return false;
            }
            if (this._rlocProbed == null ? other.isRlocProbed() != null : !this._rlocProbed.equals(other.isRlocProbed())) {
                return false;
            }
            if (this._routed == null ? other.isRouted() != null : !this._routed.equals(other.isRouted())) {
                return false;
            }
            if (this.getClass() == obj.getClass()) {
                LocatorRecordImpl otherImpl = (LocatorRecordImpl)obj;
                if (this.augmentation == null ? otherImpl.augmentation != null : !this.augmentation.equals(otherImpl.augmentation)) {
                    return false;
                }
            } else {
                for (Map.Entry<Class<? extends Augmentation<LocatorRecord>>, Augmentation<LocatorRecord>> e : this.augmentation.entrySet()) {
                    if (e.getValue().equals((Object)other.getAugmentation(e.getKey()))) continue;
                    return false;
                }
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }

        public String toString() {
            StringBuilder builder = new StringBuilder("LocatorRecord [");
            boolean first = true;
            if (this._key != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_key=");
                builder.append(this._key);
            }
            if (this._lispAddressContainer != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_lispAddressContainer=");
                builder.append(this._lispAddressContainer);
            }
            if (this._multicastPriority != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_multicastPriority=");
                builder.append(this._multicastPriority);
            }
            if (this._multicastWeight != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_multicastWeight=");
                builder.append(this._multicastWeight);
            }
            if (this._name != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_name=");
                builder.append(this._name);
            }
            if (this._priority != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_priority=");
                builder.append(this._priority);
            }
            if (this._weight != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_weight=");
                builder.append(this._weight);
            }
            if (this._localLocator != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_localLocator=");
                builder.append(this._localLocator);
            }
            if (this._rlocProbed != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_rlocProbed=");
                builder.append(this._rlocProbed);
            }
            if (this._routed != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_routed=");
                builder.append(this._routed);
            }
            if (first) {
                first = false;
            } else {
                builder.append(", ");
            }
            builder.append("augmentation=");
            builder.append(this.augmentation.values());
            return builder.append(']').toString();
        }
    }
}

