/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.control.plane.rev150314.mapnotifymessage;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.control.plane.rev150314.EidToLocatorRecords;
import org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.control.plane.rev150314.XtrSiteId;
import org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.control.plane.rev150314.eidtolocatorrecords.EidToLocatorRecord;
import org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.control.plane.rev150314.mapnotifymessage.MapNotify;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class MapNotifyBuilder
implements Builder<MapNotify> {
    private byte[] _authenticationData;
    private List<EidToLocatorRecord> _eidToLocatorRecord;
    private Short _keyId;
    private Long _nonce;
    private byte[] _siteId;
    private byte[] _xtrId;
    private Boolean _xtrSiteIdPresent;
    Map<Class<? extends Augmentation<MapNotify>>, Augmentation<MapNotify>> augmentation = Collections.emptyMap();

    public MapNotifyBuilder() {
    }

    public MapNotifyBuilder(org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.control.plane.rev150314.MapNotify arg) {
        this._xtrSiteIdPresent = arg.isXtrSiteIdPresent();
        this._nonce = arg.getNonce();
        this._keyId = arg.getKeyId();
        this._authenticationData = arg.getAuthenticationData();
        this._eidToLocatorRecord = arg.getEidToLocatorRecord();
        this._xtrId = arg.getXtrId();
        this._siteId = arg.getSiteId();
    }

    public MapNotifyBuilder(EidToLocatorRecords arg) {
        this._eidToLocatorRecord = arg.getEidToLocatorRecord();
    }

    public MapNotifyBuilder(XtrSiteId arg) {
        this._xtrId = arg.getXtrId();
        this._siteId = arg.getSiteId();
    }

    public MapNotifyBuilder(MapNotify base) {
        AugmentationHolder casted;
        this._authenticationData = base.getAuthenticationData();
        this._eidToLocatorRecord = base.getEidToLocatorRecord();
        this._keyId = base.getKeyId();
        this._nonce = base.getNonce();
        this._siteId = base.getSiteId();
        this._xtrId = base.getXtrId();
        this._xtrSiteIdPresent = base.isXtrSiteIdPresent();
        if (base instanceof MapNotifyImpl) {
            MapNotifyImpl impl = (MapNotifyImpl)base;
            if (!impl.augmentation.isEmpty()) {
                this.augmentation = new HashMap<Class<? extends Augmentation<MapNotify>>, Augmentation<MapNotify>>(impl.augmentation);
            }
        } else if (base instanceof AugmentationHolder && !(casted = (AugmentationHolder)base).augmentations().isEmpty()) {
            this.augmentation = new HashMap<Class<? extends Augmentation<MapNotify>>, Augmentation<MapNotify>>(casted.augmentations());
        }
    }

    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.control.plane.rev150314.MapNotify) {
            this._xtrSiteIdPresent = ((org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.control.plane.rev150314.MapNotify)arg).isXtrSiteIdPresent();
            this._nonce = ((org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.control.plane.rev150314.MapNotify)arg).getNonce();
            this._keyId = ((org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.control.plane.rev150314.MapNotify)arg).getKeyId();
            this._authenticationData = ((org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.control.plane.rev150314.MapNotify)arg).getAuthenticationData();
            isValidArg = true;
        }
        if (arg instanceof XtrSiteId) {
            this._xtrId = ((XtrSiteId)arg).getXtrId();
            this._siteId = ((XtrSiteId)arg).getSiteId();
            isValidArg = true;
        }
        if (arg instanceof EidToLocatorRecords) {
            this._eidToLocatorRecord = ((EidToLocatorRecords)arg).getEidToLocatorRecord();
            isValidArg = true;
        }
        if (!isValidArg) {
            throw new IllegalArgumentException("expected one of: [org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.control.plane.rev150314.MapNotify, org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.control.plane.rev150314.XtrSiteId, org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.control.plane.rev150314.EidToLocatorRecords] \nbut was: " + arg);
        }
    }

    public byte[] getAuthenticationData() {
        return this._authenticationData == null ? null : (byte[])this._authenticationData.clone();
    }

    public List<EidToLocatorRecord> getEidToLocatorRecord() {
        return this._eidToLocatorRecord;
    }

    public Short getKeyId() {
        return this._keyId;
    }

    public Long getNonce() {
        return this._nonce;
    }

    public byte[] getSiteId() {
        return this._siteId == null ? null : (byte[])this._siteId.clone();
    }

    public byte[] getXtrId() {
        return this._xtrId == null ? null : (byte[])this._xtrId.clone();
    }

    public Boolean isXtrSiteIdPresent() {
        return this._xtrSiteIdPresent;
    }

    public <E extends Augmentation<MapNotify>> E getAugmentation(Class<E> augmentationType) {
        if (augmentationType == null) {
            throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
        }
        return (E)this.augmentation.get(augmentationType);
    }

    public MapNotifyBuilder setAuthenticationData(byte[] value) {
        this._authenticationData = value;
        return this;
    }

    public MapNotifyBuilder setEidToLocatorRecord(List<EidToLocatorRecord> value) {
        this._eidToLocatorRecord = value;
        return this;
    }

    public MapNotifyBuilder setKeyId(Short value) {
        this._keyId = value;
        return this;
    }

    public MapNotifyBuilder setNonce(Long value) {
        this._nonce = value;
        return this;
    }

    public MapNotifyBuilder setSiteId(byte[] value) {
        this._siteId = value;
        return this;
    }

    public MapNotifyBuilder setXtrId(byte[] value) {
        this._xtrId = value;
        return this;
    }

    public MapNotifyBuilder setXtrSiteIdPresent(Boolean value) {
        this._xtrSiteIdPresent = value;
        return this;
    }

    public MapNotifyBuilder addAugmentation(Class<? extends Augmentation<MapNotify>> augmentationType, Augmentation<MapNotify> augmentation) {
        if (augmentation == null) {
            return this.removeAugmentation(augmentationType);
        }
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<MapNotify>>, Augmentation<MapNotify>>();
        }
        this.augmentation.put(augmentationType, augmentation);
        return this;
    }

    public MapNotifyBuilder removeAugmentation(Class<? extends Augmentation<MapNotify>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    public MapNotify build() {
        return new MapNotifyImpl(this);
    }

    private static final class MapNotifyImpl
    implements MapNotify {
        private final byte[] _authenticationData;
        private final List<EidToLocatorRecord> _eidToLocatorRecord;
        private final Short _keyId;
        private final Long _nonce;
        private final byte[] _siteId;
        private final byte[] _xtrId;
        private final Boolean _xtrSiteIdPresent;
        private Map<Class<? extends Augmentation<MapNotify>>, Augmentation<MapNotify>> augmentation = Collections.emptyMap();
        private int hash = 0;
        private volatile boolean hashValid = false;

        public Class<MapNotify> getImplementedInterface() {
            return MapNotify.class;
        }

        private MapNotifyImpl(MapNotifyBuilder base) {
            this._authenticationData = base.getAuthenticationData();
            this._eidToLocatorRecord = base.getEidToLocatorRecord();
            this._keyId = base.getKeyId();
            this._nonce = base.getNonce();
            this._siteId = base.getSiteId();
            this._xtrId = base.getXtrId();
            this._xtrSiteIdPresent = base.isXtrSiteIdPresent();
            switch (base.augmentation.size()) {
                case 0: {
                    this.augmentation = Collections.emptyMap();
                    break;
                }
                case 1: {
                    Map.Entry<Class<? extends Augmentation<MapNotify>>, Augmentation<MapNotify>> e = base.augmentation.entrySet().iterator().next();
                    this.augmentation = Collections.singletonMap(e.getKey(), e.getValue());
                    break;
                }
                default: {
                    this.augmentation = new HashMap<Class<? extends Augmentation<MapNotify>>, Augmentation<MapNotify>>(base.augmentation);
                }
            }
        }

        @Override
        public byte[] getAuthenticationData() {
            return this._authenticationData == null ? null : (byte[])this._authenticationData.clone();
        }

        @Override
        public List<EidToLocatorRecord> getEidToLocatorRecord() {
            return this._eidToLocatorRecord;
        }

        @Override
        public Short getKeyId() {
            return this._keyId;
        }

        @Override
        public Long getNonce() {
            return this._nonce;
        }

        @Override
        public byte[] getSiteId() {
            return this._siteId == null ? null : (byte[])this._siteId.clone();
        }

        @Override
        public byte[] getXtrId() {
            return this._xtrId == null ? null : (byte[])this._xtrId.clone();
        }

        @Override
        public Boolean isXtrSiteIdPresent() {
            return this._xtrSiteIdPresent;
        }

        public <E extends Augmentation<MapNotify>> E getAugmentation(Class<E> augmentationType) {
            if (augmentationType == null) {
                throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
            }
            return (E)this.augmentation.get(augmentationType);
        }

        public int hashCode() {
            if (this.hashValid) {
                return this.hash;
            }
            int prime = 31;
            int result = 1;
            result = 31 * result + (this._authenticationData == null ? 0 : Arrays.hashCode(this._authenticationData));
            result = 31 * result + (this._eidToLocatorRecord == null ? 0 : this._eidToLocatorRecord.hashCode());
            result = 31 * result + (this._keyId == null ? 0 : this._keyId.hashCode());
            result = 31 * result + (this._nonce == null ? 0 : this._nonce.hashCode());
            result = 31 * result + (this._siteId == null ? 0 : Arrays.hashCode(this._siteId));
            result = 31 * result + (this._xtrId == null ? 0 : Arrays.hashCode(this._xtrId));
            result = 31 * result + (this._xtrSiteIdPresent == null ? 0 : this._xtrSiteIdPresent.hashCode());
            this.hash = result = 31 * result + (this.augmentation == null ? 0 : this.augmentation.hashCode());
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!MapNotify.class.equals((Object)((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            MapNotify other = (MapNotify)obj;
            if (this._authenticationData == null ? other.getAuthenticationData() != null : !Arrays.equals(this._authenticationData, other.getAuthenticationData())) {
                return false;
            }
            if (this._eidToLocatorRecord == null ? other.getEidToLocatorRecord() != null : !this._eidToLocatorRecord.equals(other.getEidToLocatorRecord())) {
                return false;
            }
            if (this._keyId == null ? other.getKeyId() != null : !this._keyId.equals(other.getKeyId())) {
                return false;
            }
            if (this._nonce == null ? other.getNonce() != null : !this._nonce.equals(other.getNonce())) {
                return false;
            }
            if (this._siteId == null ? other.getSiteId() != null : !Arrays.equals(this._siteId, other.getSiteId())) {
                return false;
            }
            if (this._xtrId == null ? other.getXtrId() != null : !Arrays.equals(this._xtrId, other.getXtrId())) {
                return false;
            }
            if (this._xtrSiteIdPresent == null ? other.isXtrSiteIdPresent() != null : !this._xtrSiteIdPresent.equals(other.isXtrSiteIdPresent())) {
                return false;
            }
            if (this.getClass() == obj.getClass()) {
                MapNotifyImpl otherImpl = (MapNotifyImpl)obj;
                if (this.augmentation == null ? otherImpl.augmentation != null : !this.augmentation.equals(otherImpl.augmentation)) {
                    return false;
                }
            } else {
                for (Map.Entry<Class<? extends Augmentation<MapNotify>>, Augmentation<MapNotify>> e : this.augmentation.entrySet()) {
                    if (e.getValue().equals((Object)other.getAugmentation(e.getKey()))) continue;
                    return false;
                }
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }

        public String toString() {
            StringBuilder builder = new StringBuilder("MapNotify [");
            boolean first = true;
            if (this._authenticationData != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_authenticationData=");
                builder.append(Arrays.toString(this._authenticationData));
            }
            if (this._eidToLocatorRecord != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_eidToLocatorRecord=");
                builder.append(this._eidToLocatorRecord);
            }
            if (this._keyId != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_keyId=");
                builder.append(this._keyId);
            }
            if (this._nonce != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_nonce=");
                builder.append(this._nonce);
            }
            if (this._siteId != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_siteId=");
                builder.append(Arrays.toString(this._siteId));
            }
            if (this._xtrId != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_xtrId=");
                builder.append(Arrays.toString(this._xtrId));
            }
            if (this._xtrSiteIdPresent != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_xtrSiteIdPresent=");
                builder.append(this._xtrSiteIdPresent);
            }
            if (first) {
                first = false;
            } else {
                builder.append(", ");
            }
            builder.append("augmentation=");
            builder.append(this.augmentation.values());
            return builder.append(']').toString();
        }
    }
}

