/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.control.plane.rev150314.mapregisternotification;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.control.plane.rev150314.EidToLocatorRecords;
import org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.control.plane.rev150314.XtrSiteId;
import org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.control.plane.rev150314.eidtolocatorrecords.EidToLocatorRecord;
import org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.control.plane.rev150314.mapregisternotification.MapRegister;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class MapRegisterBuilder
implements Builder<MapRegister> {
    private byte[] _authenticationData;
    private List<EidToLocatorRecord> _eidToLocatorRecord;
    private Short _keyId;
    private Long _nonce;
    private byte[] _siteId;
    private byte[] _xtrId;
    private Boolean _proxyMapReply;
    private Boolean _wantMapNotify;
    private Boolean _xtrSiteIdPresent;
    Map<Class<? extends Augmentation<MapRegister>>, Augmentation<MapRegister>> augmentation = Collections.emptyMap();

    public MapRegisterBuilder() {
    }

    public MapRegisterBuilder(org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.control.plane.rev150314.MapRegister arg) {
        this._proxyMapReply = arg.isProxyMapReply();
        this._xtrSiteIdPresent = arg.isXtrSiteIdPresent();
        this._wantMapNotify = arg.isWantMapNotify();
        this._nonce = arg.getNonce();
        this._keyId = arg.getKeyId();
        this._authenticationData = arg.getAuthenticationData();
        this._eidToLocatorRecord = arg.getEidToLocatorRecord();
        this._xtrId = arg.getXtrId();
        this._siteId = arg.getSiteId();
    }

    public MapRegisterBuilder(EidToLocatorRecords arg) {
        this._eidToLocatorRecord = arg.getEidToLocatorRecord();
    }

    public MapRegisterBuilder(XtrSiteId arg) {
        this._xtrId = arg.getXtrId();
        this._siteId = arg.getSiteId();
    }

    public MapRegisterBuilder(MapRegister base) {
        AugmentationHolder casted;
        this._authenticationData = base.getAuthenticationData();
        this._eidToLocatorRecord = base.getEidToLocatorRecord();
        this._keyId = base.getKeyId();
        this._nonce = base.getNonce();
        this._siteId = base.getSiteId();
        this._xtrId = base.getXtrId();
        this._proxyMapReply = base.isProxyMapReply();
        this._wantMapNotify = base.isWantMapNotify();
        this._xtrSiteIdPresent = base.isXtrSiteIdPresent();
        if (base instanceof MapRegisterImpl) {
            MapRegisterImpl impl = (MapRegisterImpl)base;
            if (!impl.augmentation.isEmpty()) {
                this.augmentation = new HashMap<Class<? extends Augmentation<MapRegister>>, Augmentation<MapRegister>>(impl.augmentation);
            }
        } else if (base instanceof AugmentationHolder && !(casted = (AugmentationHolder)base).augmentations().isEmpty()) {
            this.augmentation = new HashMap<Class<? extends Augmentation<MapRegister>>, Augmentation<MapRegister>>(casted.augmentations());
        }
    }

    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.control.plane.rev150314.MapRegister) {
            this._proxyMapReply = ((org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.control.plane.rev150314.MapRegister)arg).isProxyMapReply();
            this._xtrSiteIdPresent = ((org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.control.plane.rev150314.MapRegister)arg).isXtrSiteIdPresent();
            this._wantMapNotify = ((org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.control.plane.rev150314.MapRegister)arg).isWantMapNotify();
            this._nonce = ((org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.control.plane.rev150314.MapRegister)arg).getNonce();
            this._keyId = ((org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.control.plane.rev150314.MapRegister)arg).getKeyId();
            this._authenticationData = ((org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.control.plane.rev150314.MapRegister)arg).getAuthenticationData();
            isValidArg = true;
        }
        if (arg instanceof XtrSiteId) {
            this._xtrId = ((XtrSiteId)arg).getXtrId();
            this._siteId = ((XtrSiteId)arg).getSiteId();
            isValidArg = true;
        }
        if (arg instanceof EidToLocatorRecords) {
            this._eidToLocatorRecord = ((EidToLocatorRecords)arg).getEidToLocatorRecord();
            isValidArg = true;
        }
        if (!isValidArg) {
            throw new IllegalArgumentException("expected one of: [org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.control.plane.rev150314.MapRegister, org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.control.plane.rev150314.XtrSiteId, org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.control.plane.rev150314.EidToLocatorRecords] \nbut was: " + arg);
        }
    }

    public byte[] getAuthenticationData() {
        return this._authenticationData == null ? null : (byte[])this._authenticationData.clone();
    }

    public List<EidToLocatorRecord> getEidToLocatorRecord() {
        return this._eidToLocatorRecord;
    }

    public Short getKeyId() {
        return this._keyId;
    }

    public Long getNonce() {
        return this._nonce;
    }

    public byte[] getSiteId() {
        return this._siteId == null ? null : (byte[])this._siteId.clone();
    }

    public byte[] getXtrId() {
        return this._xtrId == null ? null : (byte[])this._xtrId.clone();
    }

    public Boolean isProxyMapReply() {
        return this._proxyMapReply;
    }

    public Boolean isWantMapNotify() {
        return this._wantMapNotify;
    }

    public Boolean isXtrSiteIdPresent() {
        return this._xtrSiteIdPresent;
    }

    public <E extends Augmentation<MapRegister>> E getAugmentation(Class<E> augmentationType) {
        if (augmentationType == null) {
            throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
        }
        return (E)this.augmentation.get(augmentationType);
    }

    public MapRegisterBuilder setAuthenticationData(byte[] value) {
        this._authenticationData = value;
        return this;
    }

    public MapRegisterBuilder setEidToLocatorRecord(List<EidToLocatorRecord> value) {
        this._eidToLocatorRecord = value;
        return this;
    }

    public MapRegisterBuilder setKeyId(Short value) {
        this._keyId = value;
        return this;
    }

    public MapRegisterBuilder setNonce(Long value) {
        this._nonce = value;
        return this;
    }

    public MapRegisterBuilder setSiteId(byte[] value) {
        this._siteId = value;
        return this;
    }

    public MapRegisterBuilder setXtrId(byte[] value) {
        this._xtrId = value;
        return this;
    }

    public MapRegisterBuilder setProxyMapReply(Boolean value) {
        this._proxyMapReply = value;
        return this;
    }

    public MapRegisterBuilder setWantMapNotify(Boolean value) {
        this._wantMapNotify = value;
        return this;
    }

    public MapRegisterBuilder setXtrSiteIdPresent(Boolean value) {
        this._xtrSiteIdPresent = value;
        return this;
    }

    public MapRegisterBuilder addAugmentation(Class<? extends Augmentation<MapRegister>> augmentationType, Augmentation<MapRegister> augmentation) {
        if (augmentation == null) {
            return this.removeAugmentation(augmentationType);
        }
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<MapRegister>>, Augmentation<MapRegister>>();
        }
        this.augmentation.put(augmentationType, augmentation);
        return this;
    }

    public MapRegisterBuilder removeAugmentation(Class<? extends Augmentation<MapRegister>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    public MapRegister build() {
        return new MapRegisterImpl(this);
    }

    private static final class MapRegisterImpl
    implements MapRegister {
        private final byte[] _authenticationData;
        private final List<EidToLocatorRecord> _eidToLocatorRecord;
        private final Short _keyId;
        private final Long _nonce;
        private final byte[] _siteId;
        private final byte[] _xtrId;
        private final Boolean _proxyMapReply;
        private final Boolean _wantMapNotify;
        private final Boolean _xtrSiteIdPresent;
        private Map<Class<? extends Augmentation<MapRegister>>, Augmentation<MapRegister>> augmentation = Collections.emptyMap();
        private int hash = 0;
        private volatile boolean hashValid = false;

        public Class<MapRegister> getImplementedInterface() {
            return MapRegister.class;
        }

        private MapRegisterImpl(MapRegisterBuilder base) {
            this._authenticationData = base.getAuthenticationData();
            this._eidToLocatorRecord = base.getEidToLocatorRecord();
            this._keyId = base.getKeyId();
            this._nonce = base.getNonce();
            this._siteId = base.getSiteId();
            this._xtrId = base.getXtrId();
            this._proxyMapReply = base.isProxyMapReply();
            this._wantMapNotify = base.isWantMapNotify();
            this._xtrSiteIdPresent = base.isXtrSiteIdPresent();
            switch (base.augmentation.size()) {
                case 0: {
                    this.augmentation = Collections.emptyMap();
                    break;
                }
                case 1: {
                    Map.Entry<Class<? extends Augmentation<MapRegister>>, Augmentation<MapRegister>> e = base.augmentation.entrySet().iterator().next();
                    this.augmentation = Collections.singletonMap(e.getKey(), e.getValue());
                    break;
                }
                default: {
                    this.augmentation = new HashMap<Class<? extends Augmentation<MapRegister>>, Augmentation<MapRegister>>(base.augmentation);
                }
            }
        }

        @Override
        public byte[] getAuthenticationData() {
            return this._authenticationData == null ? null : (byte[])this._authenticationData.clone();
        }

        @Override
        public List<EidToLocatorRecord> getEidToLocatorRecord() {
            return this._eidToLocatorRecord;
        }

        @Override
        public Short getKeyId() {
            return this._keyId;
        }

        @Override
        public Long getNonce() {
            return this._nonce;
        }

        @Override
        public byte[] getSiteId() {
            return this._siteId == null ? null : (byte[])this._siteId.clone();
        }

        @Override
        public byte[] getXtrId() {
            return this._xtrId == null ? null : (byte[])this._xtrId.clone();
        }

        @Override
        public Boolean isProxyMapReply() {
            return this._proxyMapReply;
        }

        @Override
        public Boolean isWantMapNotify() {
            return this._wantMapNotify;
        }

        @Override
        public Boolean isXtrSiteIdPresent() {
            return this._xtrSiteIdPresent;
        }

        public <E extends Augmentation<MapRegister>> E getAugmentation(Class<E> augmentationType) {
            if (augmentationType == null) {
                throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
            }
            return (E)this.augmentation.get(augmentationType);
        }

        public int hashCode() {
            if (this.hashValid) {
                return this.hash;
            }
            int prime = 31;
            int result = 1;
            result = 31 * result + (this._authenticationData == null ? 0 : Arrays.hashCode(this._authenticationData));
            result = 31 * result + (this._eidToLocatorRecord == null ? 0 : this._eidToLocatorRecord.hashCode());
            result = 31 * result + (this._keyId == null ? 0 : this._keyId.hashCode());
            result = 31 * result + (this._nonce == null ? 0 : this._nonce.hashCode());
            result = 31 * result + (this._siteId == null ? 0 : Arrays.hashCode(this._siteId));
            result = 31 * result + (this._xtrId == null ? 0 : Arrays.hashCode(this._xtrId));
            result = 31 * result + (this._proxyMapReply == null ? 0 : this._proxyMapReply.hashCode());
            result = 31 * result + (this._wantMapNotify == null ? 0 : this._wantMapNotify.hashCode());
            result = 31 * result + (this._xtrSiteIdPresent == null ? 0 : this._xtrSiteIdPresent.hashCode());
            this.hash = result = 31 * result + (this.augmentation == null ? 0 : this.augmentation.hashCode());
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!MapRegister.class.equals((Object)((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            MapRegister other = (MapRegister)obj;
            if (this._authenticationData == null ? other.getAuthenticationData() != null : !Arrays.equals(this._authenticationData, other.getAuthenticationData())) {
                return false;
            }
            if (this._eidToLocatorRecord == null ? other.getEidToLocatorRecord() != null : !this._eidToLocatorRecord.equals(other.getEidToLocatorRecord())) {
                return false;
            }
            if (this._keyId == null ? other.getKeyId() != null : !this._keyId.equals(other.getKeyId())) {
                return false;
            }
            if (this._nonce == null ? other.getNonce() != null : !this._nonce.equals(other.getNonce())) {
                return false;
            }
            if (this._siteId == null ? other.getSiteId() != null : !Arrays.equals(this._siteId, other.getSiteId())) {
                return false;
            }
            if (this._xtrId == null ? other.getXtrId() != null : !Arrays.equals(this._xtrId, other.getXtrId())) {
                return false;
            }
            if (this._proxyMapReply == null ? other.isProxyMapReply() != null : !this._proxyMapReply.equals(other.isProxyMapReply())) {
                return false;
            }
            if (this._wantMapNotify == null ? other.isWantMapNotify() != null : !this._wantMapNotify.equals(other.isWantMapNotify())) {
                return false;
            }
            if (this._xtrSiteIdPresent == null ? other.isXtrSiteIdPresent() != null : !this._xtrSiteIdPresent.equals(other.isXtrSiteIdPresent())) {
                return false;
            }
            if (this.getClass() == obj.getClass()) {
                MapRegisterImpl otherImpl = (MapRegisterImpl)obj;
                if (this.augmentation == null ? otherImpl.augmentation != null : !this.augmentation.equals(otherImpl.augmentation)) {
                    return false;
                }
            } else {
                for (Map.Entry<Class<? extends Augmentation<MapRegister>>, Augmentation<MapRegister>> e : this.augmentation.entrySet()) {
                    if (e.getValue().equals((Object)other.getAugmentation(e.getKey()))) continue;
                    return false;
                }
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }

        public String toString() {
            StringBuilder builder = new StringBuilder("MapRegister [");
            boolean first = true;
            if (this._authenticationData != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_authenticationData=");
                builder.append(Arrays.toString(this._authenticationData));
            }
            if (this._eidToLocatorRecord != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_eidToLocatorRecord=");
                builder.append(this._eidToLocatorRecord);
            }
            if (this._keyId != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_keyId=");
                builder.append(this._keyId);
            }
            if (this._nonce != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_nonce=");
                builder.append(this._nonce);
            }
            if (this._siteId != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_siteId=");
                builder.append(Arrays.toString(this._siteId));
            }
            if (this._xtrId != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_xtrId=");
                builder.append(Arrays.toString(this._xtrId));
            }
            if (this._proxyMapReply != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_proxyMapReply=");
                builder.append(this._proxyMapReply);
            }
            if (this._wantMapNotify != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_wantMapNotify=");
                builder.append(this._wantMapNotify);
            }
            if (this._xtrSiteIdPresent != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_xtrSiteIdPresent=");
                builder.append(this._xtrSiteIdPresent);
            }
            if (first) {
                first = false;
            } else {
                builder.append(", ");
            }
            builder.append("augmentation=");
            builder.append(this.augmentation.values());
            return builder.append(']').toString();
        }
    }
}

