/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.control.plane.rev150314.mapreplynotification;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.control.plane.rev150314.EidToLocatorRecords;
import org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.control.plane.rev150314.eidtolocatorrecords.EidToLocatorRecord;
import org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.control.plane.rev150314.mapreplynotification.MapReply;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class MapReplyBuilder
implements Builder<MapReply> {
    private List<EidToLocatorRecord> _eidToLocatorRecord;
    private Long _nonce;
    private Boolean _echoNonceEnabled;
    private Boolean _probe;
    private Boolean _securityEnabled;
    Map<Class<? extends Augmentation<MapReply>>, Augmentation<MapReply>> augmentation = Collections.emptyMap();

    public MapReplyBuilder() {
    }

    public MapReplyBuilder(org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.control.plane.rev150314.MapReply arg) {
        this._probe = arg.isProbe();
        this._nonce = arg.getNonce();
        this._echoNonceEnabled = arg.isEchoNonceEnabled();
        this._securityEnabled = arg.isSecurityEnabled();
        this._eidToLocatorRecord = arg.getEidToLocatorRecord();
    }

    public MapReplyBuilder(EidToLocatorRecords arg) {
        this._eidToLocatorRecord = arg.getEidToLocatorRecord();
    }

    public MapReplyBuilder(MapReply base) {
        AugmentationHolder casted;
        this._eidToLocatorRecord = base.getEidToLocatorRecord();
        this._nonce = base.getNonce();
        this._echoNonceEnabled = base.isEchoNonceEnabled();
        this._probe = base.isProbe();
        this._securityEnabled = base.isSecurityEnabled();
        if (base instanceof MapReplyImpl) {
            MapReplyImpl impl = (MapReplyImpl)base;
            if (!impl.augmentation.isEmpty()) {
                this.augmentation = new HashMap<Class<? extends Augmentation<MapReply>>, Augmentation<MapReply>>(impl.augmentation);
            }
        } else if (base instanceof AugmentationHolder && !(casted = (AugmentationHolder)base).augmentations().isEmpty()) {
            this.augmentation = new HashMap<Class<? extends Augmentation<MapReply>>, Augmentation<MapReply>>(casted.augmentations());
        }
    }

    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.control.plane.rev150314.MapReply) {
            this._probe = ((org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.control.plane.rev150314.MapReply)arg).isProbe();
            this._nonce = ((org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.control.plane.rev150314.MapReply)arg).getNonce();
            this._echoNonceEnabled = ((org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.control.plane.rev150314.MapReply)arg).isEchoNonceEnabled();
            this._securityEnabled = ((org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.control.plane.rev150314.MapReply)arg).isSecurityEnabled();
            isValidArg = true;
        }
        if (arg instanceof EidToLocatorRecords) {
            this._eidToLocatorRecord = ((EidToLocatorRecords)arg).getEidToLocatorRecord();
            isValidArg = true;
        }
        if (!isValidArg) {
            throw new IllegalArgumentException("expected one of: [org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.control.plane.rev150314.MapReply, org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.control.plane.rev150314.EidToLocatorRecords] \nbut was: " + arg);
        }
    }

    public List<EidToLocatorRecord> getEidToLocatorRecord() {
        return this._eidToLocatorRecord;
    }

    public Long getNonce() {
        return this._nonce;
    }

    public Boolean isEchoNonceEnabled() {
        return this._echoNonceEnabled;
    }

    public Boolean isProbe() {
        return this._probe;
    }

    public Boolean isSecurityEnabled() {
        return this._securityEnabled;
    }

    public <E extends Augmentation<MapReply>> E getAugmentation(Class<E> augmentationType) {
        if (augmentationType == null) {
            throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
        }
        return (E)this.augmentation.get(augmentationType);
    }

    public MapReplyBuilder setEidToLocatorRecord(List<EidToLocatorRecord> value) {
        this._eidToLocatorRecord = value;
        return this;
    }

    public MapReplyBuilder setNonce(Long value) {
        this._nonce = value;
        return this;
    }

    public MapReplyBuilder setEchoNonceEnabled(Boolean value) {
        this._echoNonceEnabled = value;
        return this;
    }

    public MapReplyBuilder setProbe(Boolean value) {
        this._probe = value;
        return this;
    }

    public MapReplyBuilder setSecurityEnabled(Boolean value) {
        this._securityEnabled = value;
        return this;
    }

    public MapReplyBuilder addAugmentation(Class<? extends Augmentation<MapReply>> augmentationType, Augmentation<MapReply> augmentation) {
        if (augmentation == null) {
            return this.removeAugmentation(augmentationType);
        }
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<MapReply>>, Augmentation<MapReply>>();
        }
        this.augmentation.put(augmentationType, augmentation);
        return this;
    }

    public MapReplyBuilder removeAugmentation(Class<? extends Augmentation<MapReply>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    public MapReply build() {
        return new MapReplyImpl(this);
    }

    private static final class MapReplyImpl
    implements MapReply {
        private final List<EidToLocatorRecord> _eidToLocatorRecord;
        private final Long _nonce;
        private final Boolean _echoNonceEnabled;
        private final Boolean _probe;
        private final Boolean _securityEnabled;
        private Map<Class<? extends Augmentation<MapReply>>, Augmentation<MapReply>> augmentation = Collections.emptyMap();
        private int hash = 0;
        private volatile boolean hashValid = false;

        public Class<MapReply> getImplementedInterface() {
            return MapReply.class;
        }

        private MapReplyImpl(MapReplyBuilder base) {
            this._eidToLocatorRecord = base.getEidToLocatorRecord();
            this._nonce = base.getNonce();
            this._echoNonceEnabled = base.isEchoNonceEnabled();
            this._probe = base.isProbe();
            this._securityEnabled = base.isSecurityEnabled();
            switch (base.augmentation.size()) {
                case 0: {
                    this.augmentation = Collections.emptyMap();
                    break;
                }
                case 1: {
                    Map.Entry<Class<? extends Augmentation<MapReply>>, Augmentation<MapReply>> e = base.augmentation.entrySet().iterator().next();
                    this.augmentation = Collections.singletonMap(e.getKey(), e.getValue());
                    break;
                }
                default: {
                    this.augmentation = new HashMap<Class<? extends Augmentation<MapReply>>, Augmentation<MapReply>>(base.augmentation);
                }
            }
        }

        @Override
        public List<EidToLocatorRecord> getEidToLocatorRecord() {
            return this._eidToLocatorRecord;
        }

        @Override
        public Long getNonce() {
            return this._nonce;
        }

        @Override
        public Boolean isEchoNonceEnabled() {
            return this._echoNonceEnabled;
        }

        @Override
        public Boolean isProbe() {
            return this._probe;
        }

        @Override
        public Boolean isSecurityEnabled() {
            return this._securityEnabled;
        }

        public <E extends Augmentation<MapReply>> E getAugmentation(Class<E> augmentationType) {
            if (augmentationType == null) {
                throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
            }
            return (E)this.augmentation.get(augmentationType);
        }

        public int hashCode() {
            if (this.hashValid) {
                return this.hash;
            }
            int prime = 31;
            int result = 1;
            result = 31 * result + (this._eidToLocatorRecord == null ? 0 : this._eidToLocatorRecord.hashCode());
            result = 31 * result + (this._nonce == null ? 0 : this._nonce.hashCode());
            result = 31 * result + (this._echoNonceEnabled == null ? 0 : this._echoNonceEnabled.hashCode());
            result = 31 * result + (this._probe == null ? 0 : this._probe.hashCode());
            result = 31 * result + (this._securityEnabled == null ? 0 : this._securityEnabled.hashCode());
            this.hash = result = 31 * result + (this.augmentation == null ? 0 : this.augmentation.hashCode());
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!MapReply.class.equals((Object)((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            MapReply other = (MapReply)obj;
            if (this._eidToLocatorRecord == null ? other.getEidToLocatorRecord() != null : !this._eidToLocatorRecord.equals(other.getEidToLocatorRecord())) {
                return false;
            }
            if (this._nonce == null ? other.getNonce() != null : !this._nonce.equals(other.getNonce())) {
                return false;
            }
            if (this._echoNonceEnabled == null ? other.isEchoNonceEnabled() != null : !this._echoNonceEnabled.equals(other.isEchoNonceEnabled())) {
                return false;
            }
            if (this._probe == null ? other.isProbe() != null : !this._probe.equals(other.isProbe())) {
                return false;
            }
            if (this._securityEnabled == null ? other.isSecurityEnabled() != null : !this._securityEnabled.equals(other.isSecurityEnabled())) {
                return false;
            }
            if (this.getClass() == obj.getClass()) {
                MapReplyImpl otherImpl = (MapReplyImpl)obj;
                if (this.augmentation == null ? otherImpl.augmentation != null : !this.augmentation.equals(otherImpl.augmentation)) {
                    return false;
                }
            } else {
                for (Map.Entry<Class<? extends Augmentation<MapReply>>, Augmentation<MapReply>> e : this.augmentation.entrySet()) {
                    if (e.getValue().equals((Object)other.getAugmentation(e.getKey()))) continue;
                    return false;
                }
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }

        public String toString() {
            StringBuilder builder = new StringBuilder("MapReply [");
            boolean first = true;
            if (this._eidToLocatorRecord != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_eidToLocatorRecord=");
                builder.append(this._eidToLocatorRecord);
            }
            if (this._nonce != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_nonce=");
                builder.append(this._nonce);
            }
            if (this._echoNonceEnabled != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_echoNonceEnabled=");
                builder.append(this._echoNonceEnabled);
            }
            if (this._probe != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_probe=");
                builder.append(this._probe);
            }
            if (this._securityEnabled != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_securityEnabled=");
                builder.append(this._securityEnabled);
            }
            if (first) {
                first = false;
            } else {
                builder.append(", ");
            }
            builder.append("augmentation=");
            builder.append(this.augmentation.values());
            return builder.append(']').toString();
        }
    }
}

