/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.control.plane.rev150314.transportaddress;

import com.google.common.collect.Range;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.inet.types.rev100924.IpAddress;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.inet.types.rev100924.PortNumber;
import org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.control.plane.rev150314.transportaddress.TransportAddress;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class TransportAddressBuilder
implements Builder<TransportAddress> {
    private IpAddress _ipAddress;
    private PortNumber _port;
    Map<Class<? extends Augmentation<TransportAddress>>, Augmentation<TransportAddress>> augmentation = Collections.emptyMap();

    public TransportAddressBuilder() {
    }

    public TransportAddressBuilder(TransportAddress base) {
        AugmentationHolder casted;
        this._ipAddress = base.getIpAddress();
        this._port = base.getPort();
        if (base instanceof TransportAddressImpl) {
            TransportAddressImpl impl = (TransportAddressImpl)base;
            if (!impl.augmentation.isEmpty()) {
                this.augmentation = new HashMap<Class<? extends Augmentation<TransportAddress>>, Augmentation<TransportAddress>>(impl.augmentation);
            }
        } else if (base instanceof AugmentationHolder && !(casted = (AugmentationHolder)base).augmentations().isEmpty()) {
            this.augmentation = new HashMap<Class<? extends Augmentation<TransportAddress>>, Augmentation<TransportAddress>>(casted.augmentations());
        }
    }

    public IpAddress getIpAddress() {
        return this._ipAddress;
    }

    public PortNumber getPort() {
        return this._port;
    }

    public <E extends Augmentation<TransportAddress>> E getAugmentation(Class<E> augmentationType) {
        if (augmentationType == null) {
            throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
        }
        return (E)this.augmentation.get(augmentationType);
    }

    public TransportAddressBuilder setIpAddress(IpAddress value) {
        if (value != null) {
            // empty if block
        }
        this._ipAddress = value;
        return this;
    }

    private static void checkPortRange(int value) {
        if (value >= 0 && value <= 65535) {
            return;
        }
        throw new IllegalArgumentException(String.format("Invalid range: %s, expected: [[0\u202565535]].", value));
    }

    public TransportAddressBuilder setPort(PortNumber value) {
        if (value != null) {
            TransportAddressBuilder.checkPortRange(value.getValue());
        }
        this._port = value;
        return this;
    }

    @Deprecated
    public static List<Range<BigInteger>> _port_range() {
        ArrayList<Range<BigInteger>> ret = new ArrayList<Range<BigInteger>>(1);
        ret.add(Range.closed((Comparable)BigInteger.ZERO, (Comparable)BigInteger.valueOf(65535L)));
        return ret;
    }

    public TransportAddressBuilder addAugmentation(Class<? extends Augmentation<TransportAddress>> augmentationType, Augmentation<TransportAddress> augmentation) {
        if (augmentation == null) {
            return this.removeAugmentation(augmentationType);
        }
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<TransportAddress>>, Augmentation<TransportAddress>>();
        }
        this.augmentation.put(augmentationType, augmentation);
        return this;
    }

    public TransportAddressBuilder removeAugmentation(Class<? extends Augmentation<TransportAddress>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    public TransportAddress build() {
        return new TransportAddressImpl(this);
    }

    private static final class TransportAddressImpl
    implements TransportAddress {
        private final IpAddress _ipAddress;
        private final PortNumber _port;
        private Map<Class<? extends Augmentation<TransportAddress>>, Augmentation<TransportAddress>> augmentation = Collections.emptyMap();
        private int hash = 0;
        private volatile boolean hashValid = false;

        public Class<TransportAddress> getImplementedInterface() {
            return TransportAddress.class;
        }

        private TransportAddressImpl(TransportAddressBuilder base) {
            this._ipAddress = base.getIpAddress();
            this._port = base.getPort();
            switch (base.augmentation.size()) {
                case 0: {
                    this.augmentation = Collections.emptyMap();
                    break;
                }
                case 1: {
                    Map.Entry<Class<? extends Augmentation<TransportAddress>>, Augmentation<TransportAddress>> e = base.augmentation.entrySet().iterator().next();
                    this.augmentation = Collections.singletonMap(e.getKey(), e.getValue());
                    break;
                }
                default: {
                    this.augmentation = new HashMap<Class<? extends Augmentation<TransportAddress>>, Augmentation<TransportAddress>>(base.augmentation);
                }
            }
        }

        @Override
        public IpAddress getIpAddress() {
            return this._ipAddress;
        }

        @Override
        public PortNumber getPort() {
            return this._port;
        }

        public <E extends Augmentation<TransportAddress>> E getAugmentation(Class<E> augmentationType) {
            if (augmentationType == null) {
                throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
            }
            return (E)this.augmentation.get(augmentationType);
        }

        public int hashCode() {
            if (this.hashValid) {
                return this.hash;
            }
            int prime = 31;
            int result = 1;
            result = 31 * result + (this._ipAddress == null ? 0 : this._ipAddress.hashCode());
            result = 31 * result + (this._port == null ? 0 : this._port.hashCode());
            this.hash = result = 31 * result + (this.augmentation == null ? 0 : this.augmentation.hashCode());
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!TransportAddress.class.equals((Object)((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            TransportAddress other = (TransportAddress)obj;
            if (this._ipAddress == null ? other.getIpAddress() != null : !this._ipAddress.equals((Object)other.getIpAddress())) {
                return false;
            }
            if (this._port == null ? other.getPort() != null : !this._port.equals((Object)other.getPort())) {
                return false;
            }
            if (this.getClass() == obj.getClass()) {
                TransportAddressImpl otherImpl = (TransportAddressImpl)obj;
                if (this.augmentation == null ? otherImpl.augmentation != null : !this.augmentation.equals(otherImpl.augmentation)) {
                    return false;
                }
            } else {
                for (Map.Entry<Class<? extends Augmentation<TransportAddress>>, Augmentation<TransportAddress>> e : this.augmentation.entrySet()) {
                    if (e.getValue().equals((Object)other.getAugmentation(e.getKey()))) continue;
                    return false;
                }
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }

        public String toString() {
            StringBuilder builder = new StringBuilder("TransportAddress [");
            boolean first = true;
            if (this._ipAddress != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_ipAddress=");
                builder.append(this._ipAddress);
            }
            if (this._port != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_port=");
                builder.append(this._port);
            }
            if (first) {
                first = false;
            } else {
                builder.append(", ");
            }
            builder.append("augmentation=");
            builder.append(this.augmentation.values());
            return builder.append(']').toString();
        }
    }
}

