/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.mapping.database.rev150314;

import com.google.common.collect.Range;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.control.plane.rev150314.LispAddress;
import org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.control.plane.rev150314.lispaddress.LispAddressContainer;
import org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.mapping.database.rev150314.AddKeyInput;
import org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.mapping.database.rev150314.LispPrefix;
import org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.mapping.database.rev150314.MappingAuthkey;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class AddKeyInputBuilder
implements Builder<AddKeyInput> {
    private String _authkey;
    private Integer _keyType;
    private LispAddressContainer _lispAddressContainer;
    private Short _maskLength;
    Map<Class<? extends Augmentation<AddKeyInput>>, Augmentation<AddKeyInput>> augmentation = Collections.emptyMap();

    public AddKeyInputBuilder() {
    }

    public AddKeyInputBuilder(MappingAuthkey arg) {
        this._keyType = arg.getKeyType();
        this._authkey = arg.getAuthkey();
    }

    public AddKeyInputBuilder(LispPrefix arg) {
        this._maskLength = arg.getMaskLength();
        this._lispAddressContainer = arg.getLispAddressContainer();
    }

    public AddKeyInputBuilder(LispAddress arg) {
        this._lispAddressContainer = arg.getLispAddressContainer();
    }

    public AddKeyInputBuilder(AddKeyInput base) {
        AugmentationHolder casted;
        this._authkey = base.getAuthkey();
        this._keyType = base.getKeyType();
        this._lispAddressContainer = base.getLispAddressContainer();
        this._maskLength = base.getMaskLength();
        if (base instanceof AddKeyInputImpl) {
            AddKeyInputImpl impl = (AddKeyInputImpl)base;
            if (!impl.augmentation.isEmpty()) {
                this.augmentation = new HashMap<Class<? extends Augmentation<AddKeyInput>>, Augmentation<AddKeyInput>>(impl.augmentation);
            }
        } else if (base instanceof AugmentationHolder && !(casted = (AugmentationHolder)base).augmentations().isEmpty()) {
            this.augmentation = new HashMap<Class<? extends Augmentation<AddKeyInput>>, Augmentation<AddKeyInput>>(casted.augmentations());
        }
    }

    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof MappingAuthkey) {
            this._keyType = ((MappingAuthkey)arg).getKeyType();
            this._authkey = ((MappingAuthkey)arg).getAuthkey();
            isValidArg = true;
        }
        if (arg instanceof LispPrefix) {
            this._maskLength = ((LispPrefix)arg).getMaskLength();
            isValidArg = true;
        }
        if (arg instanceof LispAddress) {
            this._lispAddressContainer = ((LispAddress)arg).getLispAddressContainer();
            isValidArg = true;
        }
        if (!isValidArg) {
            throw new IllegalArgumentException("expected one of: [org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.mapping.database.rev150314.MappingAuthkey, org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.mapping.database.rev150314.LispPrefix, org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.control.plane.rev150314.LispAddress] \nbut was: " + arg);
        }
    }

    public String getAuthkey() {
        return this._authkey;
    }

    public Integer getKeyType() {
        return this._keyType;
    }

    public LispAddressContainer getLispAddressContainer() {
        return this._lispAddressContainer;
    }

    public Short getMaskLength() {
        return this._maskLength;
    }

    public <E extends Augmentation<AddKeyInput>> E getAugmentation(Class<E> augmentationType) {
        if (augmentationType == null) {
            throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
        }
        return (E)this.augmentation.get(augmentationType);
    }

    public AddKeyInputBuilder setAuthkey(String value) {
        this._authkey = value;
        return this;
    }

    private static void checkKeyTypeRange(int value) {
        if (value >= 0 && value <= 65535) {
            return;
        }
        throw new IllegalArgumentException(String.format("Invalid range: %s, expected: [[0\u202565535]].", value));
    }

    public AddKeyInputBuilder setKeyType(Integer value) {
        if (value != null) {
            AddKeyInputBuilder.checkKeyTypeRange(value);
        }
        this._keyType = value;
        return this;
    }

    @Deprecated
    public static List<Range<BigInteger>> _keyType_range() {
        ArrayList<Range<BigInteger>> ret = new ArrayList<Range<BigInteger>>(1);
        ret.add(Range.closed((Comparable)BigInteger.ZERO, (Comparable)BigInteger.valueOf(65535L)));
        return ret;
    }

    public AddKeyInputBuilder setLispAddressContainer(LispAddressContainer value) {
        this._lispAddressContainer = value;
        return this;
    }

    private static void checkMaskLengthRange(short value) {
        if (value >= 0 && value <= 255) {
            return;
        }
        throw new IllegalArgumentException(String.format("Invalid range: %s, expected: [[0\u2025255]].", value));
    }

    public AddKeyInputBuilder setMaskLength(Short value) {
        if (value != null) {
            AddKeyInputBuilder.checkMaskLengthRange(value);
        }
        this._maskLength = value;
        return this;
    }

    @Deprecated
    public static List<Range<BigInteger>> _maskLength_range() {
        ArrayList<Range<BigInteger>> ret = new ArrayList<Range<BigInteger>>(1);
        ret.add(Range.closed((Comparable)BigInteger.ZERO, (Comparable)BigInteger.valueOf(255L)));
        return ret;
    }

    public AddKeyInputBuilder addAugmentation(Class<? extends Augmentation<AddKeyInput>> augmentationType, Augmentation<AddKeyInput> augmentation) {
        if (augmentation == null) {
            return this.removeAugmentation(augmentationType);
        }
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<AddKeyInput>>, Augmentation<AddKeyInput>>();
        }
        this.augmentation.put(augmentationType, augmentation);
        return this;
    }

    public AddKeyInputBuilder removeAugmentation(Class<? extends Augmentation<AddKeyInput>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    public AddKeyInput build() {
        return new AddKeyInputImpl(this);
    }

    private static final class AddKeyInputImpl
    implements AddKeyInput {
        private final String _authkey;
        private final Integer _keyType;
        private final LispAddressContainer _lispAddressContainer;
        private final Short _maskLength;
        private Map<Class<? extends Augmentation<AddKeyInput>>, Augmentation<AddKeyInput>> augmentation = Collections.emptyMap();
        private int hash = 0;
        private volatile boolean hashValid = false;

        public Class<AddKeyInput> getImplementedInterface() {
            return AddKeyInput.class;
        }

        private AddKeyInputImpl(AddKeyInputBuilder base) {
            this._authkey = base.getAuthkey();
            this._keyType = base.getKeyType();
            this._lispAddressContainer = base.getLispAddressContainer();
            this._maskLength = base.getMaskLength();
            switch (base.augmentation.size()) {
                case 0: {
                    this.augmentation = Collections.emptyMap();
                    break;
                }
                case 1: {
                    Map.Entry<Class<? extends Augmentation<AddKeyInput>>, Augmentation<AddKeyInput>> e = base.augmentation.entrySet().iterator().next();
                    this.augmentation = Collections.singletonMap(e.getKey(), e.getValue());
                    break;
                }
                default: {
                    this.augmentation = new HashMap<Class<? extends Augmentation<AddKeyInput>>, Augmentation<AddKeyInput>>(base.augmentation);
                }
            }
        }

        @Override
        public String getAuthkey() {
            return this._authkey;
        }

        @Override
        public Integer getKeyType() {
            return this._keyType;
        }

        @Override
        public LispAddressContainer getLispAddressContainer() {
            return this._lispAddressContainer;
        }

        @Override
        public Short getMaskLength() {
            return this._maskLength;
        }

        public <E extends Augmentation<AddKeyInput>> E getAugmentation(Class<E> augmentationType) {
            if (augmentationType == null) {
                throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
            }
            return (E)this.augmentation.get(augmentationType);
        }

        public int hashCode() {
            if (this.hashValid) {
                return this.hash;
            }
            int prime = 31;
            int result = 1;
            result = 31 * result + (this._authkey == null ? 0 : this._authkey.hashCode());
            result = 31 * result + (this._keyType == null ? 0 : this._keyType.hashCode());
            result = 31 * result + (this._lispAddressContainer == null ? 0 : this._lispAddressContainer.hashCode());
            result = 31 * result + (this._maskLength == null ? 0 : this._maskLength.hashCode());
            this.hash = result = 31 * result + (this.augmentation == null ? 0 : this.augmentation.hashCode());
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!AddKeyInput.class.equals((Object)((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            AddKeyInput other = (AddKeyInput)obj;
            if (this._authkey == null ? other.getAuthkey() != null : !this._authkey.equals(other.getAuthkey())) {
                return false;
            }
            if (this._keyType == null ? other.getKeyType() != null : !this._keyType.equals(other.getKeyType())) {
                return false;
            }
            if (this._lispAddressContainer == null ? other.getLispAddressContainer() != null : !this._lispAddressContainer.equals(other.getLispAddressContainer())) {
                return false;
            }
            if (this._maskLength == null ? other.getMaskLength() != null : !this._maskLength.equals(other.getMaskLength())) {
                return false;
            }
            if (this.getClass() == obj.getClass()) {
                AddKeyInputImpl otherImpl = (AddKeyInputImpl)obj;
                if (this.augmentation == null ? otherImpl.augmentation != null : !this.augmentation.equals(otherImpl.augmentation)) {
                    return false;
                }
            } else {
                for (Map.Entry<Class<? extends Augmentation<AddKeyInput>>, Augmentation<AddKeyInput>> e : this.augmentation.entrySet()) {
                    if (e.getValue().equals((Object)other.getAugmentation(e.getKey()))) continue;
                    return false;
                }
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }

        public String toString() {
            StringBuilder builder = new StringBuilder("AddKeyInput [");
            boolean first = true;
            if (this._authkey != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_authkey=");
                builder.append(this._authkey);
            }
            if (this._keyType != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_keyType=");
                builder.append(this._keyType);
            }
            if (this._lispAddressContainer != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_lispAddressContainer=");
                builder.append(this._lispAddressContainer);
            }
            if (this._maskLength != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_maskLength=");
                builder.append(this._maskLength);
            }
            if (first) {
                first = false;
            } else {
                builder.append(", ");
            }
            builder.append("augmentation=");
            builder.append(this.augmentation.values());
            return builder.append(']').toString();
        }
    }
}

