/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.mapping.database.rev150314;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.mapping.database.rev150314.MappingDatabase;
import org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.mapping.database.rev150314.mapping.database.InstanceId;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class MappingDatabaseBuilder
implements Builder<MappingDatabase> {
    private List<InstanceId> _instanceId;
    Map<Class<? extends Augmentation<MappingDatabase>>, Augmentation<MappingDatabase>> augmentation = Collections.emptyMap();

    public MappingDatabaseBuilder() {
    }

    public MappingDatabaseBuilder(MappingDatabase base) {
        AugmentationHolder casted;
        this._instanceId = base.getInstanceId();
        if (base instanceof MappingDatabaseImpl) {
            MappingDatabaseImpl impl = (MappingDatabaseImpl)base;
            if (!impl.augmentation.isEmpty()) {
                this.augmentation = new HashMap<Class<? extends Augmentation<MappingDatabase>>, Augmentation<MappingDatabase>>(impl.augmentation);
            }
        } else if (base instanceof AugmentationHolder && !(casted = (AugmentationHolder)base).augmentations().isEmpty()) {
            this.augmentation = new HashMap<Class<? extends Augmentation<MappingDatabase>>, Augmentation<MappingDatabase>>(casted.augmentations());
        }
    }

    public List<InstanceId> getInstanceId() {
        return this._instanceId;
    }

    public <E extends Augmentation<MappingDatabase>> E getAugmentation(Class<E> augmentationType) {
        if (augmentationType == null) {
            throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
        }
        return (E)this.augmentation.get(augmentationType);
    }

    public MappingDatabaseBuilder setInstanceId(List<InstanceId> value) {
        this._instanceId = value;
        return this;
    }

    public MappingDatabaseBuilder addAugmentation(Class<? extends Augmentation<MappingDatabase>> augmentationType, Augmentation<MappingDatabase> augmentation) {
        if (augmentation == null) {
            return this.removeAugmentation(augmentationType);
        }
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<MappingDatabase>>, Augmentation<MappingDatabase>>();
        }
        this.augmentation.put(augmentationType, augmentation);
        return this;
    }

    public MappingDatabaseBuilder removeAugmentation(Class<? extends Augmentation<MappingDatabase>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    public MappingDatabase build() {
        return new MappingDatabaseImpl(this);
    }

    private static final class MappingDatabaseImpl
    implements MappingDatabase {
        private final List<InstanceId> _instanceId;
        private Map<Class<? extends Augmentation<MappingDatabase>>, Augmentation<MappingDatabase>> augmentation = Collections.emptyMap();
        private int hash = 0;
        private volatile boolean hashValid = false;

        public Class<MappingDatabase> getImplementedInterface() {
            return MappingDatabase.class;
        }

        private MappingDatabaseImpl(MappingDatabaseBuilder base) {
            this._instanceId = base.getInstanceId();
            switch (base.augmentation.size()) {
                case 0: {
                    this.augmentation = Collections.emptyMap();
                    break;
                }
                case 1: {
                    Map.Entry<Class<? extends Augmentation<MappingDatabase>>, Augmentation<MappingDatabase>> e = base.augmentation.entrySet().iterator().next();
                    this.augmentation = Collections.singletonMap(e.getKey(), e.getValue());
                    break;
                }
                default: {
                    this.augmentation = new HashMap<Class<? extends Augmentation<MappingDatabase>>, Augmentation<MappingDatabase>>(base.augmentation);
                }
            }
        }

        @Override
        public List<InstanceId> getInstanceId() {
            return this._instanceId;
        }

        public <E extends Augmentation<MappingDatabase>> E getAugmentation(Class<E> augmentationType) {
            if (augmentationType == null) {
                throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
            }
            return (E)this.augmentation.get(augmentationType);
        }

        public int hashCode() {
            if (this.hashValid) {
                return this.hash;
            }
            int prime = 31;
            int result = 1;
            result = 31 * result + (this._instanceId == null ? 0 : this._instanceId.hashCode());
            this.hash = result = 31 * result + (this.augmentation == null ? 0 : this.augmentation.hashCode());
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!MappingDatabase.class.equals((Object)((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            MappingDatabase other = (MappingDatabase)obj;
            if (this._instanceId == null ? other.getInstanceId() != null : !this._instanceId.equals(other.getInstanceId())) {
                return false;
            }
            if (this.getClass() == obj.getClass()) {
                MappingDatabaseImpl otherImpl = (MappingDatabaseImpl)obj;
                if (this.augmentation == null ? otherImpl.augmentation != null : !this.augmentation.equals(otherImpl.augmentation)) {
                    return false;
                }
            } else {
                for (Map.Entry<Class<? extends Augmentation<MappingDatabase>>, Augmentation<MappingDatabase>> e : this.augmentation.entrySet()) {
                    if (e.getValue().equals((Object)other.getAugmentation(e.getKey()))) continue;
                    return false;
                }
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }

        public String toString() {
            StringBuilder builder = new StringBuilder("MappingDatabase [");
            boolean first = true;
            if (this._instanceId != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_instanceId=");
                builder.append(this._instanceId);
            }
            if (first) {
                first = false;
            } else {
                builder.append(", ");
            }
            builder.append("augmentation=");
            builder.append(this.augmentation.values());
            return builder.append(']').toString();
        }
    }
}

