/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.mapping.database.rev150314;

import com.google.common.collect.Range;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.control.plane.rev150314.LispAddress;
import org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.control.plane.rev150314.lispaddress.LispAddressContainer;
import org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.mapping.database.rev150314.LispPrefix;
import org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.mapping.database.rev150314.RemoveKeyInput;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class RemoveKeyInputBuilder
implements Builder<RemoveKeyInput> {
    private LispAddressContainer _lispAddressContainer;
    private Short _maskLength;
    Map<Class<? extends Augmentation<RemoveKeyInput>>, Augmentation<RemoveKeyInput>> augmentation = Collections.emptyMap();

    public RemoveKeyInputBuilder() {
    }

    public RemoveKeyInputBuilder(LispPrefix arg) {
        this._maskLength = arg.getMaskLength();
        this._lispAddressContainer = arg.getLispAddressContainer();
    }

    public RemoveKeyInputBuilder(LispAddress arg) {
        this._lispAddressContainer = arg.getLispAddressContainer();
    }

    public RemoveKeyInputBuilder(RemoveKeyInput base) {
        AugmentationHolder casted;
        this._lispAddressContainer = base.getLispAddressContainer();
        this._maskLength = base.getMaskLength();
        if (base instanceof RemoveKeyInputImpl) {
            RemoveKeyInputImpl impl = (RemoveKeyInputImpl)base;
            if (!impl.augmentation.isEmpty()) {
                this.augmentation = new HashMap<Class<? extends Augmentation<RemoveKeyInput>>, Augmentation<RemoveKeyInput>>(impl.augmentation);
            }
        } else if (base instanceof AugmentationHolder && !(casted = (AugmentationHolder)base).augmentations().isEmpty()) {
            this.augmentation = new HashMap<Class<? extends Augmentation<RemoveKeyInput>>, Augmentation<RemoveKeyInput>>(casted.augmentations());
        }
    }

    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof LispPrefix) {
            this._maskLength = ((LispPrefix)arg).getMaskLength();
            isValidArg = true;
        }
        if (arg instanceof LispAddress) {
            this._lispAddressContainer = ((LispAddress)arg).getLispAddressContainer();
            isValidArg = true;
        }
        if (!isValidArg) {
            throw new IllegalArgumentException("expected one of: [org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.mapping.database.rev150314.LispPrefix, org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.control.plane.rev150314.LispAddress] \nbut was: " + arg);
        }
    }

    public LispAddressContainer getLispAddressContainer() {
        return this._lispAddressContainer;
    }

    public Short getMaskLength() {
        return this._maskLength;
    }

    public <E extends Augmentation<RemoveKeyInput>> E getAugmentation(Class<E> augmentationType) {
        if (augmentationType == null) {
            throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
        }
        return (E)this.augmentation.get(augmentationType);
    }

    public RemoveKeyInputBuilder setLispAddressContainer(LispAddressContainer value) {
        this._lispAddressContainer = value;
        return this;
    }

    private static void checkMaskLengthRange(short value) {
        if (value >= 0 && value <= 255) {
            return;
        }
        throw new IllegalArgumentException(String.format("Invalid range: %s, expected: [[0\u2025255]].", value));
    }

    public RemoveKeyInputBuilder setMaskLength(Short value) {
        if (value != null) {
            RemoveKeyInputBuilder.checkMaskLengthRange(value);
        }
        this._maskLength = value;
        return this;
    }

    @Deprecated
    public static List<Range<BigInteger>> _maskLength_range() {
        ArrayList<Range<BigInteger>> ret = new ArrayList<Range<BigInteger>>(1);
        ret.add(Range.closed((Comparable)BigInteger.ZERO, (Comparable)BigInteger.valueOf(255L)));
        return ret;
    }

    public RemoveKeyInputBuilder addAugmentation(Class<? extends Augmentation<RemoveKeyInput>> augmentationType, Augmentation<RemoveKeyInput> augmentation) {
        if (augmentation == null) {
            return this.removeAugmentation(augmentationType);
        }
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<RemoveKeyInput>>, Augmentation<RemoveKeyInput>>();
        }
        this.augmentation.put(augmentationType, augmentation);
        return this;
    }

    public RemoveKeyInputBuilder removeAugmentation(Class<? extends Augmentation<RemoveKeyInput>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    public RemoveKeyInput build() {
        return new RemoveKeyInputImpl(this);
    }

    private static final class RemoveKeyInputImpl
    implements RemoveKeyInput {
        private final LispAddressContainer _lispAddressContainer;
        private final Short _maskLength;
        private Map<Class<? extends Augmentation<RemoveKeyInput>>, Augmentation<RemoveKeyInput>> augmentation = Collections.emptyMap();
        private int hash = 0;
        private volatile boolean hashValid = false;

        public Class<RemoveKeyInput> getImplementedInterface() {
            return RemoveKeyInput.class;
        }

        private RemoveKeyInputImpl(RemoveKeyInputBuilder base) {
            this._lispAddressContainer = base.getLispAddressContainer();
            this._maskLength = base.getMaskLength();
            switch (base.augmentation.size()) {
                case 0: {
                    this.augmentation = Collections.emptyMap();
                    break;
                }
                case 1: {
                    Map.Entry<Class<? extends Augmentation<RemoveKeyInput>>, Augmentation<RemoveKeyInput>> e = base.augmentation.entrySet().iterator().next();
                    this.augmentation = Collections.singletonMap(e.getKey(), e.getValue());
                    break;
                }
                default: {
                    this.augmentation = new HashMap<Class<? extends Augmentation<RemoveKeyInput>>, Augmentation<RemoveKeyInput>>(base.augmentation);
                }
            }
        }

        @Override
        public LispAddressContainer getLispAddressContainer() {
            return this._lispAddressContainer;
        }

        @Override
        public Short getMaskLength() {
            return this._maskLength;
        }

        public <E extends Augmentation<RemoveKeyInput>> E getAugmentation(Class<E> augmentationType) {
            if (augmentationType == null) {
                throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
            }
            return (E)this.augmentation.get(augmentationType);
        }

        public int hashCode() {
            if (this.hashValid) {
                return this.hash;
            }
            int prime = 31;
            int result = 1;
            result = 31 * result + (this._lispAddressContainer == null ? 0 : this._lispAddressContainer.hashCode());
            result = 31 * result + (this._maskLength == null ? 0 : this._maskLength.hashCode());
            this.hash = result = 31 * result + (this.augmentation == null ? 0 : this.augmentation.hashCode());
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!RemoveKeyInput.class.equals((Object)((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            RemoveKeyInput other = (RemoveKeyInput)obj;
            if (this._lispAddressContainer == null ? other.getLispAddressContainer() != null : !this._lispAddressContainer.equals(other.getLispAddressContainer())) {
                return false;
            }
            if (this._maskLength == null ? other.getMaskLength() != null : !this._maskLength.equals(other.getMaskLength())) {
                return false;
            }
            if (this.getClass() == obj.getClass()) {
                RemoveKeyInputImpl otherImpl = (RemoveKeyInputImpl)obj;
                if (this.augmentation == null ? otherImpl.augmentation != null : !this.augmentation.equals(otherImpl.augmentation)) {
                    return false;
                }
            } else {
                for (Map.Entry<Class<? extends Augmentation<RemoveKeyInput>>, Augmentation<RemoveKeyInput>> e : this.augmentation.entrySet()) {
                    if (e.getValue().equals((Object)other.getAugmentation(e.getKey()))) continue;
                    return false;
                }
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }

        public String toString() {
            StringBuilder builder = new StringBuilder("RemoveKeyInput [");
            boolean first = true;
            if (this._lispAddressContainer != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_lispAddressContainer=");
                builder.append(this._lispAddressContainer);
            }
            if (this._maskLength != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_maskLength=");
                builder.append(this._maskLength);
            }
            if (first) {
                first = false;
            } else {
                builder.append(", ");
            }
            builder.append("augmentation=");
            builder.append(this.augmentation.values());
            return builder.append(']').toString();
        }
    }
}

