/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.mapping.database.rev150314.db.instance;

import com.google.common.collect.Range;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.control.plane.rev150314.LispAddress;
import org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.control.plane.rev150314.lispaddress.LispAddressContainer;
import org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.mapping.database.rev150314.EidUri;
import org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.mapping.database.rev150314.LispPrefix;
import org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.mapping.database.rev150314.MappingAuthkey;
import org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.mapping.database.rev150314.db.instance.AuthenticationKey;
import org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.mapping.database.rev150314.db.instance.AuthenticationKeyKey;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class AuthenticationKeyBuilder
implements Builder<AuthenticationKey> {
    private String _authkey;
    private EidUri _eid;
    private AuthenticationKeyKey _key;
    private Integer _keyType;
    private LispAddressContainer _lispAddressContainer;
    private Short _maskLength;
    Map<Class<? extends Augmentation<AuthenticationKey>>, Augmentation<AuthenticationKey>> augmentation = Collections.emptyMap();

    public AuthenticationKeyBuilder() {
    }

    public AuthenticationKeyBuilder(MappingAuthkey arg) {
        this._keyType = arg.getKeyType();
        this._authkey = arg.getAuthkey();
    }

    public AuthenticationKeyBuilder(LispPrefix arg) {
        this._maskLength = arg.getMaskLength();
        this._lispAddressContainer = arg.getLispAddressContainer();
    }

    public AuthenticationKeyBuilder(LispAddress arg) {
        this._lispAddressContainer = arg.getLispAddressContainer();
    }

    public AuthenticationKeyBuilder(AuthenticationKey base) {
        AugmentationHolder casted;
        if (base.getKey() == null) {
            this._key = new AuthenticationKeyKey(base.getEid());
            this._eid = base.getEid();
        } else {
            this._key = base.getKey();
            this._eid = this._key.getEid();
        }
        this._authkey = base.getAuthkey();
        this._keyType = base.getKeyType();
        this._lispAddressContainer = base.getLispAddressContainer();
        this._maskLength = base.getMaskLength();
        if (base instanceof AuthenticationKeyImpl) {
            AuthenticationKeyImpl impl = (AuthenticationKeyImpl)base;
            if (!impl.augmentation.isEmpty()) {
                this.augmentation = new HashMap<Class<? extends Augmentation<AuthenticationKey>>, Augmentation<AuthenticationKey>>(impl.augmentation);
            }
        } else if (base instanceof AugmentationHolder && !(casted = (AugmentationHolder)base).augmentations().isEmpty()) {
            this.augmentation = new HashMap<Class<? extends Augmentation<AuthenticationKey>>, Augmentation<AuthenticationKey>>(casted.augmentations());
        }
    }

    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof MappingAuthkey) {
            this._keyType = ((MappingAuthkey)arg).getKeyType();
            this._authkey = ((MappingAuthkey)arg).getAuthkey();
            isValidArg = true;
        }
        if (arg instanceof LispPrefix) {
            this._maskLength = ((LispPrefix)arg).getMaskLength();
            isValidArg = true;
        }
        if (arg instanceof LispAddress) {
            this._lispAddressContainer = ((LispAddress)arg).getLispAddressContainer();
            isValidArg = true;
        }
        if (!isValidArg) {
            throw new IllegalArgumentException("expected one of: [org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.mapping.database.rev150314.MappingAuthkey, org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.mapping.database.rev150314.LispPrefix, org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.control.plane.rev150314.LispAddress] \nbut was: " + arg);
        }
    }

    public String getAuthkey() {
        return this._authkey;
    }

    public EidUri getEid() {
        return this._eid;
    }

    public AuthenticationKeyKey getKey() {
        return this._key;
    }

    public Integer getKeyType() {
        return this._keyType;
    }

    public LispAddressContainer getLispAddressContainer() {
        return this._lispAddressContainer;
    }

    public Short getMaskLength() {
        return this._maskLength;
    }

    public <E extends Augmentation<AuthenticationKey>> E getAugmentation(Class<E> augmentationType) {
        if (augmentationType == null) {
            throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
        }
        return (E)this.augmentation.get(augmentationType);
    }

    public AuthenticationKeyBuilder setAuthkey(String value) {
        this._authkey = value;
        return this;
    }

    public AuthenticationKeyBuilder setEid(EidUri value) {
        if (value != null) {
            // empty if block
        }
        this._eid = value;
        return this;
    }

    public AuthenticationKeyBuilder setKey(AuthenticationKeyKey value) {
        this._key = value;
        return this;
    }

    private static void checkKeyTypeRange(int value) {
        if (value >= 0 && value <= 65535) {
            return;
        }
        throw new IllegalArgumentException(String.format("Invalid range: %s, expected: [[0\u202565535]].", value));
    }

    public AuthenticationKeyBuilder setKeyType(Integer value) {
        if (value != null) {
            AuthenticationKeyBuilder.checkKeyTypeRange(value);
        }
        this._keyType = value;
        return this;
    }

    @Deprecated
    public static List<Range<BigInteger>> _keyType_range() {
        ArrayList<Range<BigInteger>> ret = new ArrayList<Range<BigInteger>>(1);
        ret.add(Range.closed((Comparable)BigInteger.ZERO, (Comparable)BigInteger.valueOf(65535L)));
        return ret;
    }

    public AuthenticationKeyBuilder setLispAddressContainer(LispAddressContainer value) {
        this._lispAddressContainer = value;
        return this;
    }

    private static void checkMaskLengthRange(short value) {
        if (value >= 0 && value <= 255) {
            return;
        }
        throw new IllegalArgumentException(String.format("Invalid range: %s, expected: [[0\u2025255]].", value));
    }

    public AuthenticationKeyBuilder setMaskLength(Short value) {
        if (value != null) {
            AuthenticationKeyBuilder.checkMaskLengthRange(value);
        }
        this._maskLength = value;
        return this;
    }

    @Deprecated
    public static List<Range<BigInteger>> _maskLength_range() {
        ArrayList<Range<BigInteger>> ret = new ArrayList<Range<BigInteger>>(1);
        ret.add(Range.closed((Comparable)BigInteger.ZERO, (Comparable)BigInteger.valueOf(255L)));
        return ret;
    }

    public AuthenticationKeyBuilder addAugmentation(Class<? extends Augmentation<AuthenticationKey>> augmentationType, Augmentation<AuthenticationKey> augmentation) {
        if (augmentation == null) {
            return this.removeAugmentation(augmentationType);
        }
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<AuthenticationKey>>, Augmentation<AuthenticationKey>>();
        }
        this.augmentation.put(augmentationType, augmentation);
        return this;
    }

    public AuthenticationKeyBuilder removeAugmentation(Class<? extends Augmentation<AuthenticationKey>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    public AuthenticationKey build() {
        return new AuthenticationKeyImpl(this);
    }

    private static final class AuthenticationKeyImpl
    implements AuthenticationKey {
        private final String _authkey;
        private final EidUri _eid;
        private final AuthenticationKeyKey _key;
        private final Integer _keyType;
        private final LispAddressContainer _lispAddressContainer;
        private final Short _maskLength;
        private Map<Class<? extends Augmentation<AuthenticationKey>>, Augmentation<AuthenticationKey>> augmentation = Collections.emptyMap();
        private int hash = 0;
        private volatile boolean hashValid = false;

        public Class<AuthenticationKey> getImplementedInterface() {
            return AuthenticationKey.class;
        }

        private AuthenticationKeyImpl(AuthenticationKeyBuilder base) {
            if (base.getKey() == null) {
                this._key = new AuthenticationKeyKey(base.getEid());
                this._eid = base.getEid();
            } else {
                this._key = base.getKey();
                this._eid = this._key.getEid();
            }
            this._authkey = base.getAuthkey();
            this._keyType = base.getKeyType();
            this._lispAddressContainer = base.getLispAddressContainer();
            this._maskLength = base.getMaskLength();
            switch (base.augmentation.size()) {
                case 0: {
                    this.augmentation = Collections.emptyMap();
                    break;
                }
                case 1: {
                    Map.Entry<Class<? extends Augmentation<AuthenticationKey>>, Augmentation<AuthenticationKey>> e = base.augmentation.entrySet().iterator().next();
                    this.augmentation = Collections.singletonMap(e.getKey(), e.getValue());
                    break;
                }
                default: {
                    this.augmentation = new HashMap<Class<? extends Augmentation<AuthenticationKey>>, Augmentation<AuthenticationKey>>(base.augmentation);
                }
            }
        }

        @Override
        public String getAuthkey() {
            return this._authkey;
        }

        @Override
        public EidUri getEid() {
            return this._eid;
        }

        @Override
        public AuthenticationKeyKey getKey() {
            return this._key;
        }

        @Override
        public Integer getKeyType() {
            return this._keyType;
        }

        @Override
        public LispAddressContainer getLispAddressContainer() {
            return this._lispAddressContainer;
        }

        @Override
        public Short getMaskLength() {
            return this._maskLength;
        }

        public <E extends Augmentation<AuthenticationKey>> E getAugmentation(Class<E> augmentationType) {
            if (augmentationType == null) {
                throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
            }
            return (E)this.augmentation.get(augmentationType);
        }

        public int hashCode() {
            if (this.hashValid) {
                return this.hash;
            }
            int prime = 31;
            int result = 1;
            result = 31 * result + (this._authkey == null ? 0 : this._authkey.hashCode());
            result = 31 * result + (this._eid == null ? 0 : this._eid.hashCode());
            result = 31 * result + (this._key == null ? 0 : this._key.hashCode());
            result = 31 * result + (this._keyType == null ? 0 : this._keyType.hashCode());
            result = 31 * result + (this._lispAddressContainer == null ? 0 : this._lispAddressContainer.hashCode());
            result = 31 * result + (this._maskLength == null ? 0 : this._maskLength.hashCode());
            this.hash = result = 31 * result + (this.augmentation == null ? 0 : this.augmentation.hashCode());
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!AuthenticationKey.class.equals((Object)((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            AuthenticationKey other = (AuthenticationKey)obj;
            if (this._authkey == null ? other.getAuthkey() != null : !this._authkey.equals(other.getAuthkey())) {
                return false;
            }
            if (this._eid == null ? other.getEid() != null : !this._eid.equals(other.getEid())) {
                return false;
            }
            if (this._key == null ? other.getKey() != null : !this._key.equals(other.getKey())) {
                return false;
            }
            if (this._keyType == null ? other.getKeyType() != null : !this._keyType.equals(other.getKeyType())) {
                return false;
            }
            if (this._lispAddressContainer == null ? other.getLispAddressContainer() != null : !this._lispAddressContainer.equals(other.getLispAddressContainer())) {
                return false;
            }
            if (this._maskLength == null ? other.getMaskLength() != null : !this._maskLength.equals(other.getMaskLength())) {
                return false;
            }
            if (this.getClass() == obj.getClass()) {
                AuthenticationKeyImpl otherImpl = (AuthenticationKeyImpl)obj;
                if (this.augmentation == null ? otherImpl.augmentation != null : !this.augmentation.equals(otherImpl.augmentation)) {
                    return false;
                }
            } else {
                for (Map.Entry<Class<? extends Augmentation<AuthenticationKey>>, Augmentation<AuthenticationKey>> e : this.augmentation.entrySet()) {
                    if (e.getValue().equals((Object)other.getAugmentation(e.getKey()))) continue;
                    return false;
                }
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }

        public String toString() {
            StringBuilder builder = new StringBuilder("AuthenticationKey [");
            boolean first = true;
            if (this._authkey != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_authkey=");
                builder.append(this._authkey);
            }
            if (this._eid != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_eid=");
                builder.append(this._eid);
            }
            if (this._key != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_key=");
                builder.append(this._key);
            }
            if (this._keyType != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_keyType=");
                builder.append(this._keyType);
            }
            if (this._lispAddressContainer != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_lispAddressContainer=");
                builder.append(this._lispAddressContainer);
            }
            if (this._maskLength != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_maskLength=");
                builder.append(this._maskLength);
            }
            if (first) {
                first = false;
            } else {
                builder.append(", ");
            }
            builder.append("augmentation=");
            builder.append(this.augmentation.values());
            return builder.append(']').toString();
        }
    }
}

