/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.mapping.database.rev150314.mapping.database;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.mapping.database.rev150314.DbInstance;
import org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.mapping.database.rev150314.IidUri;
import org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.mapping.database.rev150314.db.instance.AuthenticationKey;
import org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.mapping.database.rev150314.db.instance.Mapping;
import org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.mapping.database.rev150314.mapping.database.InstanceId;
import org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.mapping.database.rev150314.mapping.database.InstanceIdKey;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class InstanceIdBuilder
implements Builder<InstanceId> {
    private List<AuthenticationKey> _authenticationKey;
    private IidUri _iid;
    private InstanceIdKey _key;
    private List<Mapping> _mapping;
    Map<Class<? extends Augmentation<InstanceId>>, Augmentation<InstanceId>> augmentation = Collections.emptyMap();

    public InstanceIdBuilder() {
    }

    public InstanceIdBuilder(DbInstance arg) {
        this._iid = arg.getIid();
        this._mapping = arg.getMapping();
        this._authenticationKey = arg.getAuthenticationKey();
    }

    public InstanceIdBuilder(InstanceId base) {
        AugmentationHolder casted;
        if (base.getKey() == null) {
            this._key = new InstanceIdKey(base.getIid());
            this._iid = base.getIid();
        } else {
            this._key = base.getKey();
            this._iid = this._key.getIid();
        }
        this._authenticationKey = base.getAuthenticationKey();
        this._mapping = base.getMapping();
        if (base instanceof InstanceIdImpl) {
            InstanceIdImpl impl = (InstanceIdImpl)base;
            if (!impl.augmentation.isEmpty()) {
                this.augmentation = new HashMap<Class<? extends Augmentation<InstanceId>>, Augmentation<InstanceId>>(impl.augmentation);
            }
        } else if (base instanceof AugmentationHolder && !(casted = (AugmentationHolder)base).augmentations().isEmpty()) {
            this.augmentation = new HashMap<Class<? extends Augmentation<InstanceId>>, Augmentation<InstanceId>>(casted.augmentations());
        }
    }

    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof DbInstance) {
            this._iid = ((DbInstance)arg).getIid();
            this._mapping = ((DbInstance)arg).getMapping();
            this._authenticationKey = ((DbInstance)arg).getAuthenticationKey();
            isValidArg = true;
        }
        if (!isValidArg) {
            throw new IllegalArgumentException("expected one of: [org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.mapping.database.rev150314.DbInstance] \nbut was: " + arg);
        }
    }

    public List<AuthenticationKey> getAuthenticationKey() {
        return this._authenticationKey;
    }

    public IidUri getIid() {
        return this._iid;
    }

    public InstanceIdKey getKey() {
        return this._key;
    }

    public List<Mapping> getMapping() {
        return this._mapping;
    }

    public <E extends Augmentation<InstanceId>> E getAugmentation(Class<E> augmentationType) {
        if (augmentationType == null) {
            throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
        }
        return (E)this.augmentation.get(augmentationType);
    }

    public InstanceIdBuilder setAuthenticationKey(List<AuthenticationKey> value) {
        this._authenticationKey = value;
        return this;
    }

    public InstanceIdBuilder setIid(IidUri value) {
        if (value != null) {
            // empty if block
        }
        this._iid = value;
        return this;
    }

    public InstanceIdBuilder setKey(InstanceIdKey value) {
        this._key = value;
        return this;
    }

    public InstanceIdBuilder setMapping(List<Mapping> value) {
        this._mapping = value;
        return this;
    }

    public InstanceIdBuilder addAugmentation(Class<? extends Augmentation<InstanceId>> augmentationType, Augmentation<InstanceId> augmentation) {
        if (augmentation == null) {
            return this.removeAugmentation(augmentationType);
        }
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<InstanceId>>, Augmentation<InstanceId>>();
        }
        this.augmentation.put(augmentationType, augmentation);
        return this;
    }

    public InstanceIdBuilder removeAugmentation(Class<? extends Augmentation<InstanceId>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    public InstanceId build() {
        return new InstanceIdImpl(this);
    }

    private static final class InstanceIdImpl
    implements InstanceId {
        private final List<AuthenticationKey> _authenticationKey;
        private final IidUri _iid;
        private final InstanceIdKey _key;
        private final List<Mapping> _mapping;
        private Map<Class<? extends Augmentation<InstanceId>>, Augmentation<InstanceId>> augmentation = Collections.emptyMap();
        private int hash = 0;
        private volatile boolean hashValid = false;

        public Class<InstanceId> getImplementedInterface() {
            return InstanceId.class;
        }

        private InstanceIdImpl(InstanceIdBuilder base) {
            if (base.getKey() == null) {
                this._key = new InstanceIdKey(base.getIid());
                this._iid = base.getIid();
            } else {
                this._key = base.getKey();
                this._iid = this._key.getIid();
            }
            this._authenticationKey = base.getAuthenticationKey();
            this._mapping = base.getMapping();
            switch (base.augmentation.size()) {
                case 0: {
                    this.augmentation = Collections.emptyMap();
                    break;
                }
                case 1: {
                    Map.Entry<Class<? extends Augmentation<InstanceId>>, Augmentation<InstanceId>> e = base.augmentation.entrySet().iterator().next();
                    this.augmentation = Collections.singletonMap(e.getKey(), e.getValue());
                    break;
                }
                default: {
                    this.augmentation = new HashMap<Class<? extends Augmentation<InstanceId>>, Augmentation<InstanceId>>(base.augmentation);
                }
            }
        }

        @Override
        public List<AuthenticationKey> getAuthenticationKey() {
            return this._authenticationKey;
        }

        @Override
        public IidUri getIid() {
            return this._iid;
        }

        @Override
        public InstanceIdKey getKey() {
            return this._key;
        }

        @Override
        public List<Mapping> getMapping() {
            return this._mapping;
        }

        public <E extends Augmentation<InstanceId>> E getAugmentation(Class<E> augmentationType) {
            if (augmentationType == null) {
                throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
            }
            return (E)this.augmentation.get(augmentationType);
        }

        public int hashCode() {
            if (this.hashValid) {
                return this.hash;
            }
            int prime = 31;
            int result = 1;
            result = 31 * result + (this._authenticationKey == null ? 0 : this._authenticationKey.hashCode());
            result = 31 * result + (this._iid == null ? 0 : this._iid.hashCode());
            result = 31 * result + (this._key == null ? 0 : this._key.hashCode());
            result = 31 * result + (this._mapping == null ? 0 : this._mapping.hashCode());
            this.hash = result = 31 * result + (this.augmentation == null ? 0 : this.augmentation.hashCode());
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!InstanceId.class.equals((Object)((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            InstanceId other = (InstanceId)obj;
            if (this._authenticationKey == null ? other.getAuthenticationKey() != null : !this._authenticationKey.equals(other.getAuthenticationKey())) {
                return false;
            }
            if (this._iid == null ? other.getIid() != null : !this._iid.equals(other.getIid())) {
                return false;
            }
            if (this._key == null ? other.getKey() != null : !this._key.equals(other.getKey())) {
                return false;
            }
            if (this._mapping == null ? other.getMapping() != null : !this._mapping.equals(other.getMapping())) {
                return false;
            }
            if (this.getClass() == obj.getClass()) {
                InstanceIdImpl otherImpl = (InstanceIdImpl)obj;
                if (this.augmentation == null ? otherImpl.augmentation != null : !this.augmentation.equals(otherImpl.augmentation)) {
                    return false;
                }
            } else {
                for (Map.Entry<Class<? extends Augmentation<InstanceId>>, Augmentation<InstanceId>> e : this.augmentation.entrySet()) {
                    if (e.getValue().equals((Object)other.getAugmentation(e.getKey()))) continue;
                    return false;
                }
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }

        public String toString() {
            StringBuilder builder = new StringBuilder("InstanceId [");
            boolean first = true;
            if (this._authenticationKey != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_authenticationKey=");
                builder.append(this._authenticationKey);
            }
            if (this._iid != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_iid=");
                builder.append(this._iid);
            }
            if (this._key != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_key=");
                builder.append(this._key);
            }
            if (this._mapping != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_mapping=");
                builder.append(this._mapping);
            }
            if (first) {
                first = false;
            } else {
                builder.append(", ");
            }
            builder.append("augmentation=");
            builder.append(this.augmentation.values());
            return builder.append(']').toString();
        }
    }
}

