/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.mapping.database.rev150314.update.key.input;

import com.google.common.collect.Range;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.mapping.database.rev150314.MappingAuthkey;
import org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.mapping.database.rev150314.update.key.input.Key;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class KeyBuilder
implements Builder<Key> {
    private String _authkey;
    private Integer _keyType;
    Map<Class<? extends Augmentation<Key>>, Augmentation<Key>> augmentation = Collections.emptyMap();

    public KeyBuilder() {
    }

    public KeyBuilder(MappingAuthkey arg) {
        this._keyType = arg.getKeyType();
        this._authkey = arg.getAuthkey();
    }

    public KeyBuilder(Key base) {
        AugmentationHolder casted;
        this._authkey = base.getAuthkey();
        this._keyType = base.getKeyType();
        if (base instanceof KeyImpl) {
            KeyImpl impl = (KeyImpl)base;
            if (!impl.augmentation.isEmpty()) {
                this.augmentation = new HashMap<Class<? extends Augmentation<Key>>, Augmentation<Key>>(impl.augmentation);
            }
        } else if (base instanceof AugmentationHolder && !(casted = (AugmentationHolder)base).augmentations().isEmpty()) {
            this.augmentation = new HashMap<Class<? extends Augmentation<Key>>, Augmentation<Key>>(casted.augmentations());
        }
    }

    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof MappingAuthkey) {
            this._keyType = ((MappingAuthkey)arg).getKeyType();
            this._authkey = ((MappingAuthkey)arg).getAuthkey();
            isValidArg = true;
        }
        if (!isValidArg) {
            throw new IllegalArgumentException("expected one of: [org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.mapping.database.rev150314.MappingAuthkey] \nbut was: " + arg);
        }
    }

    public String getAuthkey() {
        return this._authkey;
    }

    public Integer getKeyType() {
        return this._keyType;
    }

    public <E extends Augmentation<Key>> E getAugmentation(Class<E> augmentationType) {
        if (augmentationType == null) {
            throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
        }
        return (E)this.augmentation.get(augmentationType);
    }

    public KeyBuilder setAuthkey(String value) {
        this._authkey = value;
        return this;
    }

    private static void checkKeyTypeRange(int value) {
        if (value >= 0 && value <= 65535) {
            return;
        }
        throw new IllegalArgumentException(String.format("Invalid range: %s, expected: [[0\u202565535]].", value));
    }

    public KeyBuilder setKeyType(Integer value) {
        if (value != null) {
            KeyBuilder.checkKeyTypeRange(value);
        }
        this._keyType = value;
        return this;
    }

    @Deprecated
    public static List<Range<BigInteger>> _keyType_range() {
        ArrayList<Range<BigInteger>> ret = new ArrayList<Range<BigInteger>>(1);
        ret.add(Range.closed((Comparable)BigInteger.ZERO, (Comparable)BigInteger.valueOf(65535L)));
        return ret;
    }

    public KeyBuilder addAugmentation(Class<? extends Augmentation<Key>> augmentationType, Augmentation<Key> augmentation) {
        if (augmentation == null) {
            return this.removeAugmentation(augmentationType);
        }
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<Key>>, Augmentation<Key>>();
        }
        this.augmentation.put(augmentationType, augmentation);
        return this;
    }

    public KeyBuilder removeAugmentation(Class<? extends Augmentation<Key>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    public Key build() {
        return new KeyImpl(this);
    }

    private static final class KeyImpl
    implements Key {
        private final String _authkey;
        private final Integer _keyType;
        private Map<Class<? extends Augmentation<Key>>, Augmentation<Key>> augmentation = Collections.emptyMap();
        private int hash = 0;
        private volatile boolean hashValid = false;

        public Class<Key> getImplementedInterface() {
            return Key.class;
        }

        private KeyImpl(KeyBuilder base) {
            this._authkey = base.getAuthkey();
            this._keyType = base.getKeyType();
            switch (base.augmentation.size()) {
                case 0: {
                    this.augmentation = Collections.emptyMap();
                    break;
                }
                case 1: {
                    Map.Entry<Class<? extends Augmentation<Key>>, Augmentation<Key>> e = base.augmentation.entrySet().iterator().next();
                    this.augmentation = Collections.singletonMap(e.getKey(), e.getValue());
                    break;
                }
                default: {
                    this.augmentation = new HashMap<Class<? extends Augmentation<Key>>, Augmentation<Key>>(base.augmentation);
                }
            }
        }

        @Override
        public String getAuthkey() {
            return this._authkey;
        }

        @Override
        public Integer getKeyType() {
            return this._keyType;
        }

        public <E extends Augmentation<Key>> E getAugmentation(Class<E> augmentationType) {
            if (augmentationType == null) {
                throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
            }
            return (E)this.augmentation.get(augmentationType);
        }

        public int hashCode() {
            if (this.hashValid) {
                return this.hash;
            }
            int prime = 31;
            int result = 1;
            result = 31 * result + (this._authkey == null ? 0 : this._authkey.hashCode());
            result = 31 * result + (this._keyType == null ? 0 : this._keyType.hashCode());
            this.hash = result = 31 * result + (this.augmentation == null ? 0 : this.augmentation.hashCode());
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!Key.class.equals((Object)((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            Key other = (Key)obj;
            if (this._authkey == null ? other.getAuthkey() != null : !this._authkey.equals(other.getAuthkey())) {
                return false;
            }
            if (this._keyType == null ? other.getKeyType() != null : !this._keyType.equals(other.getKeyType())) {
                return false;
            }
            if (this.getClass() == obj.getClass()) {
                KeyImpl otherImpl = (KeyImpl)obj;
                if (this.augmentation == null ? otherImpl.augmentation != null : !this.augmentation.equals(otherImpl.augmentation)) {
                    return false;
                }
            } else {
                for (Map.Entry<Class<? extends Augmentation<Key>>, Augmentation<Key>> e : this.augmentation.entrySet()) {
                    if (e.getValue().equals((Object)other.getAugmentation(e.getKey()))) continue;
                    return false;
                }
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }

        public String toString() {
            StringBuilder builder = new StringBuilder("Key [");
            boolean first = true;
            if (this._authkey != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_authkey=");
                builder.append(this._authkey);
            }
            if (this._keyType != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_keyType=");
                builder.append(this._keyType);
            }
            if (first) {
                first = false;
            } else {
                builder.append(", ");
            }
            builder.append("augmentation=");
            builder.append(this.augmentation.values());
            return builder.append(']').toString();
        }
    }
}

