package org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.netconf.acm.rev180214;
import com.google.common.base.MoreObjects;
import com.google.common.collect.Lists;
import java.io.Serializable;
import java.lang.Boolean;
import java.lang.IllegalArgumentException;
import java.lang.Override;
import java.lang.String;
import java.util.List;
import java.util.Objects;
import javax.annotation.processing.Generated;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.TypeObject;

@Generated("mdsal-binding-generator")
public class AccessOperationsType
 implements TypeObject, Serializable {
    private static final long serialVersionUID = -7674819084904232960L;
    private final Boolean _create;
    private final Boolean _read;
    private final Boolean _update;
    private final Boolean _delete;
    private final Boolean _exec;


    public AccessOperationsType(Boolean _create, Boolean _delete, Boolean _exec, Boolean _read, Boolean _update) {
    
        this._create = _create;
        this._read = _read;
        this._update = _update;
        this._delete = _delete;
        this._exec = _exec;
    }
    
    /**
     * Creates a copy from Source Object.
     *
     * @param source Source object
     */
    public AccessOperationsType(AccessOperationsType source) {
        this._create = source._create;
        this._read = source._read;
        this._update = source._update;
        this._delete = source._delete;
        this._exec = source._exec;
    }

    public static AccessOperationsType getDefaultInstance(final String defaultValue) {
        List<String> properties = Lists.newArrayList("create",
        "delete",
        "exec",
        "read",
        "update"
        );
        if (!properties.contains(defaultValue)) {
            throw new IllegalArgumentException("invalid default parameter");
        }
        int i = 0;
        return new AccessOperationsType(
        properties.get(i++).equals(defaultValue) ? Boolean.TRUE : null,
        properties.get(i++).equals(defaultValue) ? Boolean.TRUE : null,
        properties.get(i++).equals(defaultValue) ? Boolean.TRUE : null,
        properties.get(i++).equals(defaultValue) ? Boolean.TRUE : null,
        properties.get(i++).equals(defaultValue) ? Boolean.TRUE : null
        );
    }

    public Boolean getCreate() {
        return _create;
    }
    
    public Boolean getRead() {
        return _read;
    }
    
    public Boolean getUpdate() {
        return _update;
    }
    
    public Boolean getDelete() {
        return _delete;
    }
    
    public Boolean getExec() {
        return _exec;
    }

    
    public boolean[] getValue() {
        return new boolean[]{
        _create,
        _read,
        _update,
        _delete,
        _exec
        };
    }

    @Override
    public int hashCode() {
        final int prime = 31;
        int result = 1;
        result = prime * result + Objects.hashCode(_create);
        result = prime * result + Objects.hashCode(_read);
        result = prime * result + Objects.hashCode(_update);
        result = prime * result + Objects.hashCode(_delete);
        result = prime * result + Objects.hashCode(_exec);
        return result;
    }

    @Override
    public final boolean equals(java.lang.Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof AccessOperationsType)) {
            return false;
        }
        final AccessOperationsType other = (AccessOperationsType) obj;
        if (!Objects.equals(_create, other._create)) {
            return false;
        }
        if (!Objects.equals(_read, other._read)) {
            return false;
        }
        if (!Objects.equals(_update, other._update)) {
            return false;
        }
        if (!Objects.equals(_delete, other._delete)) {
            return false;
        }
        if (!Objects.equals(_exec, other._exec)) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        final MoreObjects.ToStringHelper helper = MoreObjects.toStringHelper(AccessOperationsType.class);
        CodeHelpers.appendValue(helper, "_create", _create);
        CodeHelpers.appendValue(helper, "_read", _read);
        CodeHelpers.appendValue(helper, "_update", _update);
        CodeHelpers.appendValue(helper, "_delete", _delete);
        CodeHelpers.appendValue(helper, "_exec", _exec);
        return helper.toString();
    }
}

