package org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.netconf.acm.rev180214;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableMap.Builder;
import java.lang.Integer;
import java.lang.Override;
import java.lang.String;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.processing.Generated;
import org.opendaylight.yangtools.yang.binding.Enumeration;

@Generated("mdsal-binding-generator")
public enum ActionType implements Enumeration {
    /**
     * Requested action is permitted.
     */
    Permit(0, "permit"),
    
    /**
     * Requested action is denied.
     */
    Deny(1, "deny")
    ;

    private static final Map<String, ActionType> NAME_MAP;
    private static final Map<Integer, ActionType> VALUE_MAP;

    static {
        final Builder<String, ActionType> nb = ImmutableMap.builder();
        final Builder<Integer, ActionType> vb = ImmutableMap.builder();
        for (ActionType enumItem : ActionType.values()) {
            vb.put(enumItem.value, enumItem);
            nb.put(enumItem.name, enumItem);
        }

        NAME_MAP = nb.build();
        VALUE_MAP = vb.build();
    }

    private final String name;
    private final int value;

    private ActionType(int value, String name) {
        this.value = value;
        this.name = name;
    }

    @Override
    public String getName() {
        return name;
    }

    @Override
    public int getIntValue() {
        return value;
    }

    /**
     * Return the enumeration member whose {@link #getName()} matches specified value.
     *
     * @param name YANG assigned name
     * @return corresponding ActionType item, if present
     * @throws NullPointerException if name is null
     */
    public static Optional<ActionType> forName(String name) {
        return Optional.ofNullable(NAME_MAP.get(Objects.requireNonNull(name)));
    }

    /**
     * Return the enumeration member whose {@link #getIntValue()} matches specified value.
     *
     * @param intValue integer value
     * @return corresponding ActionType item, or null if no such item exists
     */
    public static ActionType forValue(int intValue) {
        return VALUE_MAP.get(intValue);
    }
}
