package org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.netconf.acm.rev180214;
import javax.annotation.processing.Generated;
import org.opendaylight.yangtools.yang.binding.DataRoot;

/**
 * Network Configuration Access Control Model. Copyright (c) 2012 - 2018 IETF 
 * and the persons identified as authors of the code. All rights reserved. 
 * Redistribution and use in source and binary forms, with or without 
 * is permitted pursuant to, and subject to the license terms contained in, the 
 * Simplified BSD License set forth in Section 4.c of the IETF Trust's Legal 
 * Provisions Relating to IETF Documents (https://trustee.ietf.org/license-info). 
 * This version of this YANG module is part of RFC 8341; see the RFC itself for 
 * full legal notices.
 *
 * <p>
 * This class represents the following YANG schema fragment defined in module <b>ietf-netconf-acm</b>
 * <pre>
 * module ietf-netconf-acm {
 *   namespace urn:ietf:params:xml:ns:yang:ietf-netconf-acm;
 *   prefix nacm;
 *   import ietf-yang-types {
 *     prefix yang;
 *   }
 *   revision 2018-02-14 {
 *   }
 *   revision 2012-02-22 {
 *   }
 *   extension default-deny-write {
 *   }
 *   extension default-deny-all {
 *   }
 *   typedef user-name-type {
 *     type string {
 *       length 1..max;
 *     }
 *   }
 *   typedef matchall-string-type {
 *     type string {
 *       pattern \*;
 *     }
 *   }
 *   typedef access-operations-type {
 *     type bits {
 *       bit create {
 *       }
 *       bit read {
 *       }
 *       bit update {
 *       }
 *       bit delete {
 *       }
 *       bit exec {
 *       }
 *     }
 *   }
 *   typedef group-name-type {
 *     type string {
 *       length 1..max;
 *       pattern [^\*].*;
 *     }
 *   }
 *   typedef action-type {
 *     type enumeration {
 *       enum permit {
 *       }
 *       enum deny {
 *       }
 *     }
 *   }
 *   typedef node-instance-identifier {
 *     type yang:xpath1.0;
 *   }
 *   container nacm {
 *     nacm:default-deny-all;
 *     leaf enable-nacm {
 *       type boolean;
 *       default true;
 *     }
 *     leaf read-default {
 *       type action-type;
 *       default permit;
 *     }
 *     leaf write-default {
 *       type action-type;
 *       default deny;
 *     }
 *     leaf exec-default {
 *       type action-type;
 *       default permit;
 *     }
 *     leaf enable-external-groups {
 *       type boolean;
 *       default true;
 *     }
 *     leaf denied-operations {
 *       type yang:zero-based-counter32;
 *       config false;
 *     }
 *     leaf denied-data-writes {
 *       type yang:zero-based-counter32;
 *       config false;
 *     }
 *     leaf denied-notifications {
 *       type yang:zero-based-counter32;
 *       config false;
 *     }
 *     container groups {
 *       list group {
 *         key name;
 *         leaf name {
 *           type group-name-type;
 *         }
 *         leaf-list user-name {
 *           type user-name-type;
 *         }
 *       }
 *     }
 *     list rule-list {
 *       key name;
 *       ordered-by user;
 *       leaf name {
 *         type string {
 *           length 1..max;
 *         }
 *       }
 *       leaf-list group {
 *         type union {
 *           type matchall-string-type;
 *           type group-name-type;
 *         }
 *       }
 *       list rule {
 *         key name;
 *         ordered-by user;
 *         leaf name {
 *           type string {
 *             length 1..max;
 *           }
 *         }
 *         leaf module-name {
 *           type union {
 *             type matchall-string-type;
 *             type string;
 *           }
 *           default *;
 *         }
 *         choice rule-type {
 *           case protocol-operation {
 *             leaf rpc-name {
 *               type union {
 *                 type matchall-string-type;
 *                 type string;
 *               }
 *             }
 *           }
 *           case notification {
 *             leaf notification-name {
 *               type union {
 *                 type matchall-string-type;
 *                 type string;
 *               }
 *             }
 *           }
 *           case data-node {
 *             leaf path {
 *               type node-instance-identifier;
 *             }
 *           }
 *         }
 *         leaf access-operations {
 *           type union {
 *             type matchall-string-type;
 *             type access-operations-type;
 *           }
 *           default *;
 *         }
 *         leaf action {
 *           type action-type;
 *         }
 *         leaf comment {
 *           type string;
 *         }
 *       }
 *     }
 *   }
 * }
 * </pre>
 *
 */
@Generated("mdsal-binding-generator")
public interface IetfNetconfAcmData
    extends
    DataRoot
{




    /**
     * Return nacm, or {@code null} if it is not present.
     *
     * <pre>
     *     <code>
     *         Parameters for NETCONF access control model.
     *     </code>
     * </pre>
     *
     * @return {@code Nacm} nacm, or {@code null} if it is not present.
     *
     */
    Nacm getNacm();

}

