package org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.netconf.acm.rev180214;
import com.google.common.base.MoreObjects;
import java.lang.Boolean;
import java.lang.Class;
import java.lang.NullPointerException;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Objects;
import javax.annotation.processing.Generated;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.netconf.acm.rev180214.nacm.Groups;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.netconf.acm.rev180214.nacm.RuleList;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.yang.types.rev130715.ZeroBasedCounter32;
import org.opendaylight.yangtools.yang.binding.Augmentable;
import org.opendaylight.yangtools.yang.binding.ChildOf;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.common.QName;

/**
 * Parameters for NETCONF access control model.
 *
 * <p>
 * This class represents the following YANG schema fragment defined in module <b>ietf-netconf-acm</b>
 * <pre>
 * container nacm {
 *   nacm:default-deny-all;
 *   leaf enable-nacm {
 *     type boolean;
 *     default true;
 *   }
 *   leaf read-default {
 *     type action-type;
 *     default permit;
 *   }
 *   leaf write-default {
 *     type action-type;
 *     default deny;
 *   }
 *   leaf exec-default {
 *     type action-type;
 *     default permit;
 *   }
 *   leaf enable-external-groups {
 *     type boolean;
 *     default true;
 *   }
 *   leaf denied-operations {
 *     type yang:zero-based-counter32;
 *     config false;
 *   }
 *   leaf denied-data-writes {
 *     type yang:zero-based-counter32;
 *     config false;
 *   }
 *   leaf denied-notifications {
 *     type yang:zero-based-counter32;
 *     config false;
 *   }
 *   container groups {
 *     list group {
 *       key name;
 *       leaf name {
 *         type group-name-type;
 *       }
 *       leaf-list user-name {
 *         type user-name-type;
 *       }
 *     }
 *   }
 *   list rule-list {
 *     key name;
 *     ordered-by user;
 *     leaf name {
 *       type string {
 *         length 1..max;
 *       }
 *     }
 *     leaf-list group {
 *       type union {
 *         type matchall-string-type;
 *         type group-name-type;
 *       }
 *     }
 *     list rule {
 *       key name;
 *       ordered-by user;
 *       leaf name {
 *         type string {
 *           length 1..max;
 *         }
 *       }
 *       leaf module-name {
 *         type union {
 *           type matchall-string-type;
 *           type string;
 *         }
 *         default *;
 *       }
 *       choice rule-type {
 *         case protocol-operation {
 *           leaf rpc-name {
 *             type union {
 *               type matchall-string-type;
 *               type string;
 *             }
 *           }
 *         }
 *         case notification {
 *           leaf notification-name {
 *             type union {
 *               type matchall-string-type;
 *               type string;
 *             }
 *           }
 *         }
 *         case data-node {
 *           leaf path {
 *             type node-instance-identifier;
 *           }
 *         }
 *       }
 *       leaf access-operations {
 *         type union {
 *           type matchall-string-type;
 *           type access-operations-type;
 *         }
 *         default *;
 *       }
 *       leaf action {
 *         type action-type;
 *       }
 *       leaf comment {
 *         type string;
 *       }
 *     }
 *   }
 * }
 * </pre>The schema path to identify an instance is
 * <i>ietf-netconf-acmnacm</i>
 *
 * <p>To create instances of this class use {@link NacmBuilder}.
 * @see NacmBuilder
 *
 */
@Generated("mdsal-binding-generator")
public interface Nacm
    extends
    ChildOf<IetfNetconfAcmData>,
    Augmentable<Nacm>
{



    public static final @NonNull QName QNAME = $YangModuleInfoImpl.qnameOf("nacm");

    @Override
    default Class<org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.netconf.acm.rev180214.Nacm> implementedInterface() {
        return org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.netconf.acm.rev180214.Nacm.class;
    }
    
    /**
     * Default implementation of {@link Object#hashCode()} contract for this interface.
     * Implementations of this interface are encouraged to defer to this method to get consistent hashing
     * results across all implementations.
     *
     * @param obj Object for which to generate hashCode() result.
     * @return Hash code value of data modeled by this interface.
     * @throws NullPointerException if {@code obj} is null
     */
    static int bindingHashCode(final org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.netconf.acm.rev180214.@NonNull Nacm obj) {
        final int prime = 31;
        int result = 1;
        result = prime * result + Objects.hashCode(obj.getDeniedDataWrites());
        result = prime * result + Objects.hashCode(obj.getDeniedNotifications());
        result = prime * result + Objects.hashCode(obj.getDeniedOperations());
        result = prime * result + Objects.hashCode(obj.getEnableExternalGroups());
        result = prime * result + Objects.hashCode(obj.getEnableNacm());
        result = prime * result + Objects.hashCode(obj.getExecDefault());
        result = prime * result + Objects.hashCode(obj.getGroups());
        result = prime * result + Objects.hashCode(obj.getReadDefault());
        result = prime * result + Objects.hashCode(obj.getRuleList());
        result = prime * result + Objects.hashCode(obj.getWriteDefault());
        for (var augmentation : obj.augmentations().values()) {
            result += augmentation.hashCode();
        }
        return result;
    }
    
    /**
     * Default implementation of {@link Object#equals(Object)} contract for this interface.
     * Implementations of this interface are encouraged to defer to this method to get consistent equality
     * results across all implementations.
     *
     * @param thisObj Object acting as the receiver of equals invocation
     * @param obj Object acting as argument to equals invocation
     * @return True if thisObj and obj are considered equal
     * @throws NullPointerException if {@code thisObj} is null
     */
    static boolean bindingEquals(final org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.netconf.acm.rev180214.@NonNull Nacm thisObj, final Object obj) {
        if (thisObj == obj) {
            return true;
        }
        final org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.netconf.acm.rev180214.Nacm other = CodeHelpers.checkCast(org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.netconf.acm.rev180214.Nacm.class, obj);
        if (other == null) {
            return false;
        }
        if (!Objects.equals(thisObj.getDeniedDataWrites(), other.getDeniedDataWrites())) {
            return false;
        }
        if (!Objects.equals(thisObj.getDeniedNotifications(), other.getDeniedNotifications())) {
            return false;
        }
        if (!Objects.equals(thisObj.getDeniedOperations(), other.getDeniedOperations())) {
            return false;
        }
        if (!Objects.equals(thisObj.getEnableExternalGroups(), other.getEnableExternalGroups())) {
            return false;
        }
        if (!Objects.equals(thisObj.getEnableNacm(), other.getEnableNacm())) {
            return false;
        }
        if (!Objects.equals(thisObj.getExecDefault(), other.getExecDefault())) {
            return false;
        }
        if (!Objects.equals(thisObj.getGroups(), other.getGroups())) {
            return false;
        }
        if (!Objects.equals(thisObj.getReadDefault(), other.getReadDefault())) {
            return false;
        }
        if (!Objects.equals(thisObj.getRuleList(), other.getRuleList())) {
            return false;
        }
        if (!Objects.equals(thisObj.getWriteDefault(), other.getWriteDefault())) {
            return false;
        }
        return thisObj.augmentations().equals(other.augmentations());
    }
    
    /**
     * Default implementation of {@link Object#toString()} contract for this interface.
     * Implementations of this interface are encouraged to defer to this method to get consistent string
     * representations across all implementations.
     *
     * @param obj Object for which to generate toString() result.
     * @return {@link String} value of data modeled by this interface.
     * @throws NullPointerException if {@code obj} is null
     */
    static String bindingToString(final org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.netconf.acm.rev180214.@NonNull Nacm obj) {
        final MoreObjects.ToStringHelper helper = MoreObjects.toStringHelper("Nacm");
        CodeHelpers.appendValue(helper, "deniedDataWrites", obj.getDeniedDataWrites());
        CodeHelpers.appendValue(helper, "deniedNotifications", obj.getDeniedNotifications());
        CodeHelpers.appendValue(helper, "deniedOperations", obj.getDeniedOperations());
        CodeHelpers.appendValue(helper, "enableExternalGroups", obj.getEnableExternalGroups());
        CodeHelpers.appendValue(helper, "enableNacm", obj.getEnableNacm());
        CodeHelpers.appendValue(helper, "execDefault", obj.getExecDefault());
        CodeHelpers.appendValue(helper, "groups", obj.getGroups());
        CodeHelpers.appendValue(helper, "readDefault", obj.getReadDefault());
        CodeHelpers.appendValue(helper, "ruleList", obj.getRuleList());
        CodeHelpers.appendValue(helper, "writeDefault", obj.getWriteDefault());
        CodeHelpers.appendAugmentations(helper, "augmentation", obj);
        return helper.toString();
    }
    
    /**
     * Return enableNacm, or {@code null} if it is not present.
     *
     * <pre>
     *     <code>
     *         Enables or disables all NETCONF access control enforcement. If 'true', then
     *         enforcement is enabled. If 'false', then enforcement is disabled.
     *     </code>
     * </pre>
     *
     * @return {@code Boolean} enableNacm, or {@code null} if it is not present.
     *
     */
    Boolean getEnableNacm();
    
    /**
     * Return enableNacm, guaranteed to be non-null.
     *
     * <pre>
     *     <code>
     *         Enables or disables all NETCONF access control enforcement. If 'true', then
     *         enforcement is enabled. If 'false', then enforcement is disabled.
     *     </code>
     * </pre>
     *
     * @return {@code Boolean} enableNacm, guaranteed to be non-null.
     * @throws NoSuchElementException if enableNacm is not present
     *
     */
    default @NonNull Boolean requireEnableNacm() {
        return CodeHelpers.require(getEnableNacm(), "enablenacm");
    }
    
    /**
     * Return readDefault, or {@code null} if it is not present.
     *
     * <pre>
     *     <code>
     *         Controls whether read access is granted if no appropriate rule is found for a
     *         particular read request.
     *     </code>
     * </pre>
     *
     * @return {@code ActionType} readDefault, or {@code null} if it is not present.
     *
     */
    ActionType getReadDefault();
    
    /**
     * Return readDefault, guaranteed to be non-null.
     *
     * <pre>
     *     <code>
     *         Controls whether read access is granted if no appropriate rule is found for a
     *         particular read request.
     *     </code>
     * </pre>
     *
     * @return {@code ActionType} readDefault, guaranteed to be non-null.
     * @throws NoSuchElementException if readDefault is not present
     *
     */
    default @NonNull ActionType requireReadDefault() {
        return CodeHelpers.require(getReadDefault(), "readdefault");
    }
    
    /**
     * Return writeDefault, or {@code null} if it is not present.
     *
     * <pre>
     *     <code>
     *         Controls whether create, update, or delete access is granted if no appropriate
     *         rule is found for a particular write request.
     *     </code>
     * </pre>
     *
     * @return {@code ActionType} writeDefault, or {@code null} if it is not present.
     *
     */
    ActionType getWriteDefault();
    
    /**
     * Return writeDefault, guaranteed to be non-null.
     *
     * <pre>
     *     <code>
     *         Controls whether create, update, or delete access is granted if no appropriate
     *         rule is found for a particular write request.
     *     </code>
     * </pre>
     *
     * @return {@code ActionType} writeDefault, guaranteed to be non-null.
     * @throws NoSuchElementException if writeDefault is not present
     *
     */
    default @NonNull ActionType requireWriteDefault() {
        return CodeHelpers.require(getWriteDefault(), "writedefault");
    }
    
    /**
     * Return execDefault, or {@code null} if it is not present.
     *
     * <pre>
     *     <code>
     *         Controls whether exec access is granted if no appropriate rule is found for a
     *         particular protocol operation request.
     *     </code>
     * </pre>
     *
     * @return {@code ActionType} execDefault, or {@code null} if it is not present.
     *
     */
    ActionType getExecDefault();
    
    /**
     * Return execDefault, guaranteed to be non-null.
     *
     * <pre>
     *     <code>
     *         Controls whether exec access is granted if no appropriate rule is found for a
     *         particular protocol operation request.
     *     </code>
     * </pre>
     *
     * @return {@code ActionType} execDefault, guaranteed to be non-null.
     * @throws NoSuchElementException if execDefault is not present
     *
     */
    default @NonNull ActionType requireExecDefault() {
        return CodeHelpers.require(getExecDefault(), "execdefault");
    }
    
    /**
     * Return enableExternalGroups, or {@code null} if it is not present.
     *
     * <pre>
     *     <code>
     *         Controls whether the server uses the groups reported by the NETCONF transport
     *         layer when it assigns the user to a set of NACM groups. If this leaf has the
     *         value 'false', any group names reported by the transport layer are ignored by
     *         the server.
     *     </code>
     * </pre>
     *
     * @return {@code Boolean} enableExternalGroups, or {@code null} if it is not present.
     *
     */
    Boolean getEnableExternalGroups();
    
    /**
     * Return enableExternalGroups, guaranteed to be non-null.
     *
     * <pre>
     *     <code>
     *         Controls whether the server uses the groups reported by the NETCONF transport
     *         layer when it assigns the user to a set of NACM groups. If this leaf has the
     *         value 'false', any group names reported by the transport layer are ignored by
     *         the server.
     *     </code>
     * </pre>
     *
     * @return {@code Boolean} enableExternalGroups, guaranteed to be non-null.
     * @throws NoSuchElementException if enableExternalGroups is not present
     *
     */
    default @NonNull Boolean requireEnableExternalGroups() {
        return CodeHelpers.require(getEnableExternalGroups(), "enableexternalgroups");
    }
    
    /**
     * Return deniedOperations, or {@code null} if it is not present.
     *
     * <pre>
     *     <code>
     *         Number of times since the server last restarted that a protocol operation
     *         request was denied.
     *     </code>
     * </pre>
     *
     * @return {@code ZeroBasedCounter32} deniedOperations, or {@code null} if it is not present.
     *
     */
    ZeroBasedCounter32 getDeniedOperations();
    
    /**
     * Return deniedOperations, guaranteed to be non-null.
     *
     * <pre>
     *     <code>
     *         Number of times since the server last restarted that a protocol operation
     *         request was denied.
     *     </code>
     * </pre>
     *
     * @return {@code ZeroBasedCounter32} deniedOperations, guaranteed to be non-null.
     * @throws NoSuchElementException if deniedOperations is not present
     *
     */
    default @NonNull ZeroBasedCounter32 requireDeniedOperations() {
        return CodeHelpers.require(getDeniedOperations(), "deniedoperations");
    }
    
    /**
     * Return deniedDataWrites, or {@code null} if it is not present.
     *
     * <pre>
     *     <code>
     *         Number of times since the server last restarted that a protocol operation
     *         request to alter a configuration datastore was denied.
     *     </code>
     * </pre>
     *
     * @return {@code ZeroBasedCounter32} deniedDataWrites, or {@code null} if it is not present.
     *
     */
    ZeroBasedCounter32 getDeniedDataWrites();
    
    /**
     * Return deniedDataWrites, guaranteed to be non-null.
     *
     * <pre>
     *     <code>
     *         Number of times since the server last restarted that a protocol operation
     *         request to alter a configuration datastore was denied.
     *     </code>
     * </pre>
     *
     * @return {@code ZeroBasedCounter32} deniedDataWrites, guaranteed to be non-null.
     * @throws NoSuchElementException if deniedDataWrites is not present
     *
     */
    default @NonNull ZeroBasedCounter32 requireDeniedDataWrites() {
        return CodeHelpers.require(getDeniedDataWrites(), "denieddatawrites");
    }
    
    /**
     * Return deniedNotifications, or {@code null} if it is not present.
     *
     * <pre>
     *     <code>
     *         Number of times since the server last restarted that a notification was dropped
     *         for a subscription because access to the event type was denied.
     *     </code>
     * </pre>
     *
     * @return {@code ZeroBasedCounter32} deniedNotifications, or {@code null} if it is not present.
     *
     */
    ZeroBasedCounter32 getDeniedNotifications();
    
    /**
     * Return deniedNotifications, guaranteed to be non-null.
     *
     * <pre>
     *     <code>
     *         Number of times since the server last restarted that a notification was dropped
     *         for a subscription because access to the event type was denied.
     *     </code>
     * </pre>
     *
     * @return {@code ZeroBasedCounter32} deniedNotifications, guaranteed to be non-null.
     * @throws NoSuchElementException if deniedNotifications is not present
     *
     */
    default @NonNull ZeroBasedCounter32 requireDeniedNotifications() {
        return CodeHelpers.require(getDeniedNotifications(), "deniednotifications");
    }
    
    /**
     * Return groups, or {@code null} if it is not present.
     *
     * <pre>
     *     <code>
     *         NETCONF access control groups.
     *     </code>
     * </pre>
     *
     * @return {@code Groups} groups, or {@code null} if it is not present.
     *
     */
    Groups getGroups();
    
    /**
     * Return ruleList, or {@code null} if it is not present.
     *
     * <pre>
     *     <code>
     *         An ordered collection of access control rules.
     *     </code>
     * </pre>
     *
     * @return {@code List<RuleList>} ruleList, or {@code null} if it is not present.
     *
     */
    @Nullable List<RuleList> getRuleList();
    
    /**
     * Return ruleList, or an empty list if it is not present.
     *
     * @return {@code List<RuleList>} ruleList, or an empty list if it is not present.
     *
     */
    default @NonNull List<RuleList> nonnullRuleList() {
        return CodeHelpers.nonnull(getRuleList());
    }

}

