package org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.netconf.acm.rev180214;
import java.lang.Boolean;
import java.lang.Class;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.processing.Generated;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.netconf.acm.rev180214.nacm.Groups;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.netconf.acm.rev180214.nacm.RuleList;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.yang.types.rev130715.ZeroBasedCounter32;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.AbstractAugmentable;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;

/**
 * Class that builds {@link NacmBuilder} instances. Overall design of the class is that of a
 * <a href="https://en.wikipedia.org/wiki/Fluent_interface">fluent interface</a>, where method chaining is used.
 *
 * <p>
 * In general, this class is supposed to be used like this template:
 * <pre>
 *   <code>
 *     NacmBuilder createTarget(int fooXyzzy, int barBaz) {
 *         return new NacmBuilderBuilder()
 *             .setFoo(new FooBuilder().setXyzzy(fooXyzzy).build())
 *             .setBar(new BarBuilder().setBaz(barBaz).build())
 *             .build();
 *     }
 *   </code>
 * </pre>
 *
 * <p>
 * This pattern is supported by the immutable nature of NacmBuilder, as instances can be freely passed around without
 * worrying about synchronization issues.
 *
 * <p>
 * As a side note: method chaining results in:
 * <ul>
 *   <li>very efficient Java bytecode, as the method invocation result, in this case the Builder reference, is
 *       on the stack, so further method invocations just need to fill method arguments for the next method
 *       invocation, which is terminated by {@link #build()}, which is then returned from the method</li>
 *   <li>better understanding by humans, as the scope of mutable state (the builder) is kept to a minimum and is
 *       very localized</li>
 *   <li>better optimization oportunities, as the object scope is minimized in terms of invocation (rather than
 *       method) stack, making <a href="https://en.wikipedia.org/wiki/Escape_analysis">escape analysis</a> a lot
 *       easier. Given enough compiler (JIT/AOT) prowess, the cost of th builder object can be completely
 *       eliminated</li>
 * </ul>
 *
 * @see NacmBuilder
 * @see Builder
 *
 */
@Generated("mdsal-binding-generator")
public class NacmBuilder implements Builder<Nacm> {

    private ZeroBasedCounter32 _deniedDataWrites;
    private ZeroBasedCounter32 _deniedNotifications;
    private ZeroBasedCounter32 _deniedOperations;
    private Boolean _enableExternalGroups;
    private Boolean _enableNacm;
    private ActionType _execDefault;
    private Groups _groups;
    private ActionType _readDefault;
    private List<RuleList> _ruleList;
    private ActionType _writeDefault;


    Map<Class<? extends Augmentation<Nacm>>, Augmentation<Nacm>> augmentation = Collections.emptyMap();

    public NacmBuilder() {
    }
    
    

    public NacmBuilder(Nacm base) {
        Map<Class<? extends Augmentation<Nacm>>, Augmentation<Nacm>> aug = base.augmentations();
        if (!aug.isEmpty()) {
            this.augmentation = new HashMap<>(aug);
        }
        this._deniedDataWrites = base.getDeniedDataWrites();
        this._deniedNotifications = base.getDeniedNotifications();
        this._deniedOperations = base.getDeniedOperations();
        this._enableExternalGroups = base.getEnableExternalGroups();
        this._enableNacm = base.getEnableNacm();
        this._execDefault = base.getExecDefault();
        this._groups = base.getGroups();
        this._readDefault = base.getReadDefault();
        this._ruleList = base.getRuleList();
        this._writeDefault = base.getWriteDefault();
    }


    public ZeroBasedCounter32 getDeniedDataWrites() {
        return _deniedDataWrites;
    }
    
    public ZeroBasedCounter32 getDeniedNotifications() {
        return _deniedNotifications;
    }
    
    public ZeroBasedCounter32 getDeniedOperations() {
        return _deniedOperations;
    }
    
    public Boolean getEnableExternalGroups() {
        return _enableExternalGroups;
    }
    
    public Boolean getEnableNacm() {
        return _enableNacm;
    }
    
    public ActionType getExecDefault() {
        return _execDefault;
    }
    
    public Groups getGroups() {
        return _groups;
    }
    
    public ActionType getReadDefault() {
        return _readDefault;
    }
    
    public List<RuleList> getRuleList() {
        return _ruleList;
    }
    
    public ActionType getWriteDefault() {
        return _writeDefault;
    }

    @SuppressWarnings({ "unchecked", "checkstyle:methodTypeParameterName"})
    public <E$$ extends Augmentation<Nacm>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$) augmentation.get(Objects.requireNonNull(augmentationType));
    }

    
    public NacmBuilder setDeniedDataWrites(final ZeroBasedCounter32 value) {
        this._deniedDataWrites = value;
        return this;
    }
    
    public NacmBuilder setDeniedNotifications(final ZeroBasedCounter32 value) {
        this._deniedNotifications = value;
        return this;
    }
    
    public NacmBuilder setDeniedOperations(final ZeroBasedCounter32 value) {
        this._deniedOperations = value;
        return this;
    }
    
    public NacmBuilder setEnableExternalGroups(final Boolean value) {
        this._enableExternalGroups = value;
        return this;
    }
    
    public NacmBuilder setEnableNacm(final Boolean value) {
        this._enableNacm = value;
        return this;
    }
    
    public NacmBuilder setExecDefault(final ActionType value) {
        this._execDefault = value;
        return this;
    }
    
    public NacmBuilder setGroups(final Groups value) {
        this._groups = value;
        return this;
    }
    
    public NacmBuilder setReadDefault(final ActionType value) {
        this._readDefault = value;
        return this;
    }
    public NacmBuilder setRuleList(final List<RuleList> values) {
        this._ruleList = values;
        return this;
    }
    
    
    public NacmBuilder setWriteDefault(final ActionType value) {
        this._writeDefault = value;
        return this;
    }
    
    /**
      * Add an augmentation to this builder's product.
      *
      * @param augmentation augmentation to be added
      * @return this builder
      * @throws NullPointerException if {@code augmentation} is null
      */
    public NacmBuilder addAugmentation(Augmentation<Nacm> augmentation) {
        Class<? extends Augmentation<Nacm>> augmentationType = augmentation.implementedInterface();
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<>();
        }
    
        this.augmentation.put(augmentationType, augmentation);
        return this;
    }
    
    /**
      * Remove an augmentation from this builder's product. If this builder does not track such an augmentation
      * type, this method does nothing.
      *
      * @param augmentationType augmentation type to be removed
      * @return this builder
      */
    public NacmBuilder removeAugmentation(Class<? extends Augmentation<Nacm>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    @Override
    public Nacm build() {
        return new NacmImpl(this);
    }

    private static final class NacmImpl
        extends AbstractAugmentable<Nacm>
        implements Nacm {
    
        private final ZeroBasedCounter32 _deniedDataWrites;
        private final ZeroBasedCounter32 _deniedNotifications;
        private final ZeroBasedCounter32 _deniedOperations;
        private final Boolean _enableExternalGroups;
        private final Boolean _enableNacm;
        private final ActionType _execDefault;
        private final Groups _groups;
        private final ActionType _readDefault;
        private final List<RuleList> _ruleList;
        private final ActionType _writeDefault;
    
        NacmImpl(NacmBuilder base) {
            super(base.augmentation);
            this._deniedDataWrites = base.getDeniedDataWrites();
            this._deniedNotifications = base.getDeniedNotifications();
            this._deniedOperations = base.getDeniedOperations();
            this._enableExternalGroups = base.getEnableExternalGroups();
            this._enableNacm = base.getEnableNacm();
            this._execDefault = base.getExecDefault();
            this._groups = base.getGroups();
            this._readDefault = base.getReadDefault();
            this._ruleList = CodeHelpers.emptyToNull(base.getRuleList());
            this._writeDefault = base.getWriteDefault();
        }
    
        @Override
        public ZeroBasedCounter32 getDeniedDataWrites() {
            return _deniedDataWrites;
        }
        
        @Override
        public ZeroBasedCounter32 getDeniedNotifications() {
            return _deniedNotifications;
        }
        
        @Override
        public ZeroBasedCounter32 getDeniedOperations() {
            return _deniedOperations;
        }
        
        @Override
        public Boolean getEnableExternalGroups() {
            return _enableExternalGroups;
        }
        
        @Override
        public Boolean getEnableNacm() {
            return _enableNacm;
        }
        
        @Override
        public ActionType getExecDefault() {
            return _execDefault;
        }
        
        @Override
        public Groups getGroups() {
            return _groups;
        }
        
        @Override
        public ActionType getReadDefault() {
            return _readDefault;
        }
        
        @Override
        public List<RuleList> getRuleList() {
            return _ruleList;
        }
        
        @Override
        public ActionType getWriteDefault() {
            return _writeDefault;
        }
    
        private int hash = 0;
        private volatile boolean hashValid = false;
        
        @Override
        public int hashCode() {
            if (hashValid) {
                return hash;
            }
        
            final int result = Nacm.bindingHashCode(this);
            hash = result;
            hashValid = true;
            return result;
        }
    
        @Override
        public boolean equals(Object obj) {
            return Nacm.bindingEquals(this, obj);
        }
    
        @Override
        public String toString() {
            return Nacm.bindingToString(this);
        }
    }
}
