package org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.netconf.acm.rev180214;
import com.google.common.base.MoreObjects;
import java.beans.ConstructorProperties;
import java.io.Serializable;
import java.lang.Override;
import java.lang.String;
import java.util.Objects;
import javax.annotation.processing.Generated;
import javax.management.ConstructorParameters;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.ScalarTypeObject;

@Generated("mdsal-binding-generator")
public class UserNameType
 implements ScalarTypeObject<String>, Serializable {
    private static final long serialVersionUID = -5429842545245740142L;
    private final String _value;

    private static void check_valueLength(final String value) {
        final int length = value.codePointCount(0, value.length());
        if (length >= 1) {
            return;
        }
        CodeHelpers.throwInvalidLength("[[1..2147483647]]", value);
    }

    @ConstructorParameters("value")
    @ConstructorProperties("value")
    public UserNameType(String _value) {
        if (_value != null) {
            check_valueLength(_value);
        }
        
        CodeHelpers.requireValue(_value);
    
        this._value = _value;
    }
    
    /**
     * Creates a copy from Source Object.
     *
     * @param source Source object
     */
    public UserNameType(UserNameType source) {
        this._value = source._value;
    }

    public static UserNameType getDefaultInstance(final String defaultValue) {
        return new UserNameType(defaultValue);
    }

    @Override
    public String getValue() {
        return _value;
    }


    @Override
    public int hashCode() {
        return CodeHelpers.wrapperHashCode(_value);
    }

    @Override
    public final boolean equals(java.lang.Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof UserNameType)) {
            return false;
        }
        final UserNameType other = (UserNameType) obj;
        if (!Objects.equals(_value, other._value)) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        final MoreObjects.ToStringHelper helper = MoreObjects.toStringHelper(UserNameType.class);
        CodeHelpers.appendValue(helper, "_value", _value);
        return helper.toString();
    }
}

