package org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.netconf.acm.rev180214.nacm;
import com.google.common.base.MoreObjects;
import java.lang.Class;
import java.lang.NullPointerException;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.Map;
import java.util.Objects;
import javax.annotation.processing.Generated;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.netconf.acm.rev180214.$YangModuleInfoImpl;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.netconf.acm.rev180214.Nacm;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.netconf.acm.rev180214.nacm.groups.Group;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.netconf.acm.rev180214.nacm.groups.GroupKey;
import org.opendaylight.yangtools.yang.binding.Augmentable;
import org.opendaylight.yangtools.yang.binding.ChildOf;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.common.QName;

/**
 * NETCONF access control groups.
 *
 * <p>
 * This class represents the following YANG schema fragment defined in module <b>ietf-netconf-acm</b>
 * <pre>
 * container groups {
 *   list group {
 *     key name;
 *     leaf name {
 *       type group-name-type;
 *     }
 *     leaf-list user-name {
 *       type user-name-type;
 *     }
 *   }
 * }
 * </pre>The schema path to identify an instance is
 * <i>ietf-netconf-acmnacmgroups</i>
 *
 * <p>To create instances of this class use {@link GroupsBuilder}.
 * @see GroupsBuilder
 *
 */
@Generated("mdsal-binding-generator")
public interface Groups
    extends
    ChildOf<Nacm>,
    Augmentable<Groups>
{



    public static final @NonNull QName QNAME = $YangModuleInfoImpl.qnameOf("groups");

    @Override
    default Class<org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.netconf.acm.rev180214.nacm.Groups> implementedInterface() {
        return org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.netconf.acm.rev180214.nacm.Groups.class;
    }
    
    /**
     * Default implementation of {@link Object#hashCode()} contract for this interface.
     * Implementations of this interface are encouraged to defer to this method to get consistent hashing
     * results across all implementations.
     *
     * @param obj Object for which to generate hashCode() result.
     * @return Hash code value of data modeled by this interface.
     * @throws NullPointerException if {@code obj} is null
     */
    static int bindingHashCode(final org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.netconf.acm.rev180214.nacm.@NonNull Groups obj) {
        final int prime = 31;
        int result = 1;
        result = prime * result + Objects.hashCode(obj.getGroup());
        for (var augmentation : obj.augmentations().values()) {
            result += augmentation.hashCode();
        }
        return result;
    }
    
    /**
     * Default implementation of {@link Object#equals(Object)} contract for this interface.
     * Implementations of this interface are encouraged to defer to this method to get consistent equality
     * results across all implementations.
     *
     * @param thisObj Object acting as the receiver of equals invocation
     * @param obj Object acting as argument to equals invocation
     * @return True if thisObj and obj are considered equal
     * @throws NullPointerException if {@code thisObj} is null
     */
    static boolean bindingEquals(final org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.netconf.acm.rev180214.nacm.@NonNull Groups thisObj, final Object obj) {
        if (thisObj == obj) {
            return true;
        }
        final org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.netconf.acm.rev180214.nacm.Groups other = CodeHelpers.checkCast(org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.netconf.acm.rev180214.nacm.Groups.class, obj);
        if (other == null) {
            return false;
        }
        if (!Objects.equals(thisObj.getGroup(), other.getGroup())) {
            return false;
        }
        return thisObj.augmentations().equals(other.augmentations());
    }
    
    /**
     * Default implementation of {@link Object#toString()} contract for this interface.
     * Implementations of this interface are encouraged to defer to this method to get consistent string
     * representations across all implementations.
     *
     * @param obj Object for which to generate toString() result.
     * @return {@link String} value of data modeled by this interface.
     * @throws NullPointerException if {@code obj} is null
     */
    static String bindingToString(final org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.netconf.acm.rev180214.nacm.@NonNull Groups obj) {
        final MoreObjects.ToStringHelper helper = MoreObjects.toStringHelper("Groups");
        CodeHelpers.appendValue(helper, "group", obj.getGroup());
        CodeHelpers.appendAugmentations(helper, "augmentation", obj);
        return helper.toString();
    }
    
    /**
     * Return group, or {@code null} if it is not present.
     *
     * <pre>
     *     <code>
     *         One NACM group entry. This list will only contain configured entries, not any
     *         entries learned from any transport protocols.
     *     </code>
     * </pre>
     *
     * @return {@code Map<GroupKey, Group>} group, or {@code null} if it is not present.
     *
     */
    @Nullable Map<GroupKey, Group> getGroup();
    
    /**
     * Return group, or an empty list if it is not present.
     *
     * @return {@code Map<GroupKey, Group>} group, or an empty list if it is not present.
     *
     */
    default @NonNull Map<GroupKey, Group> nonnullGroup() {
        return CodeHelpers.nonnull(getGroup());
    }

}

