package org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.netconf.acm.rev180214.nacm;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import java.io.Serializable;
import java.lang.Class;
import java.lang.NullPointerException;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.regex.Pattern;
import javax.annotation.processing.Generated;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.netconf.acm.rev180214.$YangModuleInfoImpl;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.netconf.acm.rev180214.GroupNameType;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.netconf.acm.rev180214.MatchallStringType;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.netconf.acm.rev180214.Nacm;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.netconf.acm.rev180214.nacm.rule.list.Rule;
import org.opendaylight.yangtools.yang.binding.Augmentable;
import org.opendaylight.yangtools.yang.binding.ChildOf;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.Identifiable;
import org.opendaylight.yangtools.yang.binding.TypeObject;
import org.opendaylight.yangtools.yang.common.QName;

/**
 * An ordered collection of access control rules.
 *
 * <p>
 * This class represents the following YANG schema fragment defined in module <b>ietf-netconf-acm</b>
 * <pre>
 * list rule-list {
 *   key name;
 *   ordered-by user;
 *   leaf name {
 *     type string {
 *       length 1..max;
 *     }
 *   }
 *   leaf-list group {
 *     type union {
 *       type matchall-string-type;
 *       type group-name-type;
 *     }
 *   }
 *   list rule {
 *     key name;
 *     ordered-by user;
 *     leaf name {
 *       type string {
 *         length 1..max;
 *       }
 *     }
 *     leaf module-name {
 *       type union {
 *         type matchall-string-type;
 *         type string;
 *       }
 *       default *;
 *     }
 *     choice rule-type {
 *       case protocol-operation {
 *         leaf rpc-name {
 *           type union {
 *             type matchall-string-type;
 *             type string;
 *           }
 *         }
 *       }
 *       case notification {
 *         leaf notification-name {
 *           type union {
 *             type matchall-string-type;
 *             type string;
 *           }
 *         }
 *       }
 *       case data-node {
 *         leaf path {
 *           type node-instance-identifier;
 *         }
 *       }
 *     }
 *     leaf access-operations {
 *       type union {
 *         type matchall-string-type;
 *         type access-operations-type;
 *       }
 *       default *;
 *     }
 *     leaf action {
 *       type action-type;
 *     }
 *     leaf comment {
 *       type string;
 *     }
 *   }
 * }
 * </pre>The schema path to identify an instance is
 * <i>ietf-netconf-acmnacmrule-list</i>
 *
 * <p>To create instances of this class use {@link RuleListBuilder}.
 * @see RuleListBuilder
 * @see RuleListKey
 *
 */
@Generated("mdsal-binding-generator")
public interface RuleList
    extends
    ChildOf<Nacm>,
    Augmentable<RuleList>,
    Identifiable<RuleListKey>
{

    public static final class Group
     implements TypeObject, Serializable {
        private static final long serialVersionUID = -8163567230936482160L;
        public static final List<String> PATTERN_CONSTANTS = ImmutableList.of("^(?:\\*)$", "^(?:[^\\*].*)$");
        private static final Pattern[] patterns = CodeHelpers.compilePatterns(PATTERN_CONSTANTS);
        private static final String[] regexes = { "\\*", "[^\\*].*" };
        private final MatchallStringType _matchallStringType;
        private final GroupNameType _groupNameType;
    
    
        public Group(MatchallStringType _matchallStringType) {
            super();
            this._matchallStringType = _matchallStringType;
            this._groupNameType = null;
        }
        
        public Group(GroupNameType _groupNameType) {
            super();
            this._groupNameType = _groupNameType;
            this._matchallStringType = null;
        }
        /**
         * Creates a copy from Source Object.
         *
         * @param source Source object
         */
        public Group(Group source) {
            this._matchallStringType = source._matchallStringType;
            this._groupNameType = source._groupNameType;
        }
        
        /**
         * Return a String representing the value of this union.
         *
         * @return String representation of this union's value.
         */
        public String stringValue() {
            if (_matchallStringType != null) {
                return _matchallStringType.getValue().toString();
            }
            if (_groupNameType != null) {
                return _groupNameType.getValue().toString();
            }
        
            throw new IllegalStateException("No value assinged");
        }
    
    
        public MatchallStringType getMatchallStringType() {
            return _matchallStringType;
        }
        
        public GroupNameType getGroupNameType() {
            return _groupNameType;
        }
    
    
        @Override
        public int hashCode() {
            final int prime = 31;
            int result = 1;
            result = prime * result + Objects.hashCode(_matchallStringType);
            result = prime * result + Objects.hashCode(_groupNameType);
            return result;
        }
    
        @Override
        public final boolean equals(java.lang.Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof Group)) {
                return false;
            }
            final Group other = (Group) obj;
            if (!Objects.equals(_matchallStringType, other._matchallStringType)) {
                return false;
            }
            if (!Objects.equals(_groupNameType, other._groupNameType)) {
                return false;
            }
            return true;
        }
    
        @Override
        public String toString() {
            final MoreObjects.ToStringHelper helper = MoreObjects.toStringHelper(Group.class);
            CodeHelpers.appendValue(helper, "_matchallStringType", _matchallStringType);
            CodeHelpers.appendValue(helper, "_groupNameType", _groupNameType);
            return helper.toString();
        }
    }
    


    public static final @NonNull QName QNAME = $YangModuleInfoImpl.qnameOf("rule-list");

    @Override
    default Class<org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.netconf.acm.rev180214.nacm.RuleList> implementedInterface() {
        return org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.netconf.acm.rev180214.nacm.RuleList.class;
    }
    
    /**
     * Default implementation of {@link Object#hashCode()} contract for this interface.
     * Implementations of this interface are encouraged to defer to this method to get consistent hashing
     * results across all implementations.
     *
     * @param obj Object for which to generate hashCode() result.
     * @return Hash code value of data modeled by this interface.
     * @throws NullPointerException if {@code obj} is null
     */
    static int bindingHashCode(final org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.netconf.acm.rev180214.nacm.@NonNull RuleList obj) {
        final int prime = 31;
        int result = 1;
        result = prime * result + Objects.hashCode(obj.getGroup());
        result = prime * result + Objects.hashCode(obj.getName());
        result = prime * result + Objects.hashCode(obj.getRule());
        for (var augmentation : obj.augmentations().values()) {
            result += augmentation.hashCode();
        }
        return result;
    }
    
    /**
     * Default implementation of {@link Object#equals(Object)} contract for this interface.
     * Implementations of this interface are encouraged to defer to this method to get consistent equality
     * results across all implementations.
     *
     * @param thisObj Object acting as the receiver of equals invocation
     * @param obj Object acting as argument to equals invocation
     * @return True if thisObj and obj are considered equal
     * @throws NullPointerException if {@code thisObj} is null
     */
    static boolean bindingEquals(final org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.netconf.acm.rev180214.nacm.@NonNull RuleList thisObj, final Object obj) {
        if (thisObj == obj) {
            return true;
        }
        final org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.netconf.acm.rev180214.nacm.RuleList other = CodeHelpers.checkCast(org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.netconf.acm.rev180214.nacm.RuleList.class, obj);
        if (other == null) {
            return false;
        }
        if (!Objects.equals(thisObj.getName(), other.getName())) {
            return false;
        }
        if (!Objects.equals(thisObj.getGroup(), other.getGroup())) {
            return false;
        }
        if (!Objects.equals(thisObj.getRule(), other.getRule())) {
            return false;
        }
        return thisObj.augmentations().equals(other.augmentations());
    }
    
    /**
     * Default implementation of {@link Object#toString()} contract for this interface.
     * Implementations of this interface are encouraged to defer to this method to get consistent string
     * representations across all implementations.
     *
     * @param obj Object for which to generate toString() result.
     * @return {@link String} value of data modeled by this interface.
     * @throws NullPointerException if {@code obj} is null
     */
    static String bindingToString(final org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.netconf.acm.rev180214.nacm.@NonNull RuleList obj) {
        final MoreObjects.ToStringHelper helper = MoreObjects.toStringHelper("RuleList");
        CodeHelpers.appendValue(helper, "group", obj.getGroup());
        CodeHelpers.appendValue(helper, "name", obj.getName());
        CodeHelpers.appendValue(helper, "rule", obj.getRule());
        CodeHelpers.appendAugmentations(helper, "augmentation", obj);
        return helper.toString();
    }
    
    @Override
    RuleListKey key();
    
    /**
     * Return name, or {@code null} if it is not present.
     *
     * <pre>
     *     <code>
     *         Arbitrary name assigned to the rule-list.
     *     </code>
     * </pre>
     *
     * @return {@code String} name, or {@code null} if it is not present.
     *
     */
    String getName();
    
    /**
     * Return name, guaranteed to be non-null.
     *
     * <pre>
     *     <code>
     *         Arbitrary name assigned to the rule-list.
     *     </code>
     * </pre>
     *
     * @return {@code String} name, guaranteed to be non-null.
     * @throws NoSuchElementException if name is not present
     *
     */
    default @NonNull String requireName() {
        return CodeHelpers.require(getName(), "name");
    }
    
    /**
     * Return group, or {@code null} if it is not present.
     *
     * <pre>
     *     <code>
     *         List of administrative groups that will be assigned the associated access rights
     *         defined by the 'rule' list. The string '*' indicates that all groups apply to
     *         the entry.
     *     </code>
     * </pre>
     *
     * @return {@code List<Group>} group, or {@code null} if it is not present.
     *
     */
    @Nullable List<Group> getGroup();
    
    /**
     * Return group, guaranteed to be non-null.
     *
     * <pre>
     *     <code>
     *         List of administrative groups that will be assigned the associated access rights
     *         defined by the 'rule' list. The string '*' indicates that all groups apply to
     *         the entry.
     *     </code>
     * </pre>
     *
     * @return {@code List<Group>} group, guaranteed to be non-null.
     * @throws NoSuchElementException if group is not present
     *
     */
    default @NonNull List<Group> requireGroup() {
        return CodeHelpers.require(getGroup(), "group");
    }
    
    /**
     * Return rule, or {@code null} if it is not present.
     *
     * <pre>
     *     <code>
     *         One access control rule. Rules are processed in user-defined order until a match
     *         is found. A rule matches if 'module-name', 'rule-type', and 'access-operations'
     *         match the request. If a rule matches, the 'action' leaf determines whether or
     *         not access is granted.
     *     </code>
     * </pre>
     *
     * @return {@code List<Rule>} rule, or {@code null} if it is not present.
     *
     */
    @Nullable List<Rule> getRule();
    
    /**
     * Return rule, or an empty list if it is not present.
     *
     * @return {@code List<Rule>} rule, or an empty list if it is not present.
     *
     */
    default @NonNull List<Rule> nonnullRule() {
        return CodeHelpers.nonnull(getRule());
    }

}

