package org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.netconf.acm.rev180214.nacm;
import java.lang.Class;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.processing.Generated;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.netconf.acm.rev180214.nacm.rule.list.Rule;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.AbstractAugmentable;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;

/**
 * Class that builds {@link RuleListBuilder} instances. Overall design of the class is that of a
 * <a href="https://en.wikipedia.org/wiki/Fluent_interface">fluent interface</a>, where method chaining is used.
 *
 * <p>
 * In general, this class is supposed to be used like this template:
 * <pre>
 *   <code>
 *     RuleListBuilder createTarget(int fooXyzzy, int barBaz) {
 *         return new RuleListBuilderBuilder()
 *             .setFoo(new FooBuilder().setXyzzy(fooXyzzy).build())
 *             .setBar(new BarBuilder().setBaz(barBaz).build())
 *             .build();
 *     }
 *   </code>
 * </pre>
 *
 * <p>
 * This pattern is supported by the immutable nature of RuleListBuilder, as instances can be freely passed around without
 * worrying about synchronization issues.
 *
 * <p>
 * As a side note: method chaining results in:
 * <ul>
 *   <li>very efficient Java bytecode, as the method invocation result, in this case the Builder reference, is
 *       on the stack, so further method invocations just need to fill method arguments for the next method
 *       invocation, which is terminated by {@link #build()}, which is then returned from the method</li>
 *   <li>better understanding by humans, as the scope of mutable state (the builder) is kept to a minimum and is
 *       very localized</li>
 *   <li>better optimization oportunities, as the object scope is minimized in terms of invocation (rather than
 *       method) stack, making <a href="https://en.wikipedia.org/wiki/Escape_analysis">escape analysis</a> a lot
 *       easier. Given enough compiler (JIT/AOT) prowess, the cost of th builder object can be completely
 *       eliminated</li>
 * </ul>
 *
 * @see RuleListBuilder
 * @see Builder
 *
 */
@Generated("mdsal-binding-generator")
public class RuleListBuilder implements Builder<RuleList> {

    private List<RuleList.Group> _group;
    private String _name;
    private List<Rule> _rule;
    private RuleListKey key;


    Map<Class<? extends Augmentation<RuleList>>, Augmentation<RuleList>> augmentation = Collections.emptyMap();

    public RuleListBuilder() {
    }
    
    
    

    public RuleListBuilder(RuleList base) {
        Map<Class<? extends Augmentation<RuleList>>, Augmentation<RuleList>> aug = base.augmentations();
        if (!aug.isEmpty()) {
            this.augmentation = new HashMap<>(aug);
        }
        this.key = base.key();
        this._name = base.getName();
        this._group = base.getGroup();
        this._rule = base.getRule();
    }


    public RuleListKey key() {
        return key;
    }
    
    public List<RuleList.Group> getGroup() {
        return _group;
    }
    
    public String getName() {
        return _name;
    }
    
    public List<Rule> getRule() {
        return _rule;
    }

    @SuppressWarnings({ "unchecked", "checkstyle:methodTypeParameterName"})
    public <E$$ extends Augmentation<RuleList>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$) augmentation.get(Objects.requireNonNull(augmentationType));
    }

    public RuleListBuilder withKey(final RuleListKey key) {
        this.key = key;
        return this;
    }
    public RuleListBuilder setGroup(final List<RuleList.Group> values) {
        this._group = values;
        return this;
    }
    
    
    private static void check_nameLength(final String value) {
        final int length = value.codePointCount(0, value.length());
        if (length >= 1) {
            return;
        }
        CodeHelpers.throwInvalidLength("[[1..2147483647]]", value);
    }
    
    public RuleListBuilder setName(final String value) {
        if (value != null) {
            check_nameLength(value);
            
        }
        this._name = value;
        return this;
    }
    public RuleListBuilder setRule(final List<Rule> values) {
        this._rule = values;
        return this;
    }
    
    
    /**
      * Add an augmentation to this builder's product.
      *
      * @param augmentation augmentation to be added
      * @return this builder
      * @throws NullPointerException if {@code augmentation} is null
      */
    public RuleListBuilder addAugmentation(Augmentation<RuleList> augmentation) {
        Class<? extends Augmentation<RuleList>> augmentationType = augmentation.implementedInterface();
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<>();
        }
    
        this.augmentation.put(augmentationType, augmentation);
        return this;
    }
    
    /**
      * Remove an augmentation from this builder's product. If this builder does not track such an augmentation
      * type, this method does nothing.
      *
      * @param augmentationType augmentation type to be removed
      * @return this builder
      */
    public RuleListBuilder removeAugmentation(Class<? extends Augmentation<RuleList>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    @Override
    public RuleList build() {
        return new RuleListImpl(this);
    }

    private static final class RuleListImpl
        extends AbstractAugmentable<RuleList>
        implements RuleList {
    
        private final List<RuleList.Group> _group;
        private final String _name;
        private final List<Rule> _rule;
        private final RuleListKey key;
    
        RuleListImpl(RuleListBuilder base) {
            super(base.augmentation);
            if (base.key() != null) {
                this.key = base.key();
            } else {
                this.key = new RuleListKey(base.getName());
            }
            this._name = key.getName();
            this._group = base.getGroup();
            this._rule = CodeHelpers.emptyToNull(base.getRule());
        }
    
        @Override
        public RuleListKey key() {
            return key;
        }
        
        @Override
        public List<RuleList.Group> getGroup() {
            return _group;
        }
        
        @Override
        public String getName() {
            return _name;
        }
        
        @Override
        public List<Rule> getRule() {
            return _rule;
        }
    
        private int hash = 0;
        private volatile boolean hashValid = false;
        
        @Override
        public int hashCode() {
            if (hashValid) {
                return hash;
            }
        
            final int result = RuleList.bindingHashCode(this);
            hash = result;
            hashValid = true;
            return result;
        }
    
        @Override
        public boolean equals(Object obj) {
            return RuleList.bindingEquals(this, obj);
        }
    
        @Override
        public String toString() {
            return RuleList.bindingToString(this);
        }
    }
}
