package org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.netconf.acm.rev180214.nacm.groups;
import com.google.common.base.MoreObjects;
import java.lang.Class;
import java.lang.NullPointerException;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Objects;
import javax.annotation.processing.Generated;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.netconf.acm.rev180214.$YangModuleInfoImpl;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.netconf.acm.rev180214.GroupNameType;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.netconf.acm.rev180214.UserNameType;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.netconf.acm.rev180214.nacm.Groups;
import org.opendaylight.yangtools.yang.binding.Augmentable;
import org.opendaylight.yangtools.yang.binding.ChildOf;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.Identifiable;
import org.opendaylight.yangtools.yang.common.QName;

/**
 * One NACM group entry. This list will only contain configured entries, not any 
 * entries learned from any transport protocols.
 *
 * <p>
 * This class represents the following YANG schema fragment defined in module <b>ietf-netconf-acm</b>
 * <pre>
 * list group {
 *   key name;
 *   leaf name {
 *     type group-name-type;
 *   }
 *   leaf-list user-name {
 *     type user-name-type;
 *   }
 * }
 * </pre>The schema path to identify an instance is
 * <i>ietf-netconf-acmnacmgroupsgroup</i>
 *
 * <p>To create instances of this class use {@link GroupBuilder}.
 * @see GroupBuilder
 * @see GroupKey
 *
 */
@Generated("mdsal-binding-generator")
public interface Group
    extends
    ChildOf<Groups>,
    Augmentable<Group>,
    Identifiable<GroupKey>
{



    public static final @NonNull QName QNAME = $YangModuleInfoImpl.qnameOf("group");

    @Override
    default Class<org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.netconf.acm.rev180214.nacm.groups.Group> implementedInterface() {
        return org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.netconf.acm.rev180214.nacm.groups.Group.class;
    }
    
    /**
     * Default implementation of {@link Object#hashCode()} contract for this interface.
     * Implementations of this interface are encouraged to defer to this method to get consistent hashing
     * results across all implementations.
     *
     * @param obj Object for which to generate hashCode() result.
     * @return Hash code value of data modeled by this interface.
     * @throws NullPointerException if {@code obj} is null
     */
    static int bindingHashCode(final org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.netconf.acm.rev180214.nacm.groups.@NonNull Group obj) {
        final int prime = 31;
        int result = 1;
        result = prime * result + Objects.hashCode(obj.getName());
        result = prime * result + Objects.hashCode(obj.getUserName());
        for (var augmentation : obj.augmentations().values()) {
            result += augmentation.hashCode();
        }
        return result;
    }
    
    /**
     * Default implementation of {@link Object#equals(Object)} contract for this interface.
     * Implementations of this interface are encouraged to defer to this method to get consistent equality
     * results across all implementations.
     *
     * @param thisObj Object acting as the receiver of equals invocation
     * @param obj Object acting as argument to equals invocation
     * @return True if thisObj and obj are considered equal
     * @throws NullPointerException if {@code thisObj} is null
     */
    static boolean bindingEquals(final org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.netconf.acm.rev180214.nacm.groups.@NonNull Group thisObj, final Object obj) {
        if (thisObj == obj) {
            return true;
        }
        final org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.netconf.acm.rev180214.nacm.groups.Group other = CodeHelpers.checkCast(org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.netconf.acm.rev180214.nacm.groups.Group.class, obj);
        if (other == null) {
            return false;
        }
        if (!Objects.equals(thisObj.getName(), other.getName())) {
            return false;
        }
        if (!Objects.equals(thisObj.getUserName(), other.getUserName())) {
            return false;
        }
        return thisObj.augmentations().equals(other.augmentations());
    }
    
    /**
     * Default implementation of {@link Object#toString()} contract for this interface.
     * Implementations of this interface are encouraged to defer to this method to get consistent string
     * representations across all implementations.
     *
     * @param obj Object for which to generate toString() result.
     * @return {@link String} value of data modeled by this interface.
     * @throws NullPointerException if {@code obj} is null
     */
    static String bindingToString(final org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.netconf.acm.rev180214.nacm.groups.@NonNull Group obj) {
        final MoreObjects.ToStringHelper helper = MoreObjects.toStringHelper("Group");
        CodeHelpers.appendValue(helper, "name", obj.getName());
        CodeHelpers.appendValue(helper, "userName", obj.getUserName());
        CodeHelpers.appendAugmentations(helper, "augmentation", obj);
        return helper.toString();
    }
    
    @Override
    GroupKey key();
    
    /**
     * Return name, or {@code null} if it is not present.
     *
     * <pre>
     *     <code>
     *         Group name associated with this entry.
     *     </code>
     * </pre>
     *
     * @return {@code GroupNameType} name, or {@code null} if it is not present.
     *
     */
    GroupNameType getName();
    
    /**
     * Return name, guaranteed to be non-null.
     *
     * <pre>
     *     <code>
     *         Group name associated with this entry.
     *     </code>
     * </pre>
     *
     * @return {@code GroupNameType} name, guaranteed to be non-null.
     * @throws NoSuchElementException if name is not present
     *
     */
    default @NonNull GroupNameType requireName() {
        return CodeHelpers.require(getName(), "name");
    }
    
    /**
     * Return userName, or {@code null} if it is not present.
     *
     * <pre>
     *     <code>
     *         Each entry identifies the username of a member of the group associated with this
     *         entry.
     *     </code>
     * </pre>
     *
     * @return {@code List<UserNameType>} userName, or {@code null} if it is not present.
     *
     */
    @Nullable List<UserNameType> getUserName();
    
    /**
     * Return userName, guaranteed to be non-null.
     *
     * <pre>
     *     <code>
     *         Each entry identifies the username of a member of the group associated with this
     *         entry.
     *     </code>
     * </pre>
     *
     * @return {@code List<UserNameType>} userName, guaranteed to be non-null.
     * @throws NoSuchElementException if userName is not present
     *
     */
    default @NonNull List<UserNameType> requireUserName() {
        return CodeHelpers.require(getUserName(), "username");
    }

}

