package org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.netconf.acm.rev180214.nacm.groups;
import java.lang.Class;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.processing.Generated;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.netconf.acm.rev180214.GroupNameType;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.netconf.acm.rev180214.UserNameType;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.AbstractAugmentable;
import org.opendaylight.yangtools.yang.binding.Augmentation;

/**
 * Class that builds {@link GroupBuilder} instances. Overall design of the class is that of a
 * <a href="https://en.wikipedia.org/wiki/Fluent_interface">fluent interface</a>, where method chaining is used.
 *
 * <p>
 * In general, this class is supposed to be used like this template:
 * <pre>
 *   <code>
 *     GroupBuilder createTarget(int fooXyzzy, int barBaz) {
 *         return new GroupBuilderBuilder()
 *             .setFoo(new FooBuilder().setXyzzy(fooXyzzy).build())
 *             .setBar(new BarBuilder().setBaz(barBaz).build())
 *             .build();
 *     }
 *   </code>
 * </pre>
 *
 * <p>
 * This pattern is supported by the immutable nature of GroupBuilder, as instances can be freely passed around without
 * worrying about synchronization issues.
 *
 * <p>
 * As a side note: method chaining results in:
 * <ul>
 *   <li>very efficient Java bytecode, as the method invocation result, in this case the Builder reference, is
 *       on the stack, so further method invocations just need to fill method arguments for the next method
 *       invocation, which is terminated by {@link #build()}, which is then returned from the method</li>
 *   <li>better understanding by humans, as the scope of mutable state (the builder) is kept to a minimum and is
 *       very localized</li>
 *   <li>better optimization oportunities, as the object scope is minimized in terms of invocation (rather than
 *       method) stack, making <a href="https://en.wikipedia.org/wiki/Escape_analysis">escape analysis</a> a lot
 *       easier. Given enough compiler (JIT/AOT) prowess, the cost of th builder object can be completely
 *       eliminated</li>
 * </ul>
 *
 * @see GroupBuilder
 * @see Builder
 *
 */
@Generated("mdsal-binding-generator")
public class GroupBuilder implements Builder<Group> {

    private GroupNameType _name;
    private List<UserNameType> _userName;
    private GroupKey key;


    Map<Class<? extends Augmentation<Group>>, Augmentation<Group>> augmentation = Collections.emptyMap();

    public GroupBuilder() {
    }
    
    
    

    public GroupBuilder(Group base) {
        Map<Class<? extends Augmentation<Group>>, Augmentation<Group>> aug = base.augmentations();
        if (!aug.isEmpty()) {
            this.augmentation = new HashMap<>(aug);
        }
        this.key = base.key();
        this._name = base.getName();
        this._userName = base.getUserName();
    }


    public GroupKey key() {
        return key;
    }
    
    public GroupNameType getName() {
        return _name;
    }
    
    public List<UserNameType> getUserName() {
        return _userName;
    }

    @SuppressWarnings({ "unchecked", "checkstyle:methodTypeParameterName"})
    public <E$$ extends Augmentation<Group>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$) augmentation.get(Objects.requireNonNull(augmentationType));
    }

    public GroupBuilder withKey(final GroupKey key) {
        this.key = key;
        return this;
    }
    
    public GroupBuilder setName(final GroupNameType value) {
        this._name = value;
        return this;
    }
    public GroupBuilder setUserName(final List<UserNameType> values) {
        this._userName = values;
        return this;
    }
    
    
    /**
      * Add an augmentation to this builder's product.
      *
      * @param augmentation augmentation to be added
      * @return this builder
      * @throws NullPointerException if {@code augmentation} is null
      */
    public GroupBuilder addAugmentation(Augmentation<Group> augmentation) {
        Class<? extends Augmentation<Group>> augmentationType = augmentation.implementedInterface();
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<>();
        }
    
        this.augmentation.put(augmentationType, augmentation);
        return this;
    }
    
    /**
      * Remove an augmentation from this builder's product. If this builder does not track such an augmentation
      * type, this method does nothing.
      *
      * @param augmentationType augmentation type to be removed
      * @return this builder
      */
    public GroupBuilder removeAugmentation(Class<? extends Augmentation<Group>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    @Override
    public Group build() {
        return new GroupImpl(this);
    }

    private static final class GroupImpl
        extends AbstractAugmentable<Group>
        implements Group {
    
        private final GroupNameType _name;
        private final List<UserNameType> _userName;
        private final GroupKey key;
    
        GroupImpl(GroupBuilder base) {
            super(base.augmentation);
            if (base.key() != null) {
                this.key = base.key();
            } else {
                this.key = new GroupKey(base.getName());
            }
            this._name = key.getName();
            this._userName = base.getUserName();
        }
    
        @Override
        public GroupKey key() {
            return key;
        }
        
        @Override
        public GroupNameType getName() {
            return _name;
        }
        
        @Override
        public List<UserNameType> getUserName() {
            return _userName;
        }
    
        private int hash = 0;
        private volatile boolean hashValid = false;
        
        @Override
        public int hashCode() {
            if (hashValid) {
                return hash;
            }
        
            final int result = Group.bindingHashCode(this);
            hash = result;
            hashValid = true;
            return result;
        }
    
        @Override
        public boolean equals(Object obj) {
            return Group.bindingEquals(this, obj);
        }
    
        @Override
        public String toString() {
            return Group.bindingToString(this);
        }
    }
}
