package org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.netconf.acm.rev180214.nacm.rule.list;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import java.io.Serializable;
import java.lang.Class;
import java.lang.NullPointerException;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.Arrays;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.regex.Pattern;
import javax.annotation.processing.Generated;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.netconf.acm.rev180214.$YangModuleInfoImpl;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.netconf.acm.rev180214.AccessOperationsType;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.netconf.acm.rev180214.ActionType;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.netconf.acm.rev180214.MatchallStringType;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.netconf.acm.rev180214.nacm.RuleList;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.netconf.acm.rev180214.nacm.rule.list.rule.RuleType;
import org.opendaylight.yangtools.yang.binding.Augmentable;
import org.opendaylight.yangtools.yang.binding.ChildOf;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.Identifiable;
import org.opendaylight.yangtools.yang.binding.TypeObject;
import org.opendaylight.yangtools.yang.common.QName;

/**
 * One access control rule. Rules are processed in user-defined order until a 
 * is found. A rule matches if 'module-name', 'rule-type', and 'access-operations' 
 * match the request. If a rule matches, the 'action' leaf determines whether or 
 * not access is granted.
 *
 * <p>
 * This class represents the following YANG schema fragment defined in module <b>ietf-netconf-acm</b>
 * <pre>
 * list rule {
 *   key name;
 *   ordered-by user;
 *   leaf name {
 *     type string {
 *       length 1..max;
 *     }
 *   }
 *   leaf module-name {
 *     type union {
 *       type matchall-string-type;
 *       type string;
 *     }
 *     default *;
 *   }
 *   choice rule-type {
 *     case protocol-operation {
 *       leaf rpc-name {
 *         type union {
 *           type matchall-string-type;
 *           type string;
 *         }
 *       }
 *     }
 *     case notification {
 *       leaf notification-name {
 *         type union {
 *           type matchall-string-type;
 *           type string;
 *         }
 *       }
 *     }
 *     case data-node {
 *       leaf path {
 *         type node-instance-identifier;
 *       }
 *     }
 *   }
 *   leaf access-operations {
 *     type union {
 *       type matchall-string-type;
 *       type access-operations-type;
 *     }
 *     default *;
 *   }
 *   leaf action {
 *     type action-type;
 *   }
 *   leaf comment {
 *     type string;
 *   }
 * }
 * </pre>The schema path to identify an instance is
 * <i>ietf-netconf-acmnacmrule-listrule</i>
 *
 * <p>To create instances of this class use {@link RuleBuilder}.
 * @see RuleBuilder
 * @see RuleKey
 *
 */
@Generated("mdsal-binding-generator")
public interface Rule
    extends
    ChildOf<RuleList>,
    Augmentable<Rule>,
    Identifiable<RuleKey>
{

    public static final class ModuleName
     implements TypeObject, Serializable {
        private static final long serialVersionUID = 8870372696583938773L;
        public static final List<String> PATTERN_CONSTANTS = ImmutableList.of("^(?:\\*)$");
        private static final Pattern patterns = Pattern.compile(PATTERN_CONSTANTS.get(0));
        private static final String regexes = "\\*";
        private final MatchallStringType _matchallStringType;
        private final String _string;
    
    
        public ModuleName(MatchallStringType _matchallStringType) {
            super();
            this._matchallStringType = _matchallStringType;
            this._string = null;
        }
        
        public ModuleName(String _string) {
            super();
            this._string = _string;
            this._matchallStringType = null;
        }
        /**
         * Creates a copy from Source Object.
         *
         * @param source Source object
         */
        public ModuleName(ModuleName source) {
            this._matchallStringType = source._matchallStringType;
            this._string = source._string;
        }
        
        /**
         * Return a String representing the value of this union.
         *
         * @return String representation of this union's value.
         */
        public String stringValue() {
            if (_matchallStringType != null) {
                return _matchallStringType.getValue().toString();
            }
            if (_string != null) {
                return _string;
            }
        
            throw new IllegalStateException("No value assinged");
        }
    
    
        public MatchallStringType getMatchallStringType() {
            return _matchallStringType;
        }
        
        public String getString() {
            return _string;
        }
    
    
        @Override
        public int hashCode() {
            final int prime = 31;
            int result = 1;
            result = prime * result + Objects.hashCode(_matchallStringType);
            result = prime * result + Objects.hashCode(_string);
            return result;
        }
    
        @Override
        public final boolean equals(java.lang.Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof ModuleName)) {
                return false;
            }
            final ModuleName other = (ModuleName) obj;
            if (!Objects.equals(_matchallStringType, other._matchallStringType)) {
                return false;
            }
            if (!Objects.equals(_string, other._string)) {
                return false;
            }
            return true;
        }
    
        @Override
        public String toString() {
            final MoreObjects.ToStringHelper helper = MoreObjects.toStringHelper(ModuleName.class);
            CodeHelpers.appendValue(helper, "_matchallStringType", _matchallStringType);
            CodeHelpers.appendValue(helper, "_string", _string);
            return helper.toString();
        }
    }
    
    
    public static final class AccessOperations
     implements TypeObject, Serializable {
        private static final long serialVersionUID = -5065809102053495570L;
        public static final List<String> PATTERN_CONSTANTS = ImmutableList.of("^(?:\\*)$");
        private static final Pattern patterns = Pattern.compile(PATTERN_CONSTANTS.get(0));
        private static final String regexes = "\\*";
        private final MatchallStringType _matchallStringType;
        private final AccessOperationsType _accessOperationsType;
    
    
        public AccessOperations(MatchallStringType _matchallStringType) {
            super();
            this._matchallStringType = _matchallStringType;
            this._accessOperationsType = null;
        }
        
        public AccessOperations(AccessOperationsType _accessOperationsType) {
            super();
            this._accessOperationsType = _accessOperationsType;
            this._matchallStringType = null;
        }
        /**
         * Creates a copy from Source Object.
         *
         * @param source Source object
         */
        public AccessOperations(AccessOperations source) {
            this._matchallStringType = source._matchallStringType;
            this._accessOperationsType = source._accessOperationsType;
        }
        
        /**
         * Return a String representing the value of this union.
         *
         * @return String representation of this union's value.
         */
        public String stringValue() {
            if (_matchallStringType != null) {
                return _matchallStringType.getValue().toString();
            }
            if (_accessOperationsType != null) {
                return Arrays.toString(_accessOperationsType.getValue());
            }
        
            throw new IllegalStateException("No value assinged");
        }
    
    
        public MatchallStringType getMatchallStringType() {
            return _matchallStringType;
        }
        
        public AccessOperationsType getAccessOperationsType() {
            return _accessOperationsType;
        }
    
    
        @Override
        public int hashCode() {
            final int prime = 31;
            int result = 1;
            result = prime * result + Objects.hashCode(_matchallStringType);
            result = prime * result + Objects.hashCode(_accessOperationsType);
            return result;
        }
    
        @Override
        public final boolean equals(java.lang.Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof AccessOperations)) {
                return false;
            }
            final AccessOperations other = (AccessOperations) obj;
            if (!Objects.equals(_matchallStringType, other._matchallStringType)) {
                return false;
            }
            if (!Objects.equals(_accessOperationsType, other._accessOperationsType)) {
                return false;
            }
            return true;
        }
    
        @Override
        public String toString() {
            final MoreObjects.ToStringHelper helper = MoreObjects.toStringHelper(AccessOperations.class);
            CodeHelpers.appendValue(helper, "_matchallStringType", _matchallStringType);
            CodeHelpers.appendValue(helper, "_accessOperationsType", _accessOperationsType);
            return helper.toString();
        }
    }
    


    public static final @NonNull QName QNAME = $YangModuleInfoImpl.qnameOf("rule");

    @Override
    default Class<org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.netconf.acm.rev180214.nacm.rule.list.Rule> implementedInterface() {
        return org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.netconf.acm.rev180214.nacm.rule.list.Rule.class;
    }
    
    /**
     * Default implementation of {@link Object#hashCode()} contract for this interface.
     * Implementations of this interface are encouraged to defer to this method to get consistent hashing
     * results across all implementations.
     *
     * @param obj Object for which to generate hashCode() result.
     * @return Hash code value of data modeled by this interface.
     * @throws NullPointerException if {@code obj} is null
     */
    static int bindingHashCode(final org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.netconf.acm.rev180214.nacm.rule.list.@NonNull Rule obj) {
        final int prime = 31;
        int result = 1;
        result = prime * result + Objects.hashCode(obj.getAccessOperations());
        result = prime * result + Objects.hashCode(obj.getAction());
        result = prime * result + Objects.hashCode(obj.getComment());
        result = prime * result + Objects.hashCode(obj.getModuleName());
        result = prime * result + Objects.hashCode(obj.getName());
        result = prime * result + Objects.hashCode(obj.getRuleType());
        for (var augmentation : obj.augmentations().values()) {
            result += augmentation.hashCode();
        }
        return result;
    }
    
    /**
     * Default implementation of {@link Object#equals(Object)} contract for this interface.
     * Implementations of this interface are encouraged to defer to this method to get consistent equality
     * results across all implementations.
     *
     * @param thisObj Object acting as the receiver of equals invocation
     * @param obj Object acting as argument to equals invocation
     * @return True if thisObj and obj are considered equal
     * @throws NullPointerException if {@code thisObj} is null
     */
    static boolean bindingEquals(final org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.netconf.acm.rev180214.nacm.rule.list.@NonNull Rule thisObj, final Object obj) {
        if (thisObj == obj) {
            return true;
        }
        final org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.netconf.acm.rev180214.nacm.rule.list.Rule other = CodeHelpers.checkCast(org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.netconf.acm.rev180214.nacm.rule.list.Rule.class, obj);
        if (other == null) {
            return false;
        }
        if (!Objects.equals(thisObj.getComment(), other.getComment())) {
            return false;
        }
        if (!Objects.equals(thisObj.getName(), other.getName())) {
            return false;
        }
        if (!Objects.equals(thisObj.getAccessOperations(), other.getAccessOperations())) {
            return false;
        }
        if (!Objects.equals(thisObj.getAction(), other.getAction())) {
            return false;
        }
        if (!Objects.equals(thisObj.getModuleName(), other.getModuleName())) {
            return false;
        }
        if (!Objects.equals(thisObj.getRuleType(), other.getRuleType())) {
            return false;
        }
        return thisObj.augmentations().equals(other.augmentations());
    }
    
    /**
     * Default implementation of {@link Object#toString()} contract for this interface.
     * Implementations of this interface are encouraged to defer to this method to get consistent string
     * representations across all implementations.
     *
     * @param obj Object for which to generate toString() result.
     * @return {@link String} value of data modeled by this interface.
     * @throws NullPointerException if {@code obj} is null
     */
    static String bindingToString(final org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.netconf.acm.rev180214.nacm.rule.list.@NonNull Rule obj) {
        final MoreObjects.ToStringHelper helper = MoreObjects.toStringHelper("Rule");
        CodeHelpers.appendValue(helper, "accessOperations", obj.getAccessOperations());
        CodeHelpers.appendValue(helper, "action", obj.getAction());
        CodeHelpers.appendValue(helper, "comment", obj.getComment());
        CodeHelpers.appendValue(helper, "moduleName", obj.getModuleName());
        CodeHelpers.appendValue(helper, "name", obj.getName());
        CodeHelpers.appendValue(helper, "ruleType", obj.getRuleType());
        CodeHelpers.appendAugmentations(helper, "augmentation", obj);
        return helper.toString();
    }
    
    @Override
    RuleKey key();
    
    /**
     * Return name, or {@code null} if it is not present.
     *
     * <pre>
     *     <code>
     *         Arbitrary name assigned to the rule.
     *     </code>
     * </pre>
     *
     * @return {@code String} name, or {@code null} if it is not present.
     *
     */
    String getName();
    
    /**
     * Return name, guaranteed to be non-null.
     *
     * <pre>
     *     <code>
     *         Arbitrary name assigned to the rule.
     *     </code>
     * </pre>
     *
     * @return {@code String} name, guaranteed to be non-null.
     * @throws NoSuchElementException if name is not present
     *
     */
    default @NonNull String requireName() {
        return CodeHelpers.require(getName(), "name");
    }
    
    /**
     * Return moduleName, or {@code null} if it is not present.
     *
     * <pre>
     *     <code>
     *         Name of the module associated with this rule. This leaf matches if it has the
     *         value '*' or if the object being accessed is defined in the module with the
     *         specified module name.
     *     </code>
     * </pre>
     *
     * @return {@code ModuleName} moduleName, or {@code null} if it is not present.
     *
     */
    ModuleName getModuleName();
    
    /**
     * Return moduleName, guaranteed to be non-null.
     *
     * <pre>
     *     <code>
     *         Name of the module associated with this rule. This leaf matches if it has the
     *         value '*' or if the object being accessed is defined in the module with the
     *         specified module name.
     *     </code>
     * </pre>
     *
     * @return {@code ModuleName} moduleName, guaranteed to be non-null.
     * @throws NoSuchElementException if moduleName is not present
     *
     */
    default @NonNull ModuleName requireModuleName() {
        return CodeHelpers.require(getModuleName(), "modulename");
    }
    
    /**
     * Return ruleType, or {@code null} if it is not present.
     *
     * <pre>
     *     <code>
     *         This choice matches if all leafs present in the rule match the request. If no
     *         leafs are present, the choice matches all requests.
     *     </code>
     * </pre>
     *
     * @return {@code RuleType} ruleType, or {@code null} if it is not present.
     *
     */
    RuleType getRuleType();
    
    /**
     * Return accessOperations, or {@code null} if it is not present.
     *
     * <pre>
     *     <code>
     *         Access operations associated with this rule. This leaf matches if it has the
     *         value '*' or if the bit corresponding to the requested operation is set.
     *     </code>
     * </pre>
     *
     * @return {@code AccessOperations} accessOperations, or {@code null} if it is not present.
     *
     */
    AccessOperations getAccessOperations();
    
    /**
     * Return accessOperations, guaranteed to be non-null.
     *
     * <pre>
     *     <code>
     *         Access operations associated with this rule. This leaf matches if it has the
     *         value '*' or if the bit corresponding to the requested operation is set.
     *     </code>
     * </pre>
     *
     * @return {@code AccessOperations} accessOperations, guaranteed to be non-null.
     * @throws NoSuchElementException if accessOperations is not present
     *
     */
    default @NonNull AccessOperations requireAccessOperations() {
        return CodeHelpers.require(getAccessOperations(), "accessoperations");
    }
    
    /**
     * Return action, or {@code null} if it is not present.
     *
     * <pre>
     *     <code>
     *         The access control action associated with the rule. If a rule has been
     *         determined to match a particular request, then this object is used to determine
     *         whether to permit or deny the request.
     *     </code>
     * </pre>
     *
     * @return {@code ActionType} action, or {@code null} if it is not present.
     *
     */
    ActionType getAction();
    
    /**
     * Return action, guaranteed to be non-null.
     *
     * <pre>
     *     <code>
     *         The access control action associated with the rule. If a rule has been
     *         determined to match a particular request, then this object is used to determine
     *         whether to permit or deny the request.
     *     </code>
     * </pre>
     *
     * @return {@code ActionType} action, guaranteed to be non-null.
     * @throws NoSuchElementException if action is not present
     *
     */
    default @NonNull ActionType requireAction() {
        return CodeHelpers.require(getAction(), "action");
    }
    
    /**
     * Return comment, or {@code null} if it is not present.
     *
     * <pre>
     *     <code>
     *         A textual description of the access rule.
     *     </code>
     * </pre>
     *
     * @return {@code String} comment, or {@code null} if it is not present.
     *
     */
    String getComment();
    
    /**
     * Return comment, guaranteed to be non-null.
     *
     * <pre>
     *     <code>
     *         A textual description of the access rule.
     *     </code>
     * </pre>
     *
     * @return {@code String} comment, guaranteed to be non-null.
     * @throws NoSuchElementException if comment is not present
     *
     */
    default @NonNull String requireComment() {
        return CodeHelpers.require(getComment(), "comment");
    }

}

