package org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.netconf.acm.rev180214.nacm.rule.list;
import java.lang.Class;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import javax.annotation.processing.Generated;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.netconf.acm.rev180214.ActionType;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.netconf.acm.rev180214.nacm.rule.list.rule.RuleType;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.AbstractAugmentable;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;

/**
 * Class that builds {@link RuleBuilder} instances. Overall design of the class is that of a
 * <a href="https://en.wikipedia.org/wiki/Fluent_interface">fluent interface</a>, where method chaining is used.
 *
 * <p>
 * In general, this class is supposed to be used like this template:
 * <pre>
 *   <code>
 *     RuleBuilder createTarget(int fooXyzzy, int barBaz) {
 *         return new RuleBuilderBuilder()
 *             .setFoo(new FooBuilder().setXyzzy(fooXyzzy).build())
 *             .setBar(new BarBuilder().setBaz(barBaz).build())
 *             .build();
 *     }
 *   </code>
 * </pre>
 *
 * <p>
 * This pattern is supported by the immutable nature of RuleBuilder, as instances can be freely passed around without
 * worrying about synchronization issues.
 *
 * <p>
 * As a side note: method chaining results in:
 * <ul>
 *   <li>very efficient Java bytecode, as the method invocation result, in this case the Builder reference, is
 *       on the stack, so further method invocations just need to fill method arguments for the next method
 *       invocation, which is terminated by {@link #build()}, which is then returned from the method</li>
 *   <li>better understanding by humans, as the scope of mutable state (the builder) is kept to a minimum and is
 *       very localized</li>
 *   <li>better optimization oportunities, as the object scope is minimized in terms of invocation (rather than
 *       method) stack, making <a href="https://en.wikipedia.org/wiki/Escape_analysis">escape analysis</a> a lot
 *       easier. Given enough compiler (JIT/AOT) prowess, the cost of th builder object can be completely
 *       eliminated</li>
 * </ul>
 *
 * @see RuleBuilder
 * @see Builder
 *
 */
@Generated("mdsal-binding-generator")
public class RuleBuilder implements Builder<Rule> {

    private Rule.AccessOperations _accessOperations;
    private ActionType _action;
    private String _comment;
    private Rule.ModuleName _moduleName;
    private String _name;
    private RuleType _ruleType;
    private RuleKey key;


    Map<Class<? extends Augmentation<Rule>>, Augmentation<Rule>> augmentation = Collections.emptyMap();

    public RuleBuilder() {
    }
    
    
    

    public RuleBuilder(Rule base) {
        Map<Class<? extends Augmentation<Rule>>, Augmentation<Rule>> aug = base.augmentations();
        if (!aug.isEmpty()) {
            this.augmentation = new HashMap<>(aug);
        }
        this.key = base.key();
        this._name = base.getName();
        this._accessOperations = base.getAccessOperations();
        this._action = base.getAction();
        this._comment = base.getComment();
        this._moduleName = base.getModuleName();
        this._ruleType = base.getRuleType();
    }


    public RuleKey key() {
        return key;
    }
    
    public Rule.AccessOperations getAccessOperations() {
        return _accessOperations;
    }
    
    public ActionType getAction() {
        return _action;
    }
    
    public String getComment() {
        return _comment;
    }
    
    public Rule.ModuleName getModuleName() {
        return _moduleName;
    }
    
    public String getName() {
        return _name;
    }
    
    public RuleType getRuleType() {
        return _ruleType;
    }

    @SuppressWarnings({ "unchecked", "checkstyle:methodTypeParameterName"})
    public <E$$ extends Augmentation<Rule>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$) augmentation.get(Objects.requireNonNull(augmentationType));
    }

    public RuleBuilder withKey(final RuleKey key) {
        this.key = key;
        return this;
    }
    
    public RuleBuilder setAccessOperations(final Rule.AccessOperations value) {
        this._accessOperations = value;
        return this;
    }
    
    public RuleBuilder setAction(final ActionType value) {
        this._action = value;
        return this;
    }
    
    public RuleBuilder setComment(final String value) {
        this._comment = value;
        return this;
    }
    
    public RuleBuilder setModuleName(final Rule.ModuleName value) {
        this._moduleName = value;
        return this;
    }
    
    private static void check_nameLength(final String value) {
        final int length = value.codePointCount(0, value.length());
        if (length >= 1) {
            return;
        }
        CodeHelpers.throwInvalidLength("[[1..2147483647]]", value);
    }
    
    public RuleBuilder setName(final String value) {
        if (value != null) {
            check_nameLength(value);
            
        }
        this._name = value;
        return this;
    }
    
    public RuleBuilder setRuleType(final RuleType value) {
        this._ruleType = value;
        return this;
    }
    
    /**
      * Add an augmentation to this builder's product.
      *
      * @param augmentation augmentation to be added
      * @return this builder
      * @throws NullPointerException if {@code augmentation} is null
      */
    public RuleBuilder addAugmentation(Augmentation<Rule> augmentation) {
        Class<? extends Augmentation<Rule>> augmentationType = augmentation.implementedInterface();
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<>();
        }
    
        this.augmentation.put(augmentationType, augmentation);
        return this;
    }
    
    /**
      * Remove an augmentation from this builder's product. If this builder does not track such an augmentation
      * type, this method does nothing.
      *
      * @param augmentationType augmentation type to be removed
      * @return this builder
      */
    public RuleBuilder removeAugmentation(Class<? extends Augmentation<Rule>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    @Override
    public Rule build() {
        return new RuleImpl(this);
    }

    private static final class RuleImpl
        extends AbstractAugmentable<Rule>
        implements Rule {
    
        private final Rule.AccessOperations _accessOperations;
        private final ActionType _action;
        private final String _comment;
        private final Rule.ModuleName _moduleName;
        private final String _name;
        private final RuleType _ruleType;
        private final RuleKey key;
    
        RuleImpl(RuleBuilder base) {
            super(base.augmentation);
            if (base.key() != null) {
                this.key = base.key();
            } else {
                this.key = new RuleKey(base.getName());
            }
            this._name = key.getName();
            this._accessOperations = base.getAccessOperations();
            this._action = base.getAction();
            this._comment = base.getComment();
            this._moduleName = base.getModuleName();
            this._ruleType = base.getRuleType();
        }
    
        @Override
        public RuleKey key() {
            return key;
        }
        
        @Override
        public Rule.AccessOperations getAccessOperations() {
            return _accessOperations;
        }
        
        @Override
        public ActionType getAction() {
            return _action;
        }
        
        @Override
        public String getComment() {
            return _comment;
        }
        
        @Override
        public Rule.ModuleName getModuleName() {
            return _moduleName;
        }
        
        @Override
        public String getName() {
            return _name;
        }
        
        @Override
        public RuleType getRuleType() {
            return _ruleType;
        }
    
        private int hash = 0;
        private volatile boolean hashValid = false;
        
        @Override
        public int hashCode() {
            if (hashValid) {
                return hash;
            }
        
            final int result = Rule.bindingHashCode(this);
            hash = result;
            hashValid = true;
            return result;
        }
    
        @Override
        public boolean equals(Object obj) {
            return Rule.bindingEquals(this, obj);
        }
    
        @Override
        public String toString() {
            return Rule.bindingToString(this);
        }
    }
}
