package org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.netconf.acm.rev180214.nacm.rule.list.rule.rule.type;
import com.google.common.base.MoreObjects;
import java.lang.Class;
import java.lang.NullPointerException;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.NoSuchElementException;
import java.util.Objects;
import javax.annotation.processing.Generated;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.netconf.acm.rev180214.$YangModuleInfoImpl;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.netconf.acm.rev180214.NodeInstanceIdentifier;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.netconf.acm.rev180214.nacm.rule.list.rule.RuleType;
import org.opendaylight.yangtools.yang.binding.Augmentable;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.yang.common.QName;

/**
 *
 * <p>
 * This class represents the following YANG schema fragment defined in module <b>ietf-netconf-acm</b>
 * <pre>
 * case data-node {
 *   leaf path {
 *     type node-instance-identifier;
 *   }
 * }
 * </pre>The schema path to identify an instance is
 * <i>ietf-netconf-acmnacmrule-listrulerule-typedata-node</i>
 *
 */
@Generated("mdsal-binding-generator")
public interface DataNode
    extends
    DataObject,
    RuleType,
    Augmentable<DataNode>
{



    public static final @NonNull QName QNAME = $YangModuleInfoImpl.qnameOf("data-node");

    @Override
    default Class<org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.netconf.acm.rev180214.nacm.rule.list.rule.rule.type.DataNode> implementedInterface() {
        return org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.netconf.acm.rev180214.nacm.rule.list.rule.rule.type.DataNode.class;
    }
    
    /**
     * Default implementation of {@link Object#hashCode()} contract for this interface.
     * Implementations of this interface are encouraged to defer to this method to get consistent hashing
     * results across all implementations.
     *
     * @param obj Object for which to generate hashCode() result.
     * @return Hash code value of data modeled by this interface.
     * @throws NullPointerException if {@code obj} is null
     */
    static int bindingHashCode(final org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.netconf.acm.rev180214.nacm.rule.list.rule.rule.type.@NonNull DataNode obj) {
        final int prime = 31;
        int result = 1;
        result = prime * result + Objects.hashCode(obj.getPath());
        for (var augmentation : obj.augmentations().values()) {
            result += augmentation.hashCode();
        }
        return result;
    }
    
    /**
     * Default implementation of {@link Object#equals(Object)} contract for this interface.
     * Implementations of this interface are encouraged to defer to this method to get consistent equality
     * results across all implementations.
     *
     * @param thisObj Object acting as the receiver of equals invocation
     * @param obj Object acting as argument to equals invocation
     * @return True if thisObj and obj are considered equal
     * @throws NullPointerException if {@code thisObj} is null
     */
    static boolean bindingEquals(final org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.netconf.acm.rev180214.nacm.rule.list.rule.rule.type.@NonNull DataNode thisObj, final Object obj) {
        if (thisObj == obj) {
            return true;
        }
        final org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.netconf.acm.rev180214.nacm.rule.list.rule.rule.type.DataNode other = CodeHelpers.checkCast(org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.netconf.acm.rev180214.nacm.rule.list.rule.rule.type.DataNode.class, obj);
        if (other == null) {
            return false;
        }
        if (!Objects.equals(thisObj.getPath(), other.getPath())) {
            return false;
        }
        return thisObj.augmentations().equals(other.augmentations());
    }
    
    /**
     * Default implementation of {@link Object#toString()} contract for this interface.
     * Implementations of this interface are encouraged to defer to this method to get consistent string
     * representations across all implementations.
     *
     * @param obj Object for which to generate toString() result.
     * @return {@link String} value of data modeled by this interface.
     * @throws NullPointerException if {@code obj} is null
     */
    static String bindingToString(final org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.netconf.acm.rev180214.nacm.rule.list.rule.rule.type.@NonNull DataNode obj) {
        final MoreObjects.ToStringHelper helper = MoreObjects.toStringHelper("DataNode");
        CodeHelpers.appendValue(helper, "path", obj.getPath());
        CodeHelpers.appendAugmentations(helper, "augmentation", obj);
        return helper.toString();
    }
    
    /**
     * Return path, or {@code null} if it is not present.
     *
     * <pre>
     *     <code>
     *         Data node instance-identifier associated with the data node, action, or
     *         notification controlled by this rule. Configuration data or state data
     *         instance-identifiers start with a top-level data node. A complete
     *         instance-identifier is required for this type of path value. The special value
     *         '/' refers to all possible datastore contents.
     *     </code>
     * </pre>
     *
     * @return {@code NodeInstanceIdentifier} path, or {@code null} if it is not present.
     *
     */
    NodeInstanceIdentifier getPath();
    
    /**
     * Return path, guaranteed to be non-null.
     *
     * <pre>
     *     <code>
     *         Data node instance-identifier associated with the data node, action, or
     *         notification controlled by this rule. Configuration data or state data
     *         instance-identifiers start with a top-level data node. A complete
     *         instance-identifier is required for this type of path value. The special value
     *         '/' refers to all possible datastore contents.
     *     </code>
     * </pre>
     *
     * @return {@code NodeInstanceIdentifier} path, guaranteed to be non-null.
     * @throws NoSuchElementException if path is not present
     *
     */
    default @NonNull NodeInstanceIdentifier requirePath() {
        return CodeHelpers.require(getPath(), "path");
    }

}

