package org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.netconf.acm.rev180214.nacm.rule.list.rule.rule.type;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import java.io.Serializable;
import java.lang.Class;
import java.lang.NullPointerException;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.regex.Pattern;
import javax.annotation.processing.Generated;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.netconf.acm.rev180214.$YangModuleInfoImpl;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.netconf.acm.rev180214.MatchallStringType;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.netconf.acm.rev180214.nacm.rule.list.rule.RuleType;
import org.opendaylight.yangtools.yang.binding.Augmentable;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.yang.binding.TypeObject;
import org.opendaylight.yangtools.yang.common.QName;

/**
 *
 * <p>
 * This class represents the following YANG schema fragment defined in module <b>ietf-netconf-acm</b>
 * <pre>
 * case protocol-operation {
 *   leaf rpc-name {
 *     type union {
 *       type matchall-string-type;
 *       type string;
 *     }
 *   }
 * }
 * </pre>The schema path to identify an instance is
 * <i>ietf-netconf-acmnacmrule-listrulerule-typeprotocol-operation</i>
 *
 */
@Generated("mdsal-binding-generator")
public interface ProtocolOperation
    extends
    DataObject,
    RuleType,
    Augmentable<ProtocolOperation>
{

    public static final class RpcName
     implements TypeObject, Serializable {
        private static final long serialVersionUID = 3381435459935972547L;
        public static final List<String> PATTERN_CONSTANTS = ImmutableList.of("^(?:\\*)$");
        private static final Pattern patterns = Pattern.compile(PATTERN_CONSTANTS.get(0));
        private static final String regexes = "\\*";
        private final MatchallStringType _matchallStringType;
        private final String _string;
    
    
        public RpcName(MatchallStringType _matchallStringType) {
            super();
            this._matchallStringType = _matchallStringType;
            this._string = null;
        }
        
        public RpcName(String _string) {
            super();
            this._string = _string;
            this._matchallStringType = null;
        }
        /**
         * Creates a copy from Source Object.
         *
         * @param source Source object
         */
        public RpcName(RpcName source) {
            this._matchallStringType = source._matchallStringType;
            this._string = source._string;
        }
        
        /**
         * Return a String representing the value of this union.
         *
         * @return String representation of this union's value.
         */
        public String stringValue() {
            if (_matchallStringType != null) {
                return _matchallStringType.getValue().toString();
            }
            if (_string != null) {
                return _string;
            }
        
            throw new IllegalStateException("No value assinged");
        }
    
    
        public MatchallStringType getMatchallStringType() {
            return _matchallStringType;
        }
        
        public String getString() {
            return _string;
        }
    
    
        @Override
        public int hashCode() {
            final int prime = 31;
            int result = 1;
            result = prime * result + Objects.hashCode(_matchallStringType);
            result = prime * result + Objects.hashCode(_string);
            return result;
        }
    
        @Override
        public final boolean equals(java.lang.Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof RpcName)) {
                return false;
            }
            final RpcName other = (RpcName) obj;
            if (!Objects.equals(_matchallStringType, other._matchallStringType)) {
                return false;
            }
            if (!Objects.equals(_string, other._string)) {
                return false;
            }
            return true;
        }
    
        @Override
        public String toString() {
            final MoreObjects.ToStringHelper helper = MoreObjects.toStringHelper(RpcName.class);
            CodeHelpers.appendValue(helper, "_matchallStringType", _matchallStringType);
            CodeHelpers.appendValue(helper, "_string", _string);
            return helper.toString();
        }
    }
    


    public static final @NonNull QName QNAME = $YangModuleInfoImpl.qnameOf("protocol-operation");

    @Override
    default Class<org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.netconf.acm.rev180214.nacm.rule.list.rule.rule.type.ProtocolOperation> implementedInterface() {
        return org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.netconf.acm.rev180214.nacm.rule.list.rule.rule.type.ProtocolOperation.class;
    }
    
    /**
     * Default implementation of {@link Object#hashCode()} contract for this interface.
     * Implementations of this interface are encouraged to defer to this method to get consistent hashing
     * results across all implementations.
     *
     * @param obj Object for which to generate hashCode() result.
     * @return Hash code value of data modeled by this interface.
     * @throws NullPointerException if {@code obj} is null
     */
    static int bindingHashCode(final org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.netconf.acm.rev180214.nacm.rule.list.rule.rule.type.@NonNull ProtocolOperation obj) {
        final int prime = 31;
        int result = 1;
        result = prime * result + Objects.hashCode(obj.getRpcName());
        for (var augmentation : obj.augmentations().values()) {
            result += augmentation.hashCode();
        }
        return result;
    }
    
    /**
     * Default implementation of {@link Object#equals(Object)} contract for this interface.
     * Implementations of this interface are encouraged to defer to this method to get consistent equality
     * results across all implementations.
     *
     * @param thisObj Object acting as the receiver of equals invocation
     * @param obj Object acting as argument to equals invocation
     * @return True if thisObj and obj are considered equal
     * @throws NullPointerException if {@code thisObj} is null
     */
    static boolean bindingEquals(final org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.netconf.acm.rev180214.nacm.rule.list.rule.rule.type.@NonNull ProtocolOperation thisObj, final Object obj) {
        if (thisObj == obj) {
            return true;
        }
        final org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.netconf.acm.rev180214.nacm.rule.list.rule.rule.type.ProtocolOperation other = CodeHelpers.checkCast(org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.netconf.acm.rev180214.nacm.rule.list.rule.rule.type.ProtocolOperation.class, obj);
        if (other == null) {
            return false;
        }
        if (!Objects.equals(thisObj.getRpcName(), other.getRpcName())) {
            return false;
        }
        return thisObj.augmentations().equals(other.augmentations());
    }
    
    /**
     * Default implementation of {@link Object#toString()} contract for this interface.
     * Implementations of this interface are encouraged to defer to this method to get consistent string
     * representations across all implementations.
     *
     * @param obj Object for which to generate toString() result.
     * @return {@link String} value of data modeled by this interface.
     * @throws NullPointerException if {@code obj} is null
     */
    static String bindingToString(final org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.netconf.acm.rev180214.nacm.rule.list.rule.rule.type.@NonNull ProtocolOperation obj) {
        final MoreObjects.ToStringHelper helper = MoreObjects.toStringHelper("ProtocolOperation");
        CodeHelpers.appendValue(helper, "rpcName", obj.getRpcName());
        CodeHelpers.appendAugmentations(helper, "augmentation", obj);
        return helper.toString();
    }
    
    /**
     * Return rpcName, or {@code null} if it is not present.
     *
     * <pre>
     *     <code>
     *         This leaf matches if it has the value '*' or if its value equals the requested
     *         protocol operation name.
     *     </code>
     * </pre>
     *
     * @return {@code RpcName} rpcName, or {@code null} if it is not present.
     *
     */
    RpcName getRpcName();
    
    /**
     * Return rpcName, guaranteed to be non-null.
     *
     * <pre>
     *     <code>
     *         This leaf matches if it has the value '*' or if its value equals the requested
     *         protocol operation name.
     *     </code>
     * </pre>
     *
     * @return {@code RpcName} rpcName, guaranteed to be non-null.
     * @throws NoSuchElementException if rpcName is not present
     *
     */
    default @NonNull RpcName requireRpcName() {
        return CodeHelpers.require(getRpcName(), "rpcname");
    }

}

