package org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.netconf.notification._1._0.rev080714;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.yang.types.rev130715.DateAndTime;
import org.opendaylight.yangtools.yang.binding.Augmentable;

/**
 *
 * <p>
 * This class represents the following YANG schema fragment defined in module <b>notifications</b>
 * <pre>
 * container input {
 *     leaf stream {
 *         type stream;
 *     }
 *     anyxml filter;
 *     leaf startTime {
 *         type date-and-time;
 *     }
 *     leaf stopTime {
 *         type date-and-time;
 *     }
 * }
 * </pre>The schema path to identify an instance is
 * <i>notifications/create-subscription/input</i>
 *
 * <p>To create instances of this class use {@link CreateSubscriptionInputBuilder}.
 * @see CreateSubscriptionInputBuilder
 *
 */
public interface CreateSubscriptionInput
    extends
    DataObject,
    Augmentable<org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.netconf.notification._1._0.rev080714.CreateSubscriptionInput>
{



    public static final QName QNAME = org.opendaylight.yangtools.yang.common.QName.create("urn:ietf:params:xml:ns:netconf:notification:1.0",
        "2008-07-14", "input").intern();

    /**
     * An optional parameter that indicates which stream of eventsis of interest. If 
     * not present, then events in the defaultNETCONF stream will be sent.
     *
     *
     *
     * @return <code>org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.netconf.notification._1._0.rev080714.StreamNameType</code> <code>stream</code>, or <code>null</code> if not present
     */
    StreamNameType getStream();
    
    /**
     * A parameter used to trigger the replay feature andindicates that the replay 
     * should start at the timespecified. If start time is not present, this is not 
     * areplay subscription.
     *
     *
     *
     * @return <code>org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.yang.types.rev130715.DateAndTime</code> <code>startTime</code>, or <code>null</code> if not present
     */
    DateAndTime getStartTime();
    
    /**
     * An optional parameter used with the optional replayfeature to indicate the 
     * newest notifications ofinterest. If stop time is not present, the 
     * notificationswill continue until the subscription is terminated.Must be used 
     * with startTime.
     *
     *
     *
     * @return <code>org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.yang.types.rev130715.DateAndTime</code> <code>stopTime</code>, or <code>null</code> if not present
     */
    DateAndTime getStopTime();

}

