package org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.netconf.notification._1._0.rev080714;
import javax.annotation.CheckReturnValue;
import org.opendaylight.yangtools.yang.binding.RpcService;
import org.opendaylight.yangtools.yang.common.RpcResult;
import java.util.concurrent.Future;

/**
 * Interface for implementing the following YANG RPCs defined in module <b>notifications</b>
 * <pre>
 * rpc create-subscription {
 *     "The command to create a notification subscription. It
 *     takes as argument the name of the notification stream
 *     and filter. Both of those options limit the content of
 *     the subscription. In addition, there are two time-related
 *     parameters, startTime and stopTime, which can be used to
 *     select the time interval of interest to the notification
 *     replay feature.";
 *     input {
 *         leaf stream {
 *             type stream;
 *         }
 *         anyxml filter;
 *         leaf startTime {
 *             type date-and-time;
 *         }
 *         leaf stopTime {
 *             type date-and-time;
 *         }
 *     }
 *     
 *     output {
 *     }
 * }
 * </pre>
 *
 */
public interface NotificationsService
    extends
    RpcService
{




    /**
     * The command to create a notification subscription. Ittakes as argument the name 
     * of the notification streamand filter. Both of those options limit the content 
     * ofthe subscription. In addition, there are two time-relatedparameters, startTime
     * and stopTime, which can be used toselect the time interval of interest to the 
     * notificationreplay feature.
     *
     */
    @CheckReturnValue
    Future<RpcResult<java.lang.Void>> createSubscription(CreateSubscriptionInput input);

}

