package org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.netmod.notification.rev080714;
import org.opendaylight.yangtools.yang.binding.DataRoot;

/**
 * Conversion of the 'manageEvent' XSD in the NETCONFNotifications RFC.
 *
 * <p>
 * This class represents the following YANG schema fragment defined in module <b>nc-notifications</b>
 * <pre>
 * module nc-notifications {
 *     yang-version 1;
 *     namespace "urn:ietf:params:xml:ns:netmod:notification";
 *     prefix "manageEvent";
 *
 *     import ietf-yang-types { prefix "yang"; }
 *     
 *     import notifications { prefix "ncEvent"; }
 *     revision 2008-07-14 {
 *         description "Conversion of the 'manageEvent' XSD in the NETCONFNotifications RFC.
 *         ";
 *     }
 *
 *     container netconf {
 *         container streams {
 *             list stream {
 *                 key "name";
 *                 leaf name {
 *                     type streamNameType;
 *                 }
 *                 leaf description {
 *                     type string;
 *                 }
 *                 leaf replaySupport {
 *                     type boolean;
 *                 }
 *                 leaf replayLogCreationTime {
 *                     type date-and-time;
 *                 }
 *             }
 *         }
 *     }
 *
 *     notification replayComplete {
 *         description
 *             "This notification is sent to signal the end of a replay
 *             portion of a subscription.";
 *     }
 *     notification notificationComplete {
 *         description
 *             "This notification is sent to signal the end of a notification
 *             subscription. It is sent in the case that stopTime was
 *             specified during the creation of the subscription..";
 *     }
 * }
 * </pre>
 *
 */
public interface NcNotificationsData
    extends
    DataRoot
{




    /**
     * Top-level element in the notification namespace
     *
     *
     *
     * @return <code>org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.netmod.notification.rev080714.Netconf</code> <code>netconf</code>, or <code>null</code> if not present
     */
    Netconf getNetconf();

}

