package org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.netmod.notification.rev080714;
import org.opendaylight.yangtools.yang.binding.NotificationListener;

/**
 * Interface for implementing the following YANG notifications defined in module <b>nc-notifications</b>
 * <pre>
 * notification replayComplete {
 *     description
 *         "This notification is sent to signal the end of a replay
 *         portion of a subscription.";
 * }
 * notification notificationComplete {
 *     description
 *         "This notification is sent to signal the end of a notification
 *         subscription. It is sent in the case that stopTime was
 *         specified during the creation of the subscription..";
 * }
 * </pre>
 *
 */
public interface NcNotificationsListener
    extends
    NotificationListener
{




    /**
     * This notification is sent to signal the end of a replayportion of a 
     * subscription.
     *
     */
    void onReplayComplete(ReplayComplete notification);
    
    /**
     * This notification is sent to signal the end of a notificationsubscription. It is
     * sent in the case that stopTime wasspecified during the creation of the 
     * subscription..
     *
     */
    void onNotificationComplete(NotificationComplete notification);

}

