package org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.netmod.notification.rev080714;
import org.opendaylight.yangtools.yang.binding.ChildOf;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.binding.Augmentable;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.netmod.notification.rev080714.netconf.Streams;

/**
 * Top-level element in the notification namespace
 *
 * <p>
 * This class represents the following YANG schema fragment defined in module <b>nc-notifications</b>
 * <pre>
 * container netconf {
 *     container streams {
 *         list stream {
 *             key "name";
 *             leaf name {
 *                 type streamNameType;
 *             }
 *             leaf description {
 *                 type string;
 *             }
 *             leaf replaySupport {
 *                 type boolean;
 *             }
 *             leaf replayLogCreationTime {
 *                 type date-and-time;
 *             }
 *         }
 *     }
 * }
 * </pre>The schema path to identify an instance is
 * <i>nc-notifications/netconf</i>
 *
 * <p>To create instances of this class use {@link NetconfBuilder}.
 * @see NetconfBuilder
 *
 */
public interface Netconf
    extends
    ChildOf<NcNotificationsData>,
    Augmentable<org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.netmod.notification.rev080714.Netconf>
{



    public static final QName QNAME = org.opendaylight.yangtools.yang.common.QName.create("urn:ietf:params:xml:ns:netmod:notification",
        "2008-07-14", "netconf").intern();

    /**
     * The list of event streams supported by the system. Whena query is issued, the 
     * returned set of streams isdetermined based on user privileges.
     *
     *
     *
     * @return <code>org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.netmod.notification.rev080714.netconf.Streams</code> <code>streams</code>, or <code>null</code> if not present
     */
    Streams getStreams();

}

