package org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.netmod.notification.rev080714;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.binding.Augmentable;
import org.opendaylight.yangtools.yang.binding.Notification;

/**
 * This notification is sent to signal the end of a notificationsubscription. It 
 * sent in the case that stopTime wasspecified during the creation of the 
 * subscription..
 *
 * <p>
 * This class represents the following YANG schema fragment defined in module <b>nc-notifications</b>
 * <pre>
 * notification notificationComplete {
 *     description
 *         "This notification is sent to signal the end of a notification
 *         subscription. It is sent in the case that stopTime was
 *         specified during the creation of the subscription..";
 * }
 * </pre>The schema path to identify an instance is
 * <i>nc-notifications/notificationComplete</i>
 *
 * <p>To create instances of this class use {@link NotificationCompleteBuilder}.
 * @see NotificationCompleteBuilder
 *
 */
public interface NotificationComplete
    extends
    DataObject,
    Augmentable<org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.netmod.notification.rev080714.NotificationComplete>,
    Notification
{



    public static final QName QNAME = org.opendaylight.yangtools.yang.common.QName.create("urn:ietf:params:xml:ns:netmod:notification",
        "2008-07-14", "notificationComplete").intern();


}

