package org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.netmod.notification.rev080714;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.binding.Augmentable;
import org.opendaylight.yangtools.yang.binding.Notification;

/**
 * This notification is sent to signal the end of a replayportion of a 
 * subscription.
 *
 * <p>
 * This class represents the following YANG schema fragment defined in module <b>nc-notifications</b>
 * <pre>
 * notification replayComplete {
 *     description
 *         "This notification is sent to signal the end of a replay
 *         portion of a subscription.";
 * }
 * </pre>The schema path to identify an instance is
 * <i>nc-notifications/replayComplete</i>
 *
 * <p>To create instances of this class use {@link ReplayCompleteBuilder}.
 * @see ReplayCompleteBuilder
 *
 */
public interface ReplayComplete
    extends
    DataObject,
    Augmentable<org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.netmod.notification.rev080714.ReplayComplete>,
    Notification
{



    public static final QName QNAME = org.opendaylight.yangtools.yang.common.QName.create("urn:ietf:params:xml:ns:netmod:notification",
        "2008-07-14", "replayComplete").intern();


}

