package org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.netmod.notification.rev080714.netconf;
import org.opendaylight.yangtools.yang.binding.ChildOf;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.netmod.notification.rev080714.Netconf;
import org.opendaylight.yangtools.yang.common.QName;
import java.util.List;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.netmod.notification.rev080714.netconf.streams.Stream;
import org.opendaylight.yangtools.yang.binding.Augmentable;

/**
 * The list of event streams supported by the system. Whena query is issued, the 
 * returned set of streams isdetermined based on user privileges.
 *
 * <p>
 * This class represents the following YANG schema fragment defined in module <b>nc-notifications</b>
 * <pre>
 * container streams {
 *     list stream {
 *         key "name";
 *         leaf name {
 *             type streamNameType;
 *         }
 *         leaf description {
 *             type string;
 *         }
 *         leaf replaySupport {
 *             type boolean;
 *         }
 *         leaf replayLogCreationTime {
 *             type date-and-time;
 *         }
 *     }
 * }
 * </pre>The schema path to identify an instance is
 * <i>nc-notifications/netconf/streams</i>
 *
 * <p>To create instances of this class use {@link StreamsBuilder}.
 * @see StreamsBuilder
 *
 */
public interface Streams
    extends
    ChildOf<Netconf>,
    Augmentable<org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.netmod.notification.rev080714.netconf.Streams>
{



    public static final QName QNAME = org.opendaylight.yangtools.yang.common.QName.create("urn:ietf:params:xml:ns:netmod:notification",
        "2008-07-14", "streams").intern();

    /**
     * Stream name, description and other information.
     *
     *
     *
     * @return <code>java.util.List</code> <code>stream</code>, or <code>null</code> if not present
     */
    List<Stream> getStream();

}

