package org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.netmod.notification.rev080714.netconf.streams;
import org.opendaylight.yangtools.yang.binding.ChildOf;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.netconf.notification._1._0.rev080714.StreamNameType;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.yang.types.rev130715.DateAndTime;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.netmod.notification.rev080714.netconf.Streams;
import org.opendaylight.yangtools.yang.binding.Augmentable;
import org.opendaylight.yangtools.yang.binding.Identifiable;

/**
 * Stream name, description and other information.
 *
 * <p>
 * This class represents the following YANG schema fragment defined in module <b>nc-notifications</b>
 * <pre>
 * list stream {
 *     key "name";
 *     leaf name {
 *         type streamNameType;
 *     }
 *     leaf description {
 *         type string;
 *     }
 *     leaf replaySupport {
 *         type boolean;
 *     }
 *     leaf replayLogCreationTime {
 *         type date-and-time;
 *     }
 * }
 * </pre>The schema path to identify an instance is
 * <i>nc-notifications/netconf/streams/stream</i>
 *
 * <p>To create instances of this class use {@link StreamBuilder}.
 * @see StreamBuilder
 * @see StreamKey
 *
 */
public interface Stream
    extends
    ChildOf<Streams>,
    Augmentable<org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.netmod.notification.rev080714.netconf.streams.Stream>,
    Identifiable<StreamKey>
{



    public static final QName QNAME = org.opendaylight.yangtools.yang.common.QName.create("urn:ietf:params:xml:ns:netmod:notification",
        "2008-07-14", "stream").intern();

    /**
     * The name of the event stream. If this is the defaultNETCONF stream, this must 
     * have the value 'NETCONF'.
     *
     *
     *
     * @return <code>org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.netconf.notification._1._0.rev080714.StreamNameType</code> <code>name</code>, or <code>null</code> if not present
     */
    StreamNameType getName();
    
    /**
     * A description of the event stream, including suchinformation as the type of 
     * events that are sent overthis stream.
     *
     *
     *
     * @return <code>java.lang.String</code> <code>description</code>, or <code>null</code> if not present
     */
    java.lang.String getDescription();
    
    /**
     * A description of the event stream, including suchinformation as the type of 
     * events that are sent overthis stream.
     *
     *
     *
     * @return <code>java.lang.Boolean</code> <code>replaySupport</code>, or <code>null</code> if not present
     */
    java.lang.Boolean isReplaySupport();
    
    /**
     * The timestamp of the creation of the log used to supportthe replay function on 
     * this stream. Note that this mightbe earlier then the earliest available 
     * notification inthe log. This object is updated if the log resets forsome reason.
     * This object MUST be present if replay issupported.
     *
     *
     *
     * @return <code>org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.yang.types.rev130715.DateAndTime</code> <code>replayLogCreationTime</code>, or <code>null</code> if not present
     */
    DateAndTime getReplayLogCreationTime();
    
    /**
     * Returns Primary Key of Yang List Type
     *
     *
     *
     * @return <code>org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.netmod.notification.rev080714.netconf.streams.StreamKey</code> <code>key</code>, or <code>null</code> if not present
     */
    StreamKey getKey();

}

