package org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.netconf.notifications.rev120206;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.netconf.notifications.rev120206.changed.by.parms.ChangedBy;
import org.opendaylight.yangtools.yang.common.QName;

/**
 * Common parameters to identify the sourceof a change event, such as a 
 * configurationor capability change.
 *
 * <p>
 * This class represents the following YANG schema fragment defined in module <b>ietf-netconf-notifications</b>
 * <pre>
 * grouping changed-by-parms {
 *     container changed-by {
 *         choice server-or-user {
 *             case by-user {
 *                 leaf username {
 *                     type string;
 *                 }
 *                 leaf session-id {
 *                     type session-id-or-zero-type;
 *                 }
 *                 leaf source-host {
 *                     type ip-address;
 *                 }
 *             }
 *             case server {
 *                 leaf server {
 *                     type empty;
 *                 }
 *             }
 *         }
 *     }
 * }
 * </pre>The schema path to identify an instance is
 * <i>ietf-netconf-notifications/changed-by-parms</i>
 *
 */
public interface ChangedByParms
    extends
    DataObject
{



    public static final QName QNAME = org.opendaylight.yangtools.yang.common.QName.create("urn:ietf:params:xml:ns:yang:ietf-netconf-notifications",
        "2012-02-06", "changed-by-parms").intern();

    /**
     * Indicates the source of the change.If caused by internal action, then theempty 
     * leaf 'server' will be present.If caused by a management session, thenthe name, 
     * remote host address, and session IDof the session that made the change will be 
     * reported.
     *
     *
     *
     * @return <code>org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.netconf.notifications.rev120206.changed.by.parms.ChangedBy</code> <code>changedBy</code>, or <code>null</code> if not present
     */
    ChangedBy getChangedBy();

}

