package org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.netconf.notifications.rev120206;
import org.opendaylight.yangtools.yang.binding.NotificationListener;

/**
 * Interface for implementing the following YANG notifications defined in module <b>ietf-netconf-notifications</b>
 * <pre>
 * notification netconf-confirmed-commit {
 *     description
 *         "Generated when a NETCONF server detects that a
 *         confirmed-commit event has occurred.  Indicates the event
 *         and the current state of the confirmed-commit procedure
 *         in progress.";
 *     leaf username {
 *         type string;
 *     }
 *     leaf session-id {
 *         type session-id-or-zero-type;
 *     }
 *     leaf source-host {
 *         type ip-address;
 *     }
 *     leaf confirm-event {
 *         type enumeration;
 *     }
 *     leaf timeout {
 *         type timeout;
 *     }
 *     uses common-session-parms;
 *     reference
 *         "RFC 6241, Section 8.4";
 * }
 * notification netconf-session-start {
 *     description
 *         "Generated when a NETCONF server detects that a
 *         NETCONF session has started.  A server MAY generate
 *         this event for non-NETCONF management sessions.
 *         Indicates the identity of the user that started
 *         the session.";
 *     leaf username {
 *         type string;
 *     }
 *     leaf session-id {
 *         type session-id-or-zero-type;
 *     }
 *     leaf source-host {
 *         type ip-address;
 *     }
 *     uses common-session-parms;
 * }
 * notification netconf-session-end {
 *     description
 *         "Generated when a NETCONF server detects that a
 *         NETCONF session has terminated.
 *         A server MAY optionally generate this event for
 *         non-NETCONF management sessions.  Indicates the
 *         identity of the user that owned the session,
 *         and why the session was terminated.";
 *     leaf username {
 *         type string;
 *     }
 *     leaf session-id {
 *         type session-id-or-zero-type;
 *     }
 *     leaf source-host {
 *         type ip-address;
 *     }
 *     leaf killed-by {
 *         type session-id-type;
 *     }
 *     leaf termination-reason {
 *         type enumeration;
 *     }
 *     uses common-session-parms;
 * }
 * notification netconf-capability-change {
 *     description
 *         "Generated when the NETCONF server detects that
 *         the server capabilities have changed.
 *         Indicates which capabilities have been added, deleted,
 *         and/or modified.  The manner in which a server
 *         capability is changed is outside the scope of this
 *         document.";
 *     container changed-by {
 *         choice server-or-user {
 *             case by-user {
 *                 leaf username {
 *                     type string;
 *                 }
 *                 leaf session-id {
 *                     type session-id-or-zero-type;
 *                 }
 *                 leaf source-host {
 *                     type ip-address;
 *                 }
 *             }
 *             case server {
 *                 leaf server {
 *                     type empty;
 *                 }
 *             }
 *         }
 *     }
 *     leaf-list added-capability {
 *         type uri;
 *     }
 *     leaf-list deleted-capability {
 *         type uri;
 *     }
 *     leaf-list modified-capability {
 *         type uri;
 *     }
 *     uses changed-by-parms;
 * }
 * notification netconf-config-change {
 *     description
 *         "Generated when the NETCONF server detects that the
 *         &lt;running&gt; or &lt;startup&gt; configuration datastore
 *         has been changed by a management session.
 *         The notification summarizes the edits that
 *         have been detected.
 *         
 *         The server MAY choose to also generate this
 *         notification while loading a datastore during the
 *         boot process for the device.";
 *     container changed-by {
 *         choice server-or-user {
 *             case by-user {
 *                 leaf username {
 *                     type string;
 *                 }
 *                 leaf session-id {
 *                     type session-id-or-zero-type;
 *                 }
 *                 leaf source-host {
 *                     type ip-address;
 *                 }
 *             }
 *             case server {
 *                 leaf server {
 *                     type empty;
 *                 }
 *             }
 *         }
 *     }
 *     leaf datastore {
 *         type datastore;
 *     }
 *     list edit {
 *         leaf target {
 *             type instance-identifier;
 *         }
 *         leaf operation {
 *             type edit-operation-type;
 *         }
 *     }
 *     uses changed-by-parms;
 * }
 * </pre>
 *
 */
public interface IetfNetconfNotificationsListener
    extends
    NotificationListener
{




    /**
     * Generated when a NETCONF server detects that aconfirmed-commit event has 
     * occurred. Indicates the eventand the current state of the confirmed-commit 
     * procedurein progress.
     *
     */
    void onNetconfConfirmedCommit(NetconfConfirmedCommit notification);
    
    /**
     * Generated when a NETCONF server detects that aNETCONF session has started. A 
     * server MAY generatethis event for non-NETCONF management sessions.Indicates the 
     * identity of the user that startedthe session.
     *
     */
    void onNetconfSessionStart(NetconfSessionStart notification);
    
    /**
     * Generated when a NETCONF server detects that aNETCONF session has terminated.A 
     * server MAY optionally generate this event fornon-NETCONF management sessions. 
     * Indicates theidentity of the user that owned the session,and why the session was
     * terminated.
     *
     */
    void onNetconfSessionEnd(NetconfSessionEnd notification);
    
    /**
     * Generated when the NETCONF server detects thatthe server capabilities have 
     * changed.Indicates which capabilities have been added, deleted,and/or modified. 
     * The manner in which a servercapability is changed is outside the scope of 
     * thisdocument.
     *
     */
    void onNetconfCapabilityChange(NetconfCapabilityChange notification);
    
    /**
     * Generated when the NETCONF server detects that the&amp;lt;running&amp;gt; or 
     * &amp;lt;startup&amp;gt; configuration datastorehas been changed by a management 
     * session.The notification summarizes the edits thathave been detected.The server 
     * MAY choose to also generate thisnotification while loading a datastore during 
     * theboot process for the device.
     *
     */
    void onNetconfConfigChange(NetconfConfigChange notification);

}

