package org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.netconf.notifications.rev120206;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.yang.common.QName;
import java.util.List;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.netconf.notifications.rev120206.netconf.config.change.Edit;
import org.opendaylight.yangtools.yang.binding.Augmentable;
import org.opendaylight.yangtools.yang.binding.Notification;

/**
 * Generated when the NETCONF server detects that the&lt;running&gt; or 
 * &lt;startup&gt; configuration datastorehas been changed by a management 
 * session.The notification summarizes the edits thathave been detected.The server 
 * MAY choose to also generate thisnotification while loading a datastore during 
 * theboot process for the device.
 *
 * <p>
 * This class represents the following YANG schema fragment defined in module <b>ietf-netconf-notifications</b>
 * <pre>
 * notification netconf-config-change {
 *     description
 *         "Generated when the NETCONF server detects that the
 *         &lt;running&gt; or &lt;startup&gt; configuration datastore
 *         has been changed by a management session.
 *         The notification summarizes the edits that
 *         have been detected.
 *         
 *         The server MAY choose to also generate this
 *         notification while loading a datastore during the
 *         boot process for the device.";
 *     container changed-by {
 *         choice server-or-user {
 *             case by-user {
 *                 leaf username {
 *                     type string;
 *                 }
 *                 leaf session-id {
 *                     type session-id-or-zero-type;
 *                 }
 *                 leaf source-host {
 *                     type ip-address;
 *                 }
 *             }
 *             case server {
 *                 leaf server {
 *                     type empty;
 *                 }
 *             }
 *         }
 *     }
 *     leaf datastore {
 *         type datastore;
 *     }
 *     list edit {
 *         leaf target {
 *             type instance-identifier;
 *         }
 *         leaf operation {
 *             type edit-operation-type;
 *         }
 *     }
 *     uses changed-by-parms;
 * }
 * </pre>The schema path to identify an instance is
 * <i>ietf-netconf-notifications/netconf-config-change</i>
 *
 * <p>To create instances of this class use {@link NetconfConfigChangeBuilder}.
 * @see NetconfConfigChangeBuilder
 *
 */
public interface NetconfConfigChange
    extends
    DataObject,
    Augmentable<org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.netconf.notifications.rev120206.NetconfConfigChange>,
    ChangedByParms,
    Notification
{


    public enum Datastore {
        /**
         * The &amp;lt;running&amp;gt; datastore has changed.
         *
         */
        Running(0, "running"),
        
        /**
         * The &amp;lt;startup&amp;gt; datastore has changed
         *
         */
        Startup(1, "startup")
        ;
    
        private static final java.util.Map<java.lang.Integer, Datastore> VALUE_MAP;
    
        static {
            final com.google.common.collect.ImmutableMap.Builder<java.lang.Integer, Datastore> b = com.google.common.collect.ImmutableMap.builder();
            for (Datastore enumItem : Datastore.values()) {
                b.put(enumItem.value, enumItem);
            }
    
            VALUE_MAP = b.build();
        }
    
        private final java.lang.String name;
        private final int value;
    
        private Datastore(int value, java.lang.String name) {
            this.value = value;
            this.name = name;
        }
    
        /**
         * Returns the name of the enumeration item as it is specified in the input yang.
         *
         * @return the name of the enumeration item as it is specified in the input yang
         */
        public java.lang.String getName() {
            return name;
        }
    
        /**
         * @return integer value
         */
        public int getIntValue() {
            return value;
        }
    
        /**
         * @param valueArg integer value
         * @return corresponding Datastore item
         */
        public static Datastore forValue(int valueArg) {
            return VALUE_MAP.get(valueArg);
        }
    }

    public static final QName QNAME = org.opendaylight.yangtools.yang.common.QName.create("urn:ietf:params:xml:ns:yang:ietf-netconf-notifications",
        "2012-02-06", "netconf-config-change").intern();

    /**
     * Indicates which configuration datastore has changed.
     *
     *
     *
     * @return <code>org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.netconf.notifications.rev120206.NetconfConfigChange.Datastore</code> <code>datastore</code>, or <code>null</code> if not present
     */
    Datastore getDatastore();
    
    /**
     * An edit record SHOULD be present for each distinctedit operation that the server
     * has detected onthe target datastore. This list MAY be omittedif the detailed 
     * edit operations are not known.The server MAY report entries in this list 
     * forchanges not made by a NETCONF session (e.g., CLI).
     *
     *
     *
     * @return <code>java.util.List</code> <code>edit</code>, or <code>null</code> if not present
     */
    List<Edit> getEdit();

}

